/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.LibraryReference;
import org.eclipse.cdt.internal.core.model.LibraryReferenceArchive;
import org.eclipse.cdt.internal.core.model.LibraryReferenceShared;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;

public class CProject
extends CContainer
implements ICProject {
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";

    public CProject(ICElement iCElement, IProject iProject) {
        super(iCElement, (IResource)iProject, 11);
    }

    public IBinaryContainer getBinaryContainer() {
        return ((CProjectInfo)this.getElementInfo()).getBinaryContainer();
    }

    public IArchiveContainer getArchiveContainer() {
        return ((CProjectInfo)this.getElementInfo()).getArchiveContainer();
    }

    public IProject getProject() {
        return this.getUnderlyingResource().getProject();
    }

    public ICElement findElement(IPath iPath) throws CModelException {
        Object object;
        ICElement iCElement = null;
        if (iPath.isAbsolute()) {
            iCElement = CModelManager.getDefault().create(iPath);
        } else {
            object = this.getProject();
            if (object != null) {
                IPath iPath2 = object.getFullPath().append(iPath);
                iCElement = CModelManager.getDefault().create(iPath2);
            }
        }
        if (iCElement == null) {
            object = new CModelStatus(979, iPath);
            throw new CModelException((ICModelStatus)object);
        }
        return iCElement;
    }

    public static boolean hasCNature(IProject iProject) {
        try {
            return iProject.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected CElementInfo createElementInfo() {
        return new CProjectInfo(this);
    }

    public int hashCode() {
        return this.getProject().hashCode();
    }

    public ILibraryReference[] getLibraryReferences() throws CModelException {
        ArrayList<ILibraryReference> arrayList = new ArrayList<ILibraryReference>(5);
        IBinaryParser[] iBinaryParserArray = null;
        try {
            iBinaryParserArray = CCorePlugin.getDefault().getBinaryParser(this.getProject());
        }
        catch (CoreException coreException) {}
        IPathEntry[] iPathEntryArray = this.getResolvedPathEntries();
        int n = 0;
        while (n < iPathEntryArray.length) {
            ILibraryEntry iLibraryEntry;
            ILibraryReference iLibraryReference;
            if (iPathEntryArray[n].getEntryKind() == 1 && (iLibraryReference = CProject.getLibraryReference(this, iBinaryParserArray, iLibraryEntry = (ILibraryEntry)iPathEntryArray[n])) != null) {
                arrayList.add(iLibraryReference);
            }
            ++n;
        }
        return arrayList.toArray(new ILibraryReference[0]);
    }

    public static ILibraryReference getLibraryReference(ICProject iCProject, IBinaryParser[] iBinaryParserArray, ILibraryEntry iLibraryEntry) {
        if (iBinaryParserArray == null) {
            try {
                iBinaryParserArray = CCorePlugin.getDefault().getBinaryParser(iCProject.getProject());
            }
            catch (CoreException coreException) {}
        }
        Parent parent = null;
        if (iBinaryParserArray != null) {
            int n = 0;
            while (n < iBinaryParserArray.length) {
                try {
                    IBinaryParser.IBinaryFile iBinaryFile = iBinaryParserArray[n].getBinary(iLibraryEntry.getPath());
                    if (iBinaryFile != null) {
                        if (iBinaryFile.getType() == 8) {
                            parent = new LibraryReferenceArchive((ICElement)iCProject, iLibraryEntry, (IBinaryParser.IBinaryArchive)iBinaryFile);
                            break;
                        }
                        parent = new LibraryReferenceShared((ICElement)iCProject, iLibraryEntry, iBinaryFile);
                        break;
                    }
                }
                catch (IOException iOException) {}
                ++n;
            }
        }
        if (parent == null) {
            parent = new LibraryReference(iCProject, iLibraryEntry);
        }
        return parent;
    }

    public String[] getRequiredProjectNames() throws CModelException {
        return this.projectPrerequisites(this.getResolvedPathEntries());
    }

    public String[] projectPrerequisites(IPathEntry[] iPathEntryArray) throws CModelException {
        return PathEntryManager.getDefault().projectPrerequisites(iPathEntryArray);
    }

    public String getOption(String string, boolean bl) {
        if (CModelManager.OptionNames.contains(string)) {
            Preferences preferences = this.getPreferences();
            if (preferences == null || preferences.isDefault(string)) {
                return bl ? CCorePlugin.getOption(string) : null;
            }
            return preferences.getString(string).trim();
        }
        return null;
    }

    public Map getOptions(boolean bl) {
        String string;
        int n;
        String[] stringArray;
        HashMap hashMap = bl ? CCorePlugin.getOptions() : new HashMap(5);
        Preferences preferences = this.getPreferences();
        if (preferences == null) {
            return hashMap;
        }
        HashSet hashSet = CModelManager.OptionNames;
        if (bl) {
            stringArray = preferences.defaultPropertyNames();
            n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                if (hashSet.contains(string)) {
                    hashMap.put(string, preferences.getDefaultString(string).trim());
                }
                ++n;
            }
        }
        stringArray = preferences.propertyNames();
        n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (hashSet.contains(string)) {
                hashMap.put(string, preferences.getString(string).trim());
            }
            ++n;
        }
        return hashMap;
    }

    public void setOption(String string, String string2) {
        if (!CModelManager.OptionNames.contains(string)) {
            return;
        }
        Preferences preferences = this.getPreferences();
        preferences.setDefault(string, CUSTOM_DEFAULT_OPTION_VALUE);
        preferences.setValue(string, string2);
        this.savePreferences(preferences);
    }

    public void setOptions(Map map) {
        Preferences preferences = new Preferences();
        this.setPreferences(preferences);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!CModelManager.OptionNames.contains(string)) continue;
                String string2 = (String)map.get(string);
                preferences.setDefault(string, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(string, string2);
            }
        }
        this.savePreferences(preferences);
    }

    private Preferences getPreferences() {
        Preferences preferences = new Preferences();
        Iterator iterator = CModelManager.OptionNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring("org.eclipse.cdt.core".length() + 1);
            String string3 = null;
            try {
                string3 = this.resource.getPersistentProperty(new QualifiedName("org.eclipse.cdt.core", string2));
            }
            catch (CoreException coreException) {}
            if (string3 == null) continue;
            preferences.setValue(string, string3);
        }
        return preferences;
    }

    private void savePreferences(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        Iterator iterator = CModelManager.OptionNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring("org.eclipse.cdt.core".length() + 1);
            String string3 = null;
            try {
                string3 = preferences.getString(string);
                if (string3 != null && !string3.equals(preferences.getDefaultString(string))) {
                    this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", string2), string3);
                    continue;
                }
                this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", string2), null);
            }
            catch (CoreException coreException) {}
        }
    }

    private void setPreferences(Preferences preferences) {
    }

    public IPathEntry[] getResolvedPathEntries() throws CModelException {
        return CoreModel.getDefault().getResolvedClasspathEntries(this);
    }

    public IPathEntry[] getRawPathEntries() throws CModelException {
        return CoreModel.getDefault().getRawPathEntries(this);
    }

    public void setRawPathEntries(IPathEntry[] iPathEntryArray, IProgressMonitor iProgressMonitor) throws CModelException {
        CoreModel.getDefault().setRawPathEntries(this, iPathEntryArray, iProgressMonitor);
    }
}

