/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;

public abstract class MultiOperation
extends CModelOperation {
    protected String[] fRenamingsList = null;
    protected Map fParentElements;
    protected Map fInsertBeforeElements = new HashMap(1);
    protected Map fRenamings;

    protected MultiOperation(ICElement[] iCElementArray, ICElement[] iCElementArray2, boolean bl) {
        super(iCElementArray, iCElementArray2, bl);
        this.fParentElements = new HashMap(iCElementArray.length);
        if (iCElementArray.length == iCElementArray2.length) {
            int n = 0;
            while (n < iCElementArray.length) {
                this.fParentElements.put(iCElementArray[n], iCElementArray2[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < iCElementArray.length) {
                this.fParentElements.put(iCElementArray[n], iCElementArray2[0]);
                ++n;
            }
        }
    }

    protected MultiOperation(ICElement[] iCElementArray, boolean bl) {
        super(iCElementArray, bl);
    }

    protected void error(int n, ICElement iCElement) throws CModelException {
        throw new CModelException(new CModelStatus(n, iCElement));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws CModelException {
        try {
            this.processElements();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.mergeDeltas();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.mergeDeltas();
            return;
        }
    }

    protected ICElement getDestinationParent(ICElement iCElement) {
        return (ICElement)this.fParentElements.get(iCElement);
    }

    protected abstract String getMainTaskName();

    protected String getNewNameFor(ICElement iCElement) {
        if (this.fRenamings != null) {
            return (String)this.fRenamings.get(iCElement);
        }
        return null;
    }

    private void initializeRenamings() {
        if (this.fRenamingsList != null && this.fRenamingsList.length == this.fElementsToProcess.length) {
            this.fRenamings = new HashMap(this.fRenamingsList.length);
            int n = 0;
            while (n < this.fRenamingsList.length) {
                if (this.fRenamingsList[n] != null) {
                    this.fRenamings.put(this.fElementsToProcess[n], this.fRenamingsList[n]);
                }
                ++n;
            }
        }
    }

    protected boolean isMove() {
        return false;
    }

    protected boolean isRename() {
        return false;
    }

    protected void mergeDeltas() {
        if (this.fDeltas != null) {
            CElementDelta cElementDelta = this.newCElementDelta();
            boolean bl = false;
            int n = 0;
            while (n < this.fDeltas.length) {
                ICElementDelta iCElementDelta = this.fDeltas[n];
                ICElementDelta[] iCElementDeltaArray = iCElementDelta.getAffectedChildren();
                int n2 = 0;
                while (n2 < iCElementDeltaArray.length) {
                    CElementDelta cElementDelta2 = (CElementDelta)iCElementDeltaArray[n2];
                    cElementDelta.insertDeltaTree(cElementDelta2.getElement(), cElementDelta2);
                    bl = true;
                    ++n2;
                }
                ++n;
            }
            this.fDeltas = bl ? new ICElementDelta[]{cElementDelta} : null;
        }
    }

    protected abstract void processElement(ICElement var1) throws CModelException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processElements() throws CModelException {
        this.beginTask(this.getMainTaskName(), this.fElementsToProcess.length);
        ICModelStatus[] iCModelStatusArray = new ICModelStatus[3];
        int n = 0;
        int n2 = 0;
        while (true) {
            Object var5_5;
            if (n2 >= this.fElementsToProcess.length) {
                this.done();
                if (n != true) break;
                throw new CModelException(iCModelStatusArray[0]);
            }
            try {
                try {
                    this.verify(this.fElementsToProcess[n2]);
                    this.processElement(this.fElementsToProcess[n2]);
                }
                catch (CModelException cModelException) {
                    if (n == iCModelStatusArray.length) {
                        ICModelStatus[] iCModelStatusArray2 = iCModelStatusArray;
                        iCModelStatusArray = new ICModelStatus[n * 2];
                        System.arraycopy(iCModelStatusArray2, 0, iCModelStatusArray, 0, n);
                    }
                    iCModelStatusArray[n++] = cModelException.getCModelStatus();
                }
            }
            catch (Throwable throwable) {
                var5_5 = null;
                this.worked(1);
                throw throwable;
            }
            {
                var5_5 = null;
                this.worked(1);
                ++n2;
                continue;
            }
            break;
        }
        if (n <= 1) {
            return;
        }
        if (n != iCModelStatusArray.length) {
            ICModelStatus[] iCModelStatusArray3 = iCModelStatusArray;
            iCModelStatusArray = new ICModelStatus[n];
            System.arraycopy(iCModelStatusArray3, 0, iCModelStatusArray, 0, n);
        }
        throw new CModelException(CModelStatus.newMultiStatus(iCModelStatusArray));
    }

    public void setInsertBefore(ICElement iCElement, ICElement iCElement2) {
        this.fInsertBeforeElements.put(iCElement, iCElement2);
    }

    public void setRenamings(String[] stringArray) {
        this.fRenamingsList = stringArray;
        this.initializeRenamings();
    }

    protected abstract void verify(ICElement var1) throws CModelException;

    protected void verifyDestination(ICElement iCElement, ICElement iCElement2) throws CModelException {
        if (iCElement2 == null || !iCElement2.exists()) {
            this.error(969, iCElement2);
        }
    }

    protected void verifyRenaming(ICElement iCElement) throws CModelException {
        String string = this.getNewNameFor(iCElement);
        boolean bl = true;
        if (string.indexOf(32) != -1) {
            bl = false;
        }
        if (!bl) {
            throw new CModelException(new CModelStatus(983, iCElement, string));
        }
    }

    protected void verifySibling(ICElement iCElement, ICElement iCElement2) throws CModelException {
        ICElement iCElement3 = (ICElement)this.fInsertBeforeElements.get(iCElement);
        if (!(iCElement3 == null || iCElement3.exists() && iCElement3.getParent().equals(iCElement2))) {
            this.error(993, iCElement3);
        }
    }
}

