/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.CharArrayReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.DefaultProblemHandler;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class MatchLocator
implements ISourceElementRequestor,
ICSearchConstants {
    ArrayList matchStorage;
    public static boolean VERBOSE = false;
    private boolean shouldExcludeLocalDeclarations = false;
    private ISourceElementCallbackDelegate lastDeclaration;
    private ICSearchPattern searchPattern;
    private ICSearchResultCollector resultCollector;
    private IProgressMonitor progressMonitor;
    private IPath currentPath = null;
    private ICSearchScope searchScope;
    private IWorkspaceRoot workspaceRoot;
    private IResource currentResource = null;
    private LinkedList resourceStack = new LinkedList();
    private IASTScope currentScope = null;
    private LinkedList scopeStack = new LinkedList();

    public MatchLocator(ICSearchPattern iCSearchPattern, ICSearchResultCollector iCSearchResultCollector, ICSearchScope iCSearchScope, IProgressMonitor iProgressMonitor) {
        this.searchPattern = iCSearchPattern;
        this.resultCollector = iCSearchResultCollector;
        this.searchScope = iCSearchScope;
        this.progressMonitor = iProgressMonitor;
    }

    public boolean acceptProblem(IProblem iProblem) {
        return DefaultProblemHandler.ruleOnProblem((IProblem)iProblem, (ParserMode)ParserMode.COMPLETE_PARSE);
    }

    public void acceptUsingDirective(IASTUsingDirective iASTUsingDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration iASTUsingDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition iASTASMDefinition) {
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration) {
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
    }

    public void enterCodeBlock(IASTCodeScope iASTCodeScope) {
    }

    public void exitCodeBlock(IASTCodeScope iASTCodeScope) {
    }

    public void enterLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
        this.pushScope((IASTScope)iASTLinkageSpecification);
    }

    public void exitLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
        this.popScope();
    }

    public void acceptParameterReference(IASTParameterReference iASTParameterReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTParameterReference);
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration iASTTypedefDeclaration) {
        this.lastDeclaration = iASTTypedefDeclaration;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTTypedefDeclaration);
    }

    public void acceptTypedefReference(IASTTypedefReference iASTTypedefReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTTypedefReference);
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference iASTEnumeratorReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTEnumeratorReference);
    }

    public void acceptMacro(IASTMacro iASTMacro) {
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTMacro);
    }

    public void acceptVariable(IASTVariable iASTVariable) {
        this.lastDeclaration = iASTVariable;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTVariable);
        if (iASTVariable.getInitializerClause() != null || !iASTVariable.isExtern() && !(this.currentScope instanceof IASTLinkageSpecification)) {
            this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)iASTVariable);
        }
    }

    public void acceptField(IASTField iASTField) {
        this.lastDeclaration = iASTField;
        if (this.currentScope instanceof IASTClassSpecifier) {
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTField);
            if (!iASTField.isStatic()) {
                this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)iASTField);
            }
        } else {
            this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)iASTField);
        }
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        this.lastDeclaration = iASTEnumerationSpecifier;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTEnumerationSpecifier);
        Iterator iterator = iASTEnumerationSpecifier.getEnumerators();
        while (iterator.hasNext()) {
            IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator.next();
            this.lastDeclaration = iASTEnumerator;
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTEnumerator);
            this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)iASTEnumerator);
        }
    }

    public void acceptFunctionDeclaration(IASTFunction iASTFunction) {
        this.lastDeclaration = iASTFunction;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTFunction);
    }

    public void acceptMethodDeclaration(IASTMethod iASTMethod) {
        this.lastDeclaration = iASTMethod;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTMethod);
    }

    public void acceptClassReference(IASTClassReference iASTClassReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTClassReference);
    }

    public void acceptNamespaceReference(IASTNamespaceReference iASTNamespaceReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTNamespaceReference);
    }

    public void acceptVariableReference(IASTVariableReference iASTVariableReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTVariableReference);
    }

    public void acceptFieldReference(IASTFieldReference iASTFieldReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTFieldReference);
    }

    public void acceptEnumerationReference(IASTEnumerationReference iASTEnumerationReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTEnumerationReference);
    }

    public void acceptFunctionReference(IASTFunctionReference iASTFunctionReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTFunctionReference);
    }

    public void acceptMethodReference(IASTMethodReference iASTMethodReference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)iASTMethodReference);
    }

    public void enterFunctionBody(IASTFunction iASTFunction) {
        this.lastDeclaration = iASTFunction;
        if (!iASTFunction.previouslyDeclared()) {
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTFunction);
        }
        this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)iASTFunction);
        this.pushScope((IASTScope)iASTFunction);
    }

    public void enterMethodBody(IASTMethod iASTMethod) {
        this.lastDeclaration = iASTMethod;
        if (!iASTMethod.previouslyDeclared()) {
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTMethod);
        }
        this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)iASTMethod);
        this.pushScope((IASTScope)iASTMethod);
    }

    public void enterCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
        this.pushScope((IASTScope)iASTCompilationUnit);
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.lastDeclaration = iASTNamespaceDefinition;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTNamespaceDefinition);
        this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)iASTNamespaceDefinition);
        this.pushScope((IASTScope)iASTNamespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        this.lastDeclaration = iASTClassSpecifier;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTClassSpecifier);
        this.pushScope((IASTScope)iASTClassSpecifier);
    }

    public void exitFunctionBody(IASTFunction iASTFunction) {
        this.popScope();
    }

    public void exitMethodBody(IASTMethod iASTMethod) {
        this.popScope();
    }

    public void exitClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        this.popScope();
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.popScope();
    }

    public void exitCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
        this.popScope();
    }

    public void enterInclusion(IASTInclusion iASTInclusion) {
        String string = iASTInclusion.getFullFileName();
        Path path = new Path(string);
        IFile iFile = null;
        if (this.workspaceRoot != null) {
            iFile = this.workspaceRoot.getFileForLocation((IPath)path);
        }
        this.resourceStack.addFirst(this.currentResource != null ? this.currentResource : this.currentPath);
        this.currentResource = iFile;
        this.currentPath = iFile == null ? path : null;
    }

    public void exitInclusion(IASTInclusion iASTInclusion) {
        Object e = this.resourceStack.removeFirst();
        if (e instanceof IResource) {
            this.currentResource = (IResource)e;
            this.currentPath = null;
        } else {
            this.currentPath = (IPath)e;
            this.currentResource = null;
        }
    }

    public void locateMatches(String[] object, IWorkspace iWorkspace, IWorkingCopy[] iWorkingCopyArray, ArrayList arrayList) throws InterruptedException {
        Object object2;
        Object object3;
        int n;
        int n2;
        this.matchStorage = arrayList;
        this.workspaceRoot = iWorkspace != null ? iWorkspace.getRoot() : null;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        int n3 = n2 = iWorkingCopyArray == null ? 0 : iWorkingCopyArray.length;
        if (n2 > 0) {
            String[] stringArray = new String[n2];
            n = 0;
            while (n < n2) {
                object3 = iWorkingCopyArray[n];
                object2 = object3.getOriginalElement().getPath().toString();
                hashMap.put((String)object2, (String[])object3);
                stringArray[n] = object2;
                ++n;
            }
            n = ((String[])object).length;
            object3 = new String[n + n2];
            System.arraycopy(object, 0, object3, 0, n);
            System.arraycopy(stringArray, 0, object3, n, n2);
            object = object3;
        }
        Arrays.sort(object);
        int n4 = ((String[])object).length;
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask("", n4);
        }
        n = 0;
        while (n < n4) {
            block24: {
                if (this.progressMonitor != null) {
                    if (this.progressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.progressMonitor.worked(1);
                }
                object3 = object[n];
                if ((n <= 0 || !((String)object3).equals(object[n - 1])) && this.searchScope.encloses((String)object3)) {
                    IScannerInfo iScannerInfo;
                    IScannerInfoProvider iScannerInfoProvider;
                    IWorkingCopy iWorkingCopy;
                    IProject iProject;
                    IPath iPath;
                    block23: {
                        object2 = null;
                        iPath = null;
                        iProject = null;
                        if (this.workspaceRoot != null) {
                            iWorkingCopy = (IWorkingCopy)hashMap.get(object3);
                            if (iWorkingCopy != null) {
                                object2 = new CharArrayReader(iWorkingCopy.getContents());
                                this.currentResource = iWorkingCopy.getResource();
                                iPath = this.currentResource.getLocation();
                                iProject = this.currentResource.getProject();
                            } else {
                                this.currentResource = this.workspaceRoot.findMember((String)object3, true);
                                try {
                                    if (this.currentResource == null || !(this.currentResource instanceof IFile)) break block23;
                                    iScannerInfoProvider = (IFile)this.currentResource;
                                    object2 = new InputStreamReader(iScannerInfoProvider.getContents());
                                    iPath = this.currentResource.getLocation();
                                    iProject = iScannerInfoProvider.getProject();
                                }
                                catch (CoreException coreException) {
                                    break block24;
                                }
                            }
                        }
                    }
                    if (this.currentResource == null) {
                        iWorkingCopy = new Path((String)object3);
                        try {
                            this.currentPath = iWorkingCopy;
                            object2 = new FileReader(iWorkingCopy.toFile());
                            iPath = this.currentPath;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            break block24;
                        }
                    }
                    iWorkingCopy = new ScannerInfo();
                    iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
                    if (iScannerInfoProvider != null && (iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject)) != null) {
                        iWorkingCopy = new ScannerInfo(iScannerInfo.getDefinedSymbols(), iScannerInfo.getIncludePaths());
                    }
                    iScannerInfo = null;
                    iScannerInfo = iProject != null ? (CoreModel.getDefault().hasCCNature(iProject) ? ParserLanguage.CPP : ParserLanguage.C) : ParserLanguage.CPP;
                    IParser iParser = null;
                    try {
                        IScanner iScanner = ParserFactory.createScanner((Reader)object2, (String)iPath.toOSString(), (IScannerInfo)iWorkingCopy, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)iScannerInfo, (ISourceElementRequestor)this, (IParserLogService)ParserUtil.getScannerLogService());
                        iParser = ParserFactory.createParser((IScanner)iScanner, (ISourceElementRequestor)this, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)iScannerInfo, (IParserLogService)ParserUtil.getParserLogService());
                    }
                    catch (ParserFactoryError parserFactoryError) {}
                    if (VERBOSE) {
                        MatchLocator.verbose("*** New Search for path: " + (String)object3);
                    }
                    try {
                        iParser.parse();
                    }
                    catch (Exception exception) {
                        if (VERBOSE) {
                            exception.printStackTrace();
                        }
                    }
                    catch (VirtualMachineError virtualMachineError) {
                        if (!VERBOSE) break block24;
                        MatchLocator.verbose("MatchLocator VM Error: ");
                        virtualMachineError.printStackTrace();
                    }
                }
            }
            ++n;
        }
    }

    protected void report(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, int n) {
        try {
            Object object;
            if (this.currentResource != null && !this.searchScope.encloses(this.currentResource.getFullPath().toOSString())) {
                return;
            }
            int n2 = 0;
            int n3 = 0;
            if (iSourceElementCallbackDelegate instanceof IASTReference) {
                object = (IASTReference)iSourceElementCallbackDelegate;
                n2 = object.getOffset();
                n3 = n2 + object.getName().length();
                if (VERBOSE) {
                    MatchLocator.verbose("Report Match: " + object.getName());
                }
            } else if (iSourceElementCallbackDelegate instanceof IASTOffsetableNamedElement) {
                object = (IASTOffsetableNamedElement)iSourceElementCallbackDelegate;
                n2 = object.getNameOffset() != 0 ? object.getNameOffset() : object.getStartingOffset();
                n3 = object.getNameEndOffset();
                if (n3 == 0) {
                    n3 = n2 + object.getName().length();
                }
                if (VERBOSE) {
                    MatchLocator.verbose("Report Match: " + object.getName());
                }
            }
            object = null;
            ISourceElementCallbackDelegate iSourceElementCallbackDelegate2 = null;
            if (iSourceElementCallbackDelegate instanceof IASTReference) {
                iSourceElementCallbackDelegate2 = this.currentScope instanceof IASTFunction || this.currentScope instanceof IASTMethod ? (ISourceElementCallbackDelegate)this.currentScope : this.lastDeclaration;
            } else if (this.currentScope instanceof IASTFunction || this.currentScope instanceof IASTMethod) {
                if (this.shouldExcludeLocalDeclarations) {
                    return;
                }
                iSourceElementCallbackDelegate2 = (ISourceElementCallbackDelegate)this.currentScope;
            } else {
                iSourceElementCallbackDelegate2 = iSourceElementCallbackDelegate;
            }
            if (this.currentResource != null) {
                object = this.resultCollector.createMatch(this.currentResource, n2, n3, iSourceElementCallbackDelegate2);
            } else if (this.currentPath != null) {
                object = this.resultCollector.createMatch(this.currentPath, n2, n3, iSourceElementCallbackDelegate2);
            }
            if (object != null) {
                this.matchStorage.add(object);
            }
        }
        catch (CoreException coreException) {}
    }

    private void check(ICSearchConstants.LimitTo limitTo, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
        if (!this.searchPattern.canAccept(limitTo)) {
            return;
        }
        int n = 0;
        n = iSourceElementCallbackDelegate instanceof IASTReference ? this.searchPattern.matchLevel(((IASTReference)iSourceElementCallbackDelegate).getReferencedElement(), limitTo) : this.searchPattern.matchLevel(iSourceElementCallbackDelegate, limitTo);
        if (n != 0) {
            this.report(iSourceElementCallbackDelegate, n);
        }
    }

    private void pushScope(IASTScope iASTScope) {
        this.scopeStack.addFirst(this.currentScope);
        this.currentScope = iASTScope;
    }

    private IASTScope popScope() {
        IASTScope iASTScope = this.currentScope;
        this.currentScope = this.scopeStack.size() > 0 ? (IASTScope)this.scopeStack.removeFirst() : null;
        return iASTScope;
    }

    public void setShouldExcludeLocalDeclarations(boolean bl) {
        this.shouldExcludeLocalDeclarations = bl;
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)iASTElaboratedTypeSpecifier);
    }

    public static void verbose(String string) {
        System.out.println("(" + Thread.currentThread() + ") " + string);
    }

    public Reader createReader(String string) {
        return ParserUtil.createReader(string);
    }
}

