/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.sourcedependency;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.search.PathCollector;
import org.eclipse.cdt.internal.core.search.PatternSearchJob;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class UpdateDependency
implements IJob {
    PathCollector pathCollector;
    IResource resource;

    public UpdateDependency(IResource iResource) {
        this.resource = iResource;
    }

    public boolean belongsTo(String string) {
        return false;
    }

    public void cancel() {
    }

    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (this.resource == null) {
            return false;
        }
        IPath iPath = this.resource.getLocation();
        if (iPath == null) {
            return false;
        }
        PathCollector pathCollector = new PathCollector();
        ICSearchScope iCSearchScope = SearchEngine.createWorkspaceScope();
        CSearchPattern cSearchPattern = CSearchPattern.createPattern(iPath.toOSString(), ICSearchConstants.INCLUDE, ICSearchConstants.REFERENCES, 0, true);
        IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        indexManager.performConcurrentJob(new PatternSearchJob(cSearchPattern, iCSearchScope, pathCollector, indexManager), 3, null, this);
        String[] stringArray = pathCollector.getPaths();
        int n = 0;
        while (n < stringArray.length) {
            Path path = new Path(stringArray[n]);
            IWorkspaceRoot iWorkspaceRoot = this.resource.getWorkspace().getRoot();
            IFile iFile = iWorkspaceRoot.getFile((IPath)path);
            if (iFile != null && iFile.exists()) {
                indexManager.addSource(iFile, iFile.getProject().getProject().getFullPath());
            }
            ++n;
        }
        return false;
    }

    public boolean isReadyToRun() {
        return true;
    }
}

