/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.elf.ERandomAccessFile;

public class Elf {
    protected ERandomAccessFile efile;
    protected ELFhdr ehdr;
    protected Section[] sections;
    protected Addr2line addr2line;
    protected boolean cppFiltEnabled = true;
    protected CPPFilt cppFilt;
    protected String file;
    protected byte[] section_strtab;
    private int syms = 0;
    private Symbol[] symbols;
    private Symbol[] symtab_symbols;
    private Section symtab_sym;
    private Symbol[] dynsym_symbols;
    private Section dynsym_sym;
    protected String EMPTY_STRING = "";

    protected String string_from_elf_section(Section section, int n) throws IOException {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        if ((long)n > section.sh_size) {
            return this.EMPTY_STRING;
        }
        this.efile.seek(section.sh_offset + (long)n);
        while ((by = this.efile.readByte()) != 0) {
            stringBuffer.append((char)by);
        }
        return stringBuffer.toString();
    }

    public PHdr[] getPHdrs() throws IOException {
        if (this.ehdr.e_phnum == 0) {
            return new PHdr[0];
        }
        this.efile.seek(this.ehdr.e_phoff);
        PHdr[] pHdrArray = new PHdr[this.ehdr.e_phnum];
        int n = 0;
        while (n < this.ehdr.e_phnum) {
            pHdrArray[n] = new PHdr();
            pHdrArray[n].p_type = this.efile.readIntE();
            pHdrArray[n].p_offset = this.efile.readIntE();
            pHdrArray[n].p_vaddr = this.efile.readIntE();
            pHdrArray[n].p_paddr = this.efile.readIntE();
            pHdrArray[n].p_filesz = this.efile.readIntE();
            pHdrArray[n].p_memsz = this.efile.readIntE();
            pHdrArray[n].p_flags = this.efile.readIntE();
            pHdrArray[n].p_align = this.efile.readIntE();
            ++n;
        }
        return pHdrArray;
    }

    public Dynamic[] getDynamicSections(Section section) throws IOException {
        if (section.sh_type != 6L) {
            return new Dynamic[0];
        }
        ArrayList<Dynamic> arrayList = new ArrayList<Dynamic>();
        this.efile.seek(section.sh_offset);
        int n = 0;
        while ((long)n < section.sh_size) {
            Dynamic dynamic = new Dynamic(section, this.efile.readIntE(), this.efile.readIntE());
            if (dynamic.d_tag == 0L) break;
            arrayList.add(dynamic);
            n += 8;
        }
        return arrayList.toArray(new Dynamic[0]);
    }

    /*
     * Exception decompiling
     */
    private void commonSetup(String var1_1, long var2_2, boolean var4_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 71->75)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Elf() {
    }

    public Elf(String string, long l) throws IOException {
        this.commonSetup(string, l, true);
    }

    public Elf(String string) throws IOException {
        this.commonSetup(string, 0L, true);
    }

    public Elf(String string, long l, boolean bl) throws IOException {
        this.commonSetup(string, l, bl);
    }

    public Elf(String string, boolean bl) throws IOException {
        this.commonSetup(string, 0L, bl);
    }

    public boolean cppFilterEnabled() {
        return this.cppFiltEnabled;
    }

    public void setCppFilter(boolean bl) {
        this.cppFiltEnabled = bl;
    }

    public ELFhdr getELFhdr() throws IOException {
        return this.ehdr;
    }

    public Attribute getAttributes() throws IOException {
        Attribute attribute = new Attribute();
        switch (this.ehdr.e_type) {
            case 4: {
                attribute.type = 4;
                break;
            }
            case 2: {
                attribute.type = 1;
                break;
            }
            case 1: {
                attribute.type = 3;
                break;
            }
            case 3: {
                attribute.type = 2;
            }
        }
        switch (this.ehdr.e_machine) {
            case 3: 
            case 6: {
                attribute.cpu = "x86";
                break;
            }
            case 4: {
                attribute.cpu = "m68k";
                break;
            }
            case 11: 
            case 20: 
            case 36901: {
                attribute.cpu = "ppc";
                break;
            }
            case 21: {
                attribute.cpu = "ppc64";
                break;
            }
            case 42: {
                attribute.cpu = "sh";
                break;
            }
            case 40: {
                attribute.cpu = "arm";
                break;
            }
            case 8: 
            case 10: {
                attribute.cpu = "mips";
                break;
            }
            case 2: 
            case 18: 
            case 43: {
                attribute.cpu = "sparc";
                break;
            }
            case 46: 
            case 47: {
                attribute.cpu = "h8300";
                break;
            }
            case 87: 
            case 36992: {
                attribute.cpu = "v850";
                break;
            }
            case 89: 
            case 48879: {
                attribute.cpu = "mn10300";
                break;
            }
            case 90: 
            case 57005: {
                attribute.cpu = "mn10200";
                break;
            }
            case 88: {
                attribute.cpu = "m32r";
                break;
            }
            case 84: 
            case 13104: {
                attribute.cpu = "fr30";
                break;
            }
            case 44357: {
                attribute.cpu = "xstormy16";
                break;
            }
            case 21569: {
                attribute.cpu = "frv";
                break;
            }
            case 65210: {
                attribute.cpu = "iq2000";
                break;
            }
            default: {
                attribute.cpu = "none";
            }
        }
        switch (this.ehdr.e_ident[5]) {
            case 1: {
                attribute.isle = true;
                break;
            }
            case 2: {
                attribute.isle = false;
            }
        }
        Section[] sectionArray = this.getSections();
        if (sectionArray != null) {
            int n = 0;
            while (n < sectionArray.length) {
                String string = sectionArray[n].toString();
                if (string.equals(".debug_info")) {
                    attribute.debugType = 2;
                    break;
                }
                if (string.equals(".stab")) {
                    attribute.debugType = 1;
                    break;
                }
                ++n;
            }
        }
        return attribute;
    }

    public static Attribute getAttributes(String string) throws IOException {
        Elf elf = new Elf(string);
        Attribute attribute = elf.getAttributes();
        elf.dispose();
        return attribute;
    }

    public static Attribute getAttributes(byte[] byArray) throws IOException {
        Elf elf = new Elf();
        elf.ehdr = elf.new ELFhdr(byArray);
        elf.sections = new Section[0];
        Attribute attribute = elf.getAttributes();
        elf.dispose();
        return attribute;
    }

    public static boolean isElfHeader(byte[] byArray) {
        return byArray.length >= 4 && byArray[0] == 127 && byArray[1] == 69 && byArray[2] == 76 && byArray[3] == 70;
    }

    public void dispose() {
        if (this.addr2line != null) {
            this.addr2line.dispose();
        }
        if (this.cppFilt != null) {
            this.cppFilt.dispose();
        }
        try {
            if (this.efile != null) {
                this.efile.close();
                this.efile = null;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public Section getSectionByName(String string) throws IOException {
        if (this.sections == null) {
            this.getSections();
        }
        int n = 0;
        while (n < this.sections.length) {
            if (this.sections[n].toString().equals(string)) {
                return this.sections[n];
            }
            ++n;
        }
        return null;
    }

    public Section[] getSections(int n) throws IOException {
        if (this.sections == null) {
            this.getSections();
        }
        ArrayList<Section> arrayList = new ArrayList<Section>();
        int n2 = 0;
        while (n2 < this.sections.length) {
            if (this.sections[n2].sh_type == (long)n) {
                arrayList.add(this.sections[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new Section[0]);
    }

    public Section[] getSections() throws IOException {
        if (this.sections == null) {
            if (this.ehdr.e_shoff == 0L) {
                this.sections = new Section[0];
                return this.sections;
            }
            this.efile.seek(this.ehdr.e_shoff);
            this.sections = new Section[this.ehdr.e_shnum];
            int n = 0;
            while (n < this.ehdr.e_shnum) {
                this.sections[n] = new Section();
                this.sections[n].sh_name = this.efile.readIntE();
                this.sections[n].sh_type = this.efile.readIntE();
                this.sections[n].sh_flags = this.efile.readIntE();
                this.sections[n].sh_addr = this.efile.readIntE();
                this.sections[n].sh_offset = this.efile.readIntE();
                this.sections[n].sh_size = this.efile.readIntE();
                this.sections[n].sh_link = this.efile.readIntE();
                this.sections[n].sh_info = this.efile.readIntE();
                this.sections[n].sh_addralign = this.efile.readIntE();
                this.sections[n].sh_entsize = this.efile.readIntE();
                if (this.sections[n].sh_type == 2L) {
                    this.syms = n;
                }
                if (this.syms == 0 && this.sections[n].sh_type == 11L) {
                    this.syms = n;
                }
                ++n;
            }
        }
        return this.sections;
    }

    private Symbol[] loadSymbolsBySection(Section section) throws IOException {
        int n = 1;
        if (section.sh_entsize != 0L) {
            n = (int)section.sh_size / (int)section.sh_entsize;
        }
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>(n);
        int n2 = 0;
        while (n2 < n) {
            this.efile.seek(section.sh_offset + section.sh_entsize * (long)n2);
            Symbol symbol = new Symbol(section);
            symbol.st_name = this.efile.readIntE();
            symbol.st_value = this.efile.readIntE();
            symbol.st_size = this.efile.readIntE();
            symbol.st_info = this.efile.readByte();
            symbol.st_other = this.efile.readByte();
            symbol.st_shndx = this.efile.readShortE();
            if (symbol.st_info != 0) {
                arrayList.add(symbol);
            }
            ++n2;
        }
        Object[] objectArray = arrayList.toArray(new Symbol[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void loadSymbols() throws IOException {
        if (this.symbols == null) {
            Section[] sectionArray = this.getSections(2);
            if (sectionArray.length > 0) {
                this.symtab_sym = sectionArray[0];
                this.symtab_symbols = this.loadSymbolsBySection(sectionArray[0]);
            } else {
                this.symtab_sym = null;
                this.symtab_symbols = new Symbol[0];
            }
            sectionArray = this.getSections(11);
            if (sectionArray.length > 0) {
                this.dynsym_sym = sectionArray[0];
                this.dynsym_symbols = this.loadSymbolsBySection(sectionArray[0]);
            } else {
                this.dynsym_sym = null;
                this.dynsym_symbols = new Symbol[0];
            }
            if (this.symtab_sym != null) {
                this.symbols = this.symtab_symbols;
            } else if (this.dynsym_sym != null) {
                this.symbols = this.dynsym_symbols;
            }
        }
    }

    public Symbol[] getSymbols() {
        return this.symbols;
    }

    public Symbol[] getDynamicSymbols() {
        return this.dynsym_symbols;
    }

    public Symbol[] getSymtabSymbols() {
        return this.symtab_symbols;
    }

    public Symbol getSymbol(long l) {
        if (this.symbols == null) {
            return null;
        }
        SymbolComparator symbolComparator = new SymbolComparator();
        int n = Arrays.binarySearch(this.symbols, new Long(l), symbolComparator);
        if (n > 0) {
            return this.symbols[n];
        }
        if (n == -1) {
            return null;
        }
        n = -n - 1;
        return this.symbols[n - 1];
    }

    public long swapInt(long l) {
        if (this.ehdr.e_ident[5] == 1) {
            short[] sArray = new short[]{(short)(l & 0xFFL), (short)(l >> 8 & 0xFFL), (short)(l >> 16 & 0xFFL), (short)(l >> 24 & 0xFFL)};
            return (sArray[0] << 24) + (sArray[1] << 16) + (sArray[2] << 8) + sArray[3];
        }
        return l;
    }

    public int swapShort(short s) {
        if (this.ehdr.e_ident[5] == 1) {
            short[] sArray = new short[]{(short)(s & 0xFF), (short)(s >> 8 & 0xFF)};
            return (short)((sArray[0] << 8) + sArray[1]);
        }
        return s;
    }

    public String getFilename() {
        return this.file;
    }

    public class ELFhdr {
        public static final int EI_MAG0 = 0;
        public static final int EI_MAG1 = 1;
        public static final int EI_MAG2 = 2;
        public static final int EI_MAG3 = 3;
        public static final int EI_CLASS = 4;
        public static final int EI_DATA = 5;
        public static final int EI_VERSION = 6;
        public static final int EI_PAD = 7;
        public static final int EI_NDENT = 16;
        public static final int ELFCLASSNONE = 0;
        public static final int ELCLASS32 = 1;
        public static final int ELFCLASS64 = 2;
        public static final int ELFDATANONE = 0;
        public static final int ELFDATA2LSB = 1;
        public static final int ELFDATA2MSB = 2;
        public static final int ET_NONE = 0;
        public static final int ET_REL = 1;
        public static final int ET_EXEC = 2;
        public static final int ET_DYN = 3;
        public static final int ET_CORE = 4;
        public static final int ET_LOPROC = 65280;
        public static final int ET_HIPROC = 65535;
        public static final int EM_NONE = 0;
        public static final int EM_M32 = 1;
        public static final int EM_SPARC = 2;
        public static final int EM_386 = 3;
        public static final int EM_68K = 4;
        public static final int EM_88K = 5;
        public static final int EM_486 = 6;
        public static final int EM_860 = 7;
        public static final int EM_MIPS = 8;
        public static final int EM_MIPS_RS3_LE = 10;
        public static final int EM_RS6000 = 11;
        public static final int EM_PARISC = 15;
        public static final int EM_nCUBE = 16;
        public static final int EM_VPP550 = 17;
        public static final int EM_SPARC32PLUS = 18;
        public static final int EM_PPC = 20;
        public static final int EM_PPC64 = 21;
        public static final int EM_ARM = 40;
        public static final int EM_SH = 42;
        public static final int EM_SPARCV9 = 43;
        public static final int EM_H8_300 = 46;
        public static final int EM_H8_300H = 47;
        public static final int EM_FR30 = 84;
        public static final int EM_V850 = 87;
        public static final int EM_M32R = 88;
        public static final int EM_MN10300 = 89;
        public static final int EM_MN10200 = 90;
        public static final int EM_CYGNUS_POWERPC = 36901;
        public static final int EM_CYGNUS_M32R = 36929;
        public static final int EM_CYGNUS_V850 = 36992;
        public static final int EM_CYGNUS_MN10200 = 57005;
        public static final int EM_CYGNUS_MN10300 = 48879;
        public static final int EM_CYGNUS_FR30 = 13104;
        public static final int EM_XSTORMY16 = 44357;
        public static final int EM_CYGNUS_FRV = 21569;
        public static final int EM_IQ2000 = 65210;
        public byte[] e_ident = new byte[16];
        public int e_type;
        public int e_machine;
        public long e_version;
        public long e_entry;
        public long e_phoff;
        public long e_shoff;
        public long e_flags;
        public short e_ehsize;
        public short e_phentsize;
        public short e_phnum;
        public short e_shentsize;
        public short e_shnum;
        public short e_shstrndx;

        protected ELFhdr() throws IOException {
            Elf.this.efile.seek(0L);
            Elf.this.efile.readFully(this.e_ident);
            if (this.e_ident[0] != 127 || this.e_ident[1] != 69 || this.e_ident[2] != 76 || this.e_ident[3] != 70) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notELF"));
            }
            Elf.this.efile.setEndian(this.e_ident[5] == 1);
            this.e_type = Elf.this.efile.readShortE();
            this.e_machine = Elf.this.efile.readShortE();
            this.e_version = Elf.this.efile.readIntE();
            this.e_entry = Elf.this.efile.readIntE();
            this.e_phoff = Elf.this.efile.readIntE();
            this.e_shoff = Elf.this.efile.readIntE();
            this.e_flags = Elf.this.efile.readIntE();
            this.e_ehsize = Elf.this.efile.readShortE();
            this.e_phentsize = Elf.this.efile.readShortE();
            this.e_phnum = Elf.this.efile.readShortE();
            this.e_shentsize = Elf.this.efile.readShortE();
            this.e_shnum = Elf.this.efile.readShortE();
            this.e_shstrndx = Elf.this.efile.readShortE();
        }

        protected ELFhdr(byte[] byArray) throws IOException {
            if (byArray.length <= this.e_ident.length) {
                throw new EOFException(CCorePlugin.getResourceString("Util.exception.notELF"));
            }
            System.arraycopy(byArray, 0, this.e_ident, 0, this.e_ident.length);
            if (this.e_ident[0] != 127 || this.e_ident[1] != 69 || this.e_ident[2] != 76 || this.e_ident[3] != 70) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notELF"));
            }
            boolean bl = this.e_ident[5] == 1;
            int n = this.e_ident.length;
            this.e_type = this.makeShort(byArray, n, bl);
            this.e_machine = this.makeShort(byArray, n += 2, bl);
            this.e_version = this.makeInt(byArray, n += 2, bl);
            this.e_entry = this.makeInt(byArray, n += 4, bl);
            this.e_phoff = this.makeInt(byArray, n += 4, bl);
            this.e_shoff = this.makeInt(byArray, n += 4, bl);
            this.e_flags = this.makeInt(byArray, n += 4, bl);
            this.e_ehsize = this.makeShort(byArray, n += 4, bl);
            this.e_phentsize = this.makeShort(byArray, n += 2, bl);
            this.e_phnum = this.makeShort(byArray, n += 2, bl);
            this.e_shentsize = this.makeShort(byArray, n += 2, bl);
            this.e_shnum = this.makeShort(byArray, n += 2, bl);
            this.e_shstrndx = this.makeShort(byArray, n += 2, bl);
            n += 2;
        }

        private final short makeShort(byte[] byArray, int n, boolean bl) throws IOException {
            if (byArray.length < n + 2) {
                throw new IOException();
            }
            if (bl) {
                return (short)((byArray[n + 1] << 8) + byArray[n + 0]);
            }
            return (short)((byArray[n + 0] << 8) + byArray[n + 1]);
        }

        private final long makeInt(byte[] byArray, int n, boolean bl) throws IOException {
            if (byArray.length < n + 4) {
                throw new IOException();
            }
            if (bl) {
                return (byArray[n + 3] << 24) + (byArray[n + 2] << 16) + (byArray[n + 1] << 8) + byArray[n + 0];
            }
            return (byArray[n + 0] << 24) + (byArray[n + 1] << 16) + (byArray[n + 2] << 8) + byArray[n + 3];
        }
    }

    public class Section {
        public static final int SHT_NULL = 0;
        public static final int SHT_PROGBITS = 1;
        public static final int SHT_SYMTAB = 2;
        public static final int SHT_STRTAB = 3;
        public static final int SHT_RELA = 4;
        public static final int SHT_HASH = 5;
        public static final int SHT_DYNAMIC = 6;
        public static final int SHT_NOTE = 7;
        public static final int SHT_NOBITS = 8;
        public static final int SHT_REL = 9;
        public static final int SHT_SHLIB = 10;
        public static final int SHT_DYNSYM = 11;
        public static final int SHT_LOPROC = 0x70000000;
        public static final int SHF_WRITE = 1;
        public static final int SHF_ALLOC = 2;
        public static final int SHF_EXECINTR = 4;
        public long sh_name;
        public long sh_type;
        public long sh_flags;
        public long sh_addr;
        public long sh_offset;
        public long sh_size;
        public long sh_link;
        public long sh_info;
        public long sh_addralign;
        public long sh_entsize;

        public byte[] loadSectionData() throws IOException {
            byte[] byArray = new byte[(int)this.sh_size];
            Elf.this.efile.seek(this.sh_offset);
            Elf.this.efile.read(byArray);
            return byArray;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            try {
                int n;
                if (Elf.this.section_strtab == null) {
                    if (Elf.this.ehdr.e_shstrndx > Elf.this.sections.length || Elf.this.ehdr.e_shstrndx < 0) {
                        return Elf.this.EMPTY_STRING;
                    }
                    n = (int)Elf.this.sections[Elf.this.ehdr.e_shstrndx].sh_size;
                    if (n <= 0 || (long)n > Elf.this.efile.length()) {
                        return Elf.this.EMPTY_STRING;
                    }
                    Elf.this.section_strtab = new byte[n];
                    Elf.this.efile.seek(Elf.this.sections[Elf.this.ehdr.e_shstrndx].sh_offset);
                    Elf.this.efile.read(Elf.this.section_strtab);
                }
                n = 0;
                if (this.sh_name > (long)Elf.this.section_strtab.length) {
                    return Elf.this.EMPTY_STRING;
                }
                while (true) {
                    if (Elf.this.section_strtab[(int)this.sh_name + n] == 0) {
                        return new String(Elf.this.section_strtab, (int)this.sh_name, n);
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                return Elf.this.EMPTY_STRING;
            }
        }
    }

    public class Symbol
    implements Comparable {
        public static final int STB_LOCAL = 0;
        public static final int STB_GLOBAL = 1;
        public static final int STB_WEAK = 2;
        public static final int STT_NOTYPE = 0;
        public static final int STT_OBJECT = 1;
        public static final int STT_FUNC = 2;
        public static final int STT_SECTION = 3;
        public static final int STT_FILE = 4;
        public static final int SHN_UNDEF = 0;
        public static final int SHN_LORESERVE = -256;
        public static final int SHN_LOPROC = -256;
        public static final int SHN_HIPROC = -225;
        public static final int SHN_LOOS = -224;
        public static final int SHN_HIOS = -193;
        public static final int SHN_ABS = -15;
        public static final int SHN_COMMON = -14;
        public static final int SHN_XINDEX = -1;
        public static final int SHN_HIRESERVE = -1;
        public long st_name;
        public long st_value;
        public long st_size;
        public short st_info;
        public short st_other;
        public short st_shndx;
        private String name = null;
        private String line = null;
        private String func = null;
        private Section sym_section;

        private String cppFilt(String string) {
            if (Elf.this.cppFiltEnabled) {
                try {
                    if (string.indexOf("__") != -1 || string.indexOf("_._") != -1) {
                        if (Elf.this.cppFilt == null) {
                            Elf.this.cppFilt = new CPPFilt();
                        }
                        return Elf.this.cppFilt.getFunction(string);
                    }
                }
                catch (IOException iOException) {
                    return string;
                }
            }
            return string;
        }

        public Symbol(Section section) {
            this.sym_section = section;
        }

        public int st_type() {
            return this.st_info & 0xF;
        }

        public int st_bind() {
            return this.st_info >> 4 & 0xF;
        }

        public int compareTo(Object object) {
            long l = 0L;
            long l2 = 0L;
            if (object instanceof Symbol) {
                Symbol symbol = (Symbol)object;
                l = this.st_value;
                l2 = symbol.st_value;
            } else if (object instanceof Long) {
                Long l3 = (Long)object;
                l2 = l3;
                l = this.st_value;
            }
            return l < l2 ? -1 : (l == l2 ? 0 : 1);
        }

        public String toString() {
            if (this.name == null) {
                try {
                    Section[] sectionArray = Elf.this.getSections();
                    Section section = sectionArray[(int)this.sym_section.sh_link];
                    this.name = this.cppFilt(Elf.this.string_from_elf_section(section, (int)this.st_name));
                }
                catch (IOException iOException) {
                    return Elf.this.EMPTY_STRING;
                }
            }
            return this.name;
        }

        public String lineInfo() throws IOException {
            if (this.line == null) {
                if (Elf.this.addr2line == null) {
                    Elf.this.addr2line = new Addr2line(Elf.this.file);
                }
                long l = this.st_value;
                int n = 0;
                while (n <= 20) {
                    int n2;
                    String string;
                    this.line = Elf.this.addr2line.getLine(l);
                    if (this.line != null && !(string = this.line.substring((n2 = this.line.lastIndexOf(58)) + 1)).startsWith("0")) break;
                    l += (long)(n += 4);
                }
                this.func = Elf.this.addr2line.getFunction(l);
            }
            return this.line;
        }

        public String lineInfo(long l) throws IOException {
            if (Elf.this.addr2line == null) {
                Elf.this.addr2line = new Addr2line(Elf.this.file);
            }
            return Elf.this.addr2line.getLine(l);
        }

        public String getFunction() throws IOException {
            if (this.func == null) {
                this.lineInfo();
            }
            return this.func;
        }

        public String getFilename() throws IOException {
            int n;
            if (this.line == null) {
                this.lineInfo();
            }
            if (this.line == null || (n = this.line.lastIndexOf(58)) == -1) {
                return null;
            }
            int n2 = this.line.indexOf(58);
            n2 = n == n2 ? 0 : --n2;
            return this.line.substring(n2, n);
        }

        public int getFuncLineNumber() throws IOException {
            int n;
            if (this.line == null) {
                this.lineInfo();
            }
            if (this.line == null || (n = this.line.lastIndexOf(58)) == -1) {
                return -1;
            }
            try {
                int n2 = Integer.parseInt(this.line.substring(n + 1));
                return n2 == 0 ? -1 : n2;
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public int getLineNumber(long l) throws IOException {
            int n;
            String string = this.lineInfo(l);
            if (string == null || (n = string.lastIndexOf(58)) == -1) {
                return -1;
            }
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                return n2 == 0 ? -1 : n2;
            }
            catch (Exception exception) {
                return -1;
            }
        }
    }

    class SymbolComparator
    implements Comparator {
        long val1;
        long val2;

        SymbolComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof Long) {
                this.val1 = (Long)object;
            } else if (object instanceof Symbol) {
                this.val1 = ((Symbol)object).st_value;
            } else {
                return -1;
            }
            if (object2 instanceof Long) {
                this.val2 = (Long)object2;
            } else if (object2 instanceof Symbol) {
                this.val2 = ((Symbol)object2).st_value;
            } else {
                return -1;
            }
            return this.val1 == this.val2 ? 0 : (this.val1 < this.val2 ? -1 : 1);
        }
    }

    public class PHdr {
        public static final int PT_NULL = 0;
        public static final int PT_LOAD = 1;
        public static final int PT_DYNAMIC = 2;
        public static final int PT_INTERP = 3;
        public static final int PT_NOTE = 4;
        public static final int PT_SHLIB = 5;
        public static final int PT_PHDR = 6;
        public static final int PF_X = 1;
        public static final int PF_W = 2;
        public static final int PF_R = 4;
        public long p_type;
        public long p_offset;
        public long p_vaddr;
        public long p_paddr;
        public long p_filesz;
        public long p_memsz;
        public long p_flags;
        public long p_align;
    }

    public class Dynamic {
        public static final int DYN_ENT_SIZE = 8;
        public static final int DT_NULL = 0;
        public static final int DT_NEEDED = 1;
        public static final int DT_PLTRELSZ = 2;
        public static final int DT_PLTGOT = 3;
        public static final int DT_HASH = 4;
        public static final int DT_STRTAB = 5;
        public static final int DT_SYMTAB = 6;
        public static final int DT_RELA = 7;
        public static final int DT_RELASZ = 8;
        public static final int DT_RELAENT = 9;
        public static final int DT_STRSZ = 10;
        public static final int DT_SYMENT = 11;
        public static final int DT_INIT = 12;
        public static final int DT_FINI = 13;
        public static final int DT_SONAME = 14;
        public static final int DT_RPATH = 15;
        public long d_tag;
        public long d_val;
        private Section section;
        private String name;

        protected Dynamic(Section section, long l, long l2) {
            this.section = section;
            this.d_tag = l;
            this.d_val = l2;
        }

        public String toString() {
            if (this.name == null) {
                switch ((int)this.d_tag) {
                    case 1: 
                    case 14: 
                    case 15: {
                        try {
                            Section section = Elf.this.sections[(int)this.section.sh_link];
                            this.name = Elf.this.string_from_elf_section(section, (int)this.d_val);
                        }
                        catch (IOException iOException) {
                            this.name = Elf.this.EMPTY_STRING;
                        }
                        break;
                    }
                    default: {
                        this.name = Elf.this.EMPTY_STRING;
                    }
                }
            }
            return this.name;
        }
    }

    public class Attribute {
        public static final int ELF_TYPE_EXE = 1;
        public static final int ELF_TYPE_SHLIB = 2;
        public static final int ELF_TYPE_OBJ = 3;
        public static final int ELF_TYPE_CORE = 4;
        public static final int DEBUG_TYPE_NONE = 0;
        public static final int DEBUG_TYPE_STABS = 1;
        public static final int DEBUG_TYPE_DWARF = 2;
        String cpu;
        int type;
        int debugType;
        boolean bDebug;
        boolean isle;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.debugType != 0;
        }

        public int getDebugType() {
            return this.debugType;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }
    }
}

