/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ARMember
extends ElfBinaryObject {
    AR.ARHeader header;

    public ARMember(IBinaryParser iBinaryParser, IPath iPath, AR.ARHeader aRHeader) throws IOException {
        super(iBinaryParser, iPath);
        this.header = aRHeader;
    }

    public InputStream getContents() {
        InputStream inputStream = null;
        if (this.path != null && this.header != null) {
            try {
                inputStream = new ByteArrayInputStream(this.header.getObjectData());
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) {
            inputStream = super.getContents();
        }
        return inputStream;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return "";
    }

    protected ElfHelper getElfHelper() throws IOException {
        if (this.header != null) {
            return new ElfHelper(this.header.getElf());
        }
        throw new IOException(CCorePlugin.getResourceString("Util.exception.noFileAssociation"));
    }

    protected void addSymbols(Elf.Symbol[] symbolArray, int n, Addr2line addr2line, CPPFilt cPPFilt, List list) {
        int n2 = 0;
        while (n2 < symbolArray.length) {
            Symbol symbol = new Symbol(this);
            symbol.type = n;
            symbol.name = symbolArray[n2].toString();
            symbol.addr = symbolArray[n2].st_value;
            list.add(symbol);
            ++n2;
        }
    }
}

