/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class LoadSymbolsActionDelegate
implements IObjectActionDelegate {
    private ICSharedLibrary fLibrary = null;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        if (this.getSharedLibrary() != null) {
            final MultiStatus multiStatus = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, CDebugUIPlugin.getResourceString("internal.ui.actions.LoadSymbolsActionDelegate.Unable_to_load_symbols_of_shared_library"), null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        LoadSymbolsActionDelegate.this.doAction(LoadSymbolsActionDelegate.this.getSharedLibrary());
                    }
                    catch (DebugException debugException) {
                        multiStatus.merge(debugException.getStatus());
                    }
                }
            });
            if (!multiStatus.isOK()) {
                IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.LoadSymbolsActionDelegate.Operation_failed"), (IStatus)multiStatus);
                } else {
                    CDebugUIPlugin.log((IStatus)multiStatus);
                }
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof ICSharedLibrary) {
            boolean bl = this.enablesFor((ICSharedLibrary)object);
            iAction.setEnabled(bl);
            if (bl) {
                this.setSharedLibrary((ICSharedLibrary)object);
                return;
            }
        }
        iAction.setEnabled(false);
        this.setSharedLibrary(null);
    }

    protected void doAction(ICSharedLibrary iCSharedLibrary) throws DebugException {
        iCSharedLibrary.loadSymbols();
    }

    private boolean enablesFor(ICSharedLibrary iCSharedLibrary) {
        return iCSharedLibrary != null && !iCSharedLibrary.areSymbolsLoaded();
    }

    private void setSharedLibrary(ICSharedLibrary iCSharedLibrary) {
        this.fLibrary = iCSharedLibrary;
    }

    protected ICSharedLibrary getSharedLibrary() {
        return this.fLibrary;
    }
}

