/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.signals;

import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.AbstractDebugView;

public class SignalsViewEventHandler
extends AbstractDebugEventHandler {
    public SignalsViewEventHandler(AbstractDebugView abstractDebugView) {
        super(abstractDebugView);
    }

    protected void doHandleDebugEvents(DebugEvent[] debugEventArray) {
        int n = 0;
        while (n < debugEventArray.length) {
            DebugEvent debugEvent = debugEventArray[n];
            switch (debugEvent.getKind()) {
                case 4: 
                case 8: {
                    if (!(debugEvent.getSource() instanceof IDebugTarget) && !(debugEvent.getSource() instanceof ICSignal)) break;
                    this.refresh();
                    break;
                }
                case 2: {
                    this.refresh();
                    break;
                }
                case 16: {
                    if (!(debugEvent.getSource() instanceof ICSignal)) break;
                    this.refresh(debugEvent.getSource());
                }
            }
            ++n;
        }
    }

    protected void refresh(Object object) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTableViewer().refresh(object);
        }
    }

    public void refresh() {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTableViewer().refresh();
        }
    }
}

