/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.internal.ui.cview.CLibFilter;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

class ShowLibrariesAction
extends SelectionProviderAction {
    private CView cview;
    private Shell shell;

    public ShowLibrariesAction(Shell shell, CView cView, String string) {
        super((ISelectionProvider)cView.getViewer(), string);
        this.cview = cView;
        CLibFilter cLibFilter = cView.getLibraryFilter();
        this.setChecked(cLibFilter.getShowLibraries());
        this.updateToolTipText();
        this.setEnabled(true);
        this.shell = shell;
    }

    public void run() {
        CLibFilter cLibFilter = this.cview.getLibraryFilter();
        cLibFilter.setShowLibraries(this.isChecked());
        this.updateToolTipText();
        this.saveInPreferences();
        this.cview.getViewer().getControl().setRedraw(false);
        this.cview.getViewer().refresh();
        this.cview.getViewer().getControl().setRedraw(true);
    }

    private void saveInPreferences() {
        CUIPlugin cUIPlugin = CUIPlugin.getDefault();
        Boolean bl = new Boolean(this.cview.getLibraryFilter().getShowLibraries());
        cUIPlugin.getPreferenceStore().putValue("showLibraries", bl.toString());
    }

    private void updateToolTipText() {
        CLibFilter cLibFilter = this.cview.getLibraryFilter();
        if (cLibFilter.getShowLibraries()) {
            this.setToolTipText(CViewMessages.getString("ShowLibrariesAction.hideReferenced.tooltip"));
        } else {
            this.setToolTipText(CViewMessages.getString("ShowLibrariesAction.showReferenced.tooltip"));
        }
    }
}

