/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.util.Assert;

public final class BufferedDocumentScanner
implements ICharacterScanner {
    private IDocument fDocument;
    private int fRangeOffset;
    private int fRangeLength;
    private char[][] fDelimiters;
    private final char[] fBuffer;
    private int fBufferOffset;
    private int fBufferLength;
    private int fOffset;

    public BufferedDocumentScanner(int n) {
        Assert.isTrue((n >= 1 ? 1 : 0) != 0);
        this.fBuffer = new char[n];
    }

    private final void updateBuffer(int n) {
        if (n < 0) {
            n = 0;
        }
        this.fBufferOffset = n;
        this.fBufferLength = this.fBuffer.length;
        if (this.fBufferOffset + this.fBufferLength > this.fRangeOffset + this.fRangeLength) {
            this.fBufferLength = this.fRangeOffset + this.fRangeLength - this.fBufferOffset;
        }
        try {
            String string = this.fDocument.get(this.fBufferOffset, this.fBufferLength);
            string.getChars(0, this.fBufferLength, this.fBuffer, 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    public final void setRange(IDocument iDocument, int n, int n2) {
        this.fDocument = iDocument;
        this.fRangeOffset = n;
        this.fRangeLength = n2;
        if (this.fRangeLength + this.fRangeOffset > this.fDocument.getLength()) {
            this.fRangeLength = this.fDocument.getLength() - this.fRangeOffset;
        }
        String[] stringArray = iDocument.getLegalLineDelimiters();
        this.fDelimiters = new char[stringArray.length][];
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.fDelimiters[n3] = stringArray[n3].toCharArray();
            ++n3;
        }
        this.updateBuffer(n);
        this.fOffset = 0;
    }

    public final int read() {
        if (this.fOffset >= this.fBufferLength) {
            if (this.fBufferOffset + this.fBufferLength >= this.fRangeOffset + this.fRangeLength) {
                return -1;
            }
            this.updateBuffer(this.fBufferOffset + this.fBufferLength);
            this.fOffset = 0;
        }
        return this.fBuffer[this.fOffset++];
    }

    public final void unread() {
        if (this.fOffset <= 0) {
            if (this.fBufferOffset > this.fRangeOffset) {
                this.updateBuffer(this.fBufferOffset - this.fBuffer.length);
                this.fOffset = this.fBuffer.length - 1;
            }
        } else {
            --this.fOffset;
        }
    }

    public final int getColumn() {
        try {
            int n = this.fBufferOffset + this.fOffset;
            int n2 = this.fDocument.getLineOfOffset(n);
            int n3 = this.fDocument.getLineOffset(n2);
            return n - n3;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public final char[][] getLegalLineDelimiters() {
        return this.fDelimiters;
    }
}

