/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProcessor;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ContentAssistPreference {
    public static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    public static final String PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    public static final String PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    public static final String PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    public static final String PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    public static final String AUTOINSERT = "content_assist_autoinsert";
    public static final String AUTOACTIVATION_TRIGGERS_DOT = "content_assist_autoactivation_trigger_dot";
    public static final String AUTOACTIVATION_TRIGGERS_ARROW = "content_assist_autoactivation_trigger_arrow";
    public static final String AUTOACTIVATION_TRIGGERS_DOUBLECOLON = "content_assist_autoactivation_trigger_doublecolon";
    public static final String SHOW_DOCUMENTED_PROPOSALS = "content_assist_show_visible_proposals";
    public static final String ORDER_PROPOSALS = "content_assist_order_proposals";
    public static final String ADD_INCLUDE = "content_assist_add_import";
    public static final String CURRENT_FILE_SEARCH_SCOPE = "content_assist_current_file_search_scope";
    public static final String PROJECT_SEARCH_SCOPE = "content_assist_project_search_scope";

    private static Color getColor(IPreferenceStore iPreferenceStore, String string, IColorManager iColorManager) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        return iColorManager.getColor(rGB);
    }

    private static Color getColor(IPreferenceStore iPreferenceStore, String string) {
        CTextTools cTextTools = CUIPlugin.getDefault().getTextTools();
        return ContentAssistPreference.getColor(iPreferenceStore, string, cTextTools.getColorManager());
    }

    private static CCompletionProcessor getCProcessor(ContentAssistant contentAssistant) {
        IContentAssistProcessor iContentAssistProcessor = contentAssistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (iContentAssistProcessor instanceof CCompletionProcessor) {
            return (CCompletionProcessor)iContentAssistProcessor;
        }
        return null;
    }

    private static void configureCProcessor(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore) {
        boolean bl;
        boolean bl2;
        CCompletionProcessor cCompletionProcessor = ContentAssistPreference.getCProcessor(contentAssistant);
        if (cCompletionProcessor == null) {
            return;
        }
        String string = "";
        boolean bl3 = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
        if (bl3) {
            string = ".";
        }
        if (bl2 = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW)) {
            string = String.valueOf(string) + ">";
        }
        if (bl = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON)) {
            string = String.valueOf(string) + ":";
        }
        cCompletionProcessor.setCompletionProposalAutoActivationCharacters(string.toCharArray());
        boolean bl4 = iPreferenceStore.getBoolean(SHOW_DOCUMENTED_PROPOSALS);
        bl4 = iPreferenceStore.getBoolean(ORDER_PROPOSALS);
        cCompletionProcessor.orderProposalsAlphabetically(bl4);
        bl4 = iPreferenceStore.getBoolean(ADD_INCLUDE);
        cCompletionProcessor.allowAddingIncludes(bl4);
    }

    public static void configure(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore) {
        CTextTools cTextTools = CUIPlugin.getDefault().getTextTools();
        CColorManager cColorManager = cTextTools.getColorManager();
        boolean bl = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
        boolean bl2 = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW);
        boolean bl3 = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON);
        boolean bl4 = bl || bl2 || bl3;
        contentAssistant.enableAutoActivation(bl4);
        int n = iPreferenceStore.getInt(AUTOACTIVATION_DELAY);
        contentAssistant.setAutoActivationDelay(n);
        Color color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_FOREGROUND, cColorManager);
        contentAssistant.setProposalSelectorForeground(color);
        Color color2 = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_BACKGROUND, cColorManager);
        contentAssistant.setProposalSelectorBackground(color2);
        Color color3 = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_FOREGROUND, cColorManager);
        contentAssistant.setContextInformationPopupForeground(color3);
        contentAssistant.setContextSelectorForeground(color3);
        Color color4 = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_BACKGROUND, cColorManager);
        contentAssistant.setContextInformationPopupBackground(color4);
        contentAssistant.setContextSelectorBackground(color4);
        bl4 = iPreferenceStore.getBoolean(AUTOINSERT);
        contentAssistant.enableAutoInsert(bl4);
        ContentAssistPreference.configureCProcessor(contentAssistant, iPreferenceStore);
    }

    private static void changeCProcessor(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore, String string) {
        CCompletionProcessor cCompletionProcessor = ContentAssistPreference.getCProcessor(contentAssistant);
        if (cCompletionProcessor == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_DOT.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
            if (bl) {
                String string2 = ".";
                cCompletionProcessor.setCompletionProposalAutoActivationCharacters(string2.toCharArray());
            }
        } else if (AUTOACTIVATION_TRIGGERS_ARROW.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW);
            if (bl) {
                String string3 = ">";
                cCompletionProcessor.setCompletionProposalAutoActivationCharacters(string3.toCharArray());
            }
        } else if (AUTOACTIVATION_TRIGGERS_DOUBLECOLON.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON);
            if (bl) {
                String string4 = ":";
                cCompletionProcessor.setCompletionProposalAutoActivationCharacters(string4.toCharArray());
            }
        } else if (!SHOW_DOCUMENTED_PROPOSALS.equals(string)) {
            if (ORDER_PROPOSALS.equals(string)) {
                boolean bl = iPreferenceStore.getBoolean(ORDER_PROPOSALS);
                cCompletionProcessor.orderProposalsAlphabetically(bl);
            } else if (ADD_INCLUDE.equals(string)) {
                boolean bl = iPreferenceStore.getBoolean(ADD_INCLUDE);
                cCompletionProcessor.allowAddingIncludes(bl);
            }
        }
    }

    public static void changeConfiguration(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore, PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (AUTOACTIVATION_TRIGGERS_DOT.equals(string) || AUTOACTIVATION_TRIGGERS_ARROW.equals(string) || AUTOACTIVATION_TRIGGERS_DOUBLECOLON.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
            boolean bl2 = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW);
            boolean bl3 = iPreferenceStore.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON);
            boolean bl4 = bl || bl2 || bl3;
            contentAssistant.enableAutoActivation(bl4);
        } else if (AUTOACTIVATION_DELAY.equals(string)) {
            int n = iPreferenceStore.getInt(AUTOACTIVATION_DELAY);
            contentAssistant.setAutoActivationDelay(n);
        } else if (PROPOSALS_FOREGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_FOREGROUND);
            contentAssistant.setProposalSelectorForeground(color);
        } else if (PROPOSALS_BACKGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_BACKGROUND);
            contentAssistant.setProposalSelectorBackground(color);
        } else if (PARAMETERS_FOREGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_FOREGROUND);
            contentAssistant.setContextInformationPopupForeground(color);
            contentAssistant.setContextSelectorForeground(color);
        } else if (PARAMETERS_BACKGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_BACKGROUND);
            contentAssistant.setContextInformationPopupBackground(color);
            contentAssistant.setContextSelectorBackground(color);
        } else if (AUTOINSERT.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(AUTOINSERT);
            contentAssistant.enableAutoInsert(bl);
        }
        ContentAssistPreference.changeCProcessor(contentAssistant, iPreferenceStore, string);
    }
}

