/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CygwinPEBinaryParserPage
extends AbstractCOptionPage {
    public static final String PREF_ADDR2LINE_PATH = "org.eclipse.cdt.ui.addr2line";
    public static final String PREF_CPPFILT_PATH = "org.eclipse.cdt.ui.cppfilt";
    public static final String PREF_CYGPATH_PATH = "org.eclipse.cdt.ui.cygpath";
    protected Text fAddr2LineCommandText;
    protected Text fCPPFiltCommandText;
    protected Text fCygPathCommandText;

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        String string = this.fAddr2LineCommandText.getText().trim();
        String string2 = this.fCPPFiltCommandText.getText().trim();
        String string3 = this.fCygPathCommandText.getText().trim();
        iProgressMonitor.beginTask(CUIMessages.getString("BinaryParserPage.task.savingAttributes"), 1);
        IProject iProject = this.getContainer().getProject();
        if (iProject != null) {
            Object object;
            ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject);
            ICExtensionReference[] iCExtensionReferenceArray = iCDescriptor.get("org.eclipse.cdt.core.BinaryParser");
            if (iCExtensionReferenceArray.length == 0) {
                object = CUIPlugin.getDefault().getDescriptor();
                IExtensionPoint iExtensionPoint = object.getExtensionPoint("BinaryParserPage");
                IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    String string4 = iConfigurationElementArray[n].getAttribute("parserID");
                    String string5 = iConfigurationElementArray[n].getAttribute("class");
                    String string6 = this.getClass().getName();
                    if (string5 != null && string5.equals(string6)) {
                        iCDescriptor.remove("org.eclipse.cdt.core.BinaryParser");
                        iCDescriptor.create("org.eclipse.cdt.core.BinaryParser", string4);
                    }
                    ++n;
                }
                iCExtensionReferenceArray = iCDescriptor.get("org.eclipse.cdt.core.BinaryParser");
            }
            if (iCExtensionReferenceArray.length > 0) {
                object = iCExtensionReferenceArray[0].getExtensionData("addr2line");
                if (object == null || !((String)object).equals(string)) {
                    iCExtensionReferenceArray[0].setExtensionData("addr2line", string);
                }
                if ((object = iCExtensionReferenceArray[0].getExtensionData("c++filt")) == null || !((String)object).equals(string2)) {
                    iCExtensionReferenceArray[0].setExtensionData("c++filt", string2);
                }
                if ((object = iCExtensionReferenceArray[0].getExtensionData("cygpath")) == null || !((String)object).equals(string3)) {
                    iCExtensionReferenceArray[0].setExtensionData("cygpath", string3);
                }
            }
        } else {
            Preferences preferences = this.getContainer().getPreferences();
            if (preferences != null) {
                preferences.setValue(PREF_ADDR2LINE_PATH, string);
                preferences.setValue(PREF_CPPFILT_PATH, string2);
                preferences.setValue(PREF_CYGPATH_PATH, string3);
            }
        }
    }

    public void performDefaults() {
        String string = null;
        String string2 = null;
        String string3 = null;
        IProject iProject = this.getContainer().getProject();
        if (iProject != null) {
            try {
                ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject);
                ICExtensionReference[] iCExtensionReferenceArray = iCDescriptor.get("org.eclipse.cdt.core.BinaryParser");
                if (iCExtensionReferenceArray.length > 0) {
                    string = iCExtensionReferenceArray[0].getExtensionData("addr2line");
                    string2 = iCExtensionReferenceArray[0].getExtensionData("c++filt");
                    string3 = iCExtensionReferenceArray[0].getExtensionData("cygpath");
                }
            }
            catch (CoreException coreException) {}
        } else {
            Preferences preferences = this.getContainer().getPreferences();
            if (preferences != null) {
                string = preferences.getString(PREF_ADDR2LINE_PATH);
                string2 = preferences.getString(PREF_CPPFILT_PATH);
                string3 = preferences.getString(PREF_CYGPATH_PATH);
            }
        }
        this.fAddr2LineCommandText.setText(string == null || string.length() == 0 ? "addr2line" : string);
        this.fCPPFiltCommandText.setText(string2 == null || string2.length() == 0 ? "c++filt" : string2);
        this.fCygPathCommandText.setText(string3 == null || string3.length() == 0 ? "cygpath" : string3);
    }

    public void createControl(Composite composite) {
        Composite composite2 = ControlFactory.createCompositeEx(composite, 2, 768);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel(composite2, CUIMessages.getString("BinaryParserPage.label.addr2lineCommand"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fAddr2LineCommandText = ControlFactory.createTextField(composite2, 2052);
        this.fAddr2LineCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
            }
        });
        Button button = ControlFactory.createPushButton(composite2, CUIMessages.getString("BinaryParserPage.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.handleAddr2LineButtonSelected();
            }

            private void handleAddr2LineButtonSelected() {
                String string;
                FileDialog fileDialog = new FileDialog(CygwinPEBinaryParserPage.this.getShell(), 0);
                fileDialog.setText("addr2line Command");
                String string2 = CygwinPEBinaryParserPage.this.fAddr2LineCommandText.getText().trim();
                int n = string2.lastIndexOf(File.separator);
                if (n != -1) {
                    fileDialog.setFilterPath(string2.substring(0, n));
                }
                if ((string = fileDialog.open()) == null) {
                    return;
                }
                CygwinPEBinaryParserPage.this.fAddr2LineCommandText.setText(string);
            }
        });
        label = ControlFactory.createLabel(composite2, CUIMessages.getString("BinaryParserPage.label.cppfiltCommand"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fCPPFiltCommandText = ControlFactory.createTextField(composite2, 2052);
        gridData = new GridData(768);
        this.fCPPFiltCommandText.setLayoutData((Object)gridData);
        this.fCPPFiltCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
            }
        });
        button = ControlFactory.createPushButton(composite2, CUIMessages.getString("BinaryParserPage.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.handleCPPFiltButtonSelected();
            }

            private void handleCPPFiltButtonSelected() {
                String string;
                FileDialog fileDialog = new FileDialog(CygwinPEBinaryParserPage.this.getShell(), 0);
                fileDialog.setText("c++filt Command");
                String string2 = CygwinPEBinaryParserPage.this.fCPPFiltCommandText.getText().trim();
                int n = string2.lastIndexOf(File.separator);
                if (n != -1) {
                    fileDialog.setFilterPath(string2.substring(0, n));
                }
                if ((string = fileDialog.open()) == null) {
                    return;
                }
                CygwinPEBinaryParserPage.this.fCPPFiltCommandText.setText(string);
            }
        });
        label = ControlFactory.createLabel(composite2, CUIMessages.getString("BinaryParserPage.label.cygpathCommand"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fCygPathCommandText = ControlFactory.createTextField(composite2, 2052);
        gridData = new GridData(768);
        this.fCygPathCommandText.setLayoutData((Object)gridData);
        this.fCygPathCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
            }
        });
        button = ControlFactory.createPushButton(composite2, CUIMessages.getString("BinaryParserPage.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.handleCygPathButtonSelected();
            }

            private void handleCygPathButtonSelected() {
                String string;
                FileDialog fileDialog = new FileDialog(CygwinPEBinaryParserPage.this.getShell(), 0);
                fileDialog.setText("cygpath Command");
                String string2 = CygwinPEBinaryParserPage.this.fCygPathCommandText.getText().trim();
                int n = string2.lastIndexOf(File.separator);
                if (n != -1) {
                    fileDialog.setFilterPath(string2.substring(0, n));
                }
                if ((string = fileDialog.open()) == null) {
                    return;
                }
                CygwinPEBinaryParserPage.this.fCygPathCommandText.setText(string);
            }
        });
        this.setControl((Control)composite2);
        this.performDefaults();
    }
}

