/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIInfo {
    MIOutput miOutput;

    public MIInfo(MIOutput mIOutput) {
        this.miOutput = mIOutput;
    }

    public MIOutput getMIOutput() {
        return this.miOutput;
    }

    public boolean isDone() {
        return this.isResultClass("done");
    }

    public boolean isRunning() {
        return this.isResultClass("running");
    }

    public boolean isConnected() {
        return this.isResultClass("connected");
    }

    public boolean isError() {
        return this.isResultClass("error");
    }

    public boolean isExit() {
        return this.isResultClass("exit");
    }

    public String toString() {
        if (this.miOutput != null) {
            return this.miOutput.toString();
        }
        return "";
    }

    boolean isResultClass(String string) {
        MIResultRecord mIResultRecord;
        if (this.miOutput != null && (mIResultRecord = this.miOutput.getMIResultRecord()) != null) {
            String string2 = mIResultRecord.getResultClass();
            return string2.equals(string);
        }
        return false;
    }

    public String getErrorMsg() {
        MIResultRecord mIResultRecord;
        if (this.miOutput != null && (mIResultRecord = this.miOutput.getMIResultRecord()) != null) {
            MIResult[] mIResultArray = mIResultRecord.getMIResults();
            int n = 0;
            while (n < mIResultArray.length) {
                MIValue mIValue;
                String string = mIResultArray[n].getVariable();
                if (string.equals("msg") && (mIValue = mIResultArray[n].getMIValue()) instanceof MIConst) {
                    String string2 = ((MIConst)mIValue).getCString();
                    return string2;
                }
                ++n;
            }
        }
        return "";
    }
}

