/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class TypeFilter {
    private Set acceptedTypes = new HashSet();
    private Set acceptedKinds = new HashSet();

    public TypeFilter() {
    }

    public TypeFilter(Set set) {
        this.acceptedTypes.addAll(set);
    }

    public TypeFilter(TypeInfo.eType eType2) {
        this.acceptedTypes.add(eType2);
    }

    public TypeFilter(IASTNode.LookupKind lookupKind) {
        this.acceptedKinds.add(lookupKind);
        this.populatedAcceptedTypes(lookupKind);
    }

    public void addAcceptedType(TypeInfo.eType eType2) {
        this.acceptedTypes.add(eType2);
    }

    public void addAcceptedType(IASTNode.LookupKind lookupKind) {
        this.populatedAcceptedTypes(lookupKind);
        this.acceptedKinds.add(lookupKind);
    }

    public boolean shouldAccept(ISymbol iSymbol) {
        return this.shouldAccept(iSymbol, iSymbol.getTypeInfo());
    }

    public boolean shouldAccept(ISymbol iSymbol, TypeInfo typeInfo) {
        boolean bl;
        if (this.acceptedTypes.contains(TypeInfo.t_any)) {
            return true;
        }
        if (this.acceptedKinds.isEmpty()) {
            return this.acceptedTypes.contains(typeInfo.getType());
        }
        IContainerSymbol iContainerSymbol = iSymbol.getContainingSymbol();
        boolean bl2 = iContainerSymbol.isType(TypeInfo.t_class, TypeInfo.t_union);
        boolean bl3 = bl = iContainerSymbol.isType(TypeInfo.t_constructor, TypeInfo.t_function) || iContainerSymbol.isType(TypeInfo.t_block);
        if (typeInfo.isType(TypeInfo.t_function)) {
            return this.acceptedKinds.contains(IASTNode.LookupKind.FUNCTIONS) && !bl2 || this.acceptedKinds.contains(IASTNode.LookupKind.METHODS) && bl2;
        }
        if (typeInfo.isType(TypeInfo.t_type) || typeInfo.isType(TypeInfo.t__Bool, TypeInfo.t_void)) {
            return this.acceptedKinds.contains(IASTNode.LookupKind.VARIABLES) && !bl2 && !bl || this.acceptedKinds.contains(IASTNode.LookupKind.LOCAL_VARIABLES) && !bl2 && bl || this.acceptedKinds.contains(IASTNode.LookupKind.FIELDS) && bl2;
        }
        return this.acceptedTypes.contains(typeInfo.getType());
    }

    private void populatedAcceptedTypes(IASTNode.LookupKind lookupKind) {
        if (lookupKind == IASTNode.LookupKind.ALL) {
            this.acceptedTypes.add(TypeInfo.t_any);
        } else if (lookupKind == IASTNode.LookupKind.STRUCTURES) {
            this.acceptedTypes.add(TypeInfo.t_class);
            this.acceptedTypes.add(TypeInfo.t_struct);
            this.acceptedTypes.add(TypeInfo.t_union);
        } else if (lookupKind == IASTNode.LookupKind.STRUCTS) {
            this.acceptedTypes.add(TypeInfo.t_struct);
        } else if (lookupKind == IASTNode.LookupKind.UNIONS) {
            this.acceptedTypes.add(TypeInfo.t_union);
        } else if (lookupKind == IASTNode.LookupKind.CLASSES) {
            this.acceptedTypes.add(TypeInfo.t_class);
        } else if (lookupKind == IASTNode.LookupKind.CONSTRUCTORS) {
            this.acceptedTypes.add(TypeInfo.t_constructor);
        } else if (lookupKind == IASTNode.LookupKind.NAMESPACES) {
            this.acceptedTypes.add(TypeInfo.t_namespace);
        } else if (lookupKind == IASTNode.LookupKind.ENUMERATIONS) {
            this.acceptedTypes.add(TypeInfo.t_enumeration);
        } else if (lookupKind == IASTNode.LookupKind.ENUMERATORS) {
            this.acceptedTypes.add(TypeInfo.t_enumerator);
        }
    }
}

