/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.ContextException;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.Scanner;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContext;

public class ContextStack {
    private final IParserLogService log;
    private Scanner scanner;
    private IScannerContext currentContext;
    private IScannerContext topContext;
    private Stack contextStack = new Stack();
    private LinkedList undoStack = new LinkedList();
    private Set inclusions = new HashSet();
    private Set defines = new HashSet();

    public ContextStack(Scanner scanner, IParserLogService iParserLogService) {
        this.scanner = scanner;
        this.log = iParserLogService;
    }

    public void updateContext(Reader reader, String string, IScannerContext.ContextKind contextKind, IASTInclusion iASTInclusion, ISourceElementRequestor iSourceElementRequestor) throws ContextException {
        this.updateContext(reader, string, contextKind, iASTInclusion, iSourceElementRequestor, -1, -1);
    }

    public void updateContext(Reader reader, String string, IScannerContext.ContextKind contextKind, IASTInclusion iASTInclusion, ISourceElementRequestor iSourceElementRequestor, int n, int n2) throws ContextException {
        int n3 = 1;
        if (contextKind == IScannerContext.ContextKind.MACROEXPANSION) {
            if (this.currentContext.getKind() == IScannerContext.ContextKind.MACROEXPANSION) {
                n = this.currentContext.getMacroOffset();
                n2 = this.currentContext.getMacroLength();
            }
            n3 = this.currentContext.getLine();
        }
        this.undoStack.clear();
        ScannerContext scannerContext = new ScannerContext(reader, string, contextKind, null, n, n2, n3);
        scannerContext.setExtension(iASTInclusion);
        this.push(scannerContext, iSourceElementRequestor);
    }

    protected void push(IScannerContext iScannerContext, ISourceElementRequestor iSourceElementRequestor) throws ContextException {
        if (iScannerContext.getKind() == IScannerContext.ContextKind.INCLUSION) {
            if (!this.inclusions.add(iScannerContext.getFilename())) {
                throw new ContextException(0x200000B);
            }
            this.log.traceLog("Scanner::ContextStack: entering inclusion " + iScannerContext.getFilename());
            iScannerContext.getExtension().enterScope(iSourceElementRequestor);
        } else if (iScannerContext.getKind() == IScannerContext.ContextKind.MACROEXPANSION && !this.defines.add(iScannerContext.getFilename())) {
            throw new ContextException(0x2000005);
        }
        if (this.currentContext != null) {
            this.contextStack.push(this.currentContext);
        }
        this.currentContext = iScannerContext;
        if (iScannerContext.getKind() == IScannerContext.ContextKind.TOP) {
            this.topContext = iScannerContext;
        }
    }

    public boolean rollbackContext(ISourceElementRequestor iSourceElementRequestor) {
        try {
            this.currentContext.getReader().close();
        }
        catch (IOException iOException) {
            this.log.traceLog("ContextStack : Error closing reader ");
        }
        if (this.currentContext.getKind() == IScannerContext.ContextKind.INCLUSION) {
            this.log.traceLog("Scanner::ContextStack: ending inclusion " + this.currentContext.getFilename());
            this.inclusions.remove(this.currentContext.getFilename());
            this.currentContext.getExtension().exitScope(iSourceElementRequestor);
        } else if (this.currentContext.getKind() == IScannerContext.ContextKind.MACROEXPANSION) {
            this.defines.remove(this.currentContext.getFilename());
        }
        this.undoStack.addFirst(this.currentContext);
        if (this.contextStack.isEmpty()) {
            this.currentContext = null;
            return false;
        }
        this.currentContext = (ScannerContext)this.contextStack.pop();
        return true;
    }

    public void undoRollback(IScannerContext iScannerContext, ISourceElementRequestor iSourceElementRequestor) throws ContextException {
        if (this.currentContext == iScannerContext) {
            return;
        }
        int n = this.undoStack.size();
        if (n > 0) {
            int n2 = n;
            while (n2 > 0) {
                this.push((IScannerContext)this.undoStack.removeFirst(), iSourceElementRequestor);
                if (this.currentContext == iScannerContext) break;
                --n2;
            }
        }
    }

    protected boolean shouldExpandDefinition(String string) {
        return !this.defines.contains(string);
    }

    public IScannerContext getCurrentContext() {
        return this.currentContext;
    }

    public IScannerContext getTopContext() {
        return this.topContext;
    }

    public IScannerContext getMostRelevantFileContext() {
        if (this.currentContext != null) {
            if (this.currentContext.getKind() == IScannerContext.ContextKind.TOP) {
                return this.currentContext;
            }
            if (this.currentContext.getKind() == IScannerContext.ContextKind.INCLUSION) {
                return this.currentContext;
            }
        }
        IScannerContext iScannerContext = null;
        int n = this.contextStack.size() - 1;
        while (n >= 0) {
            iScannerContext = (IScannerContext)this.contextStack.get(n);
            if (iScannerContext.getKind() == IScannerContext.ContextKind.INCLUSION || iScannerContext.getKind() == IScannerContext.ContextKind.TOP) break;
            if (n == 0) {
                iScannerContext = null;
            }
            --n;
        }
        return iScannerContext;
    }

    public int getCurrentLineNumber() {
        return this.getMostRelevantFileContext() != null ? this.getMostRelevantFileContext().getLine() : -1;
    }

    public int getTopFileLineNumber() {
        return this.topContext.getLine();
    }

    public Scanner getScanner() {
        return this.scanner;
    }
}

