/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.utils.spawner.Spawner;

public class Configuration
implements ICDIConfiguration {
    protected boolean fAttached;
    MISession miSession;

    public Configuration(MISession mISession, boolean bl) {
        this.fAttached = bl;
        this.miSession = mISession;
    }

    public boolean supportsBreakpoints() {
        return true;
    }

    public boolean supportsDisconnect() {
        return this.fAttached;
    }

    public boolean supportsExpressionEvaluation() {
        return true;
    }

    public boolean supportsInstructionStepping() {
        return true;
    }

    public boolean supportsMemoryModification() {
        return true;
    }

    public boolean supportsMemoryRetrieval() {
        return true;
    }

    public boolean supportsRegisterModification() {
        return true;
    }

    public boolean supportsRegisters() {
        return true;
    }

    public boolean supportsSharedLibrary() {
        return true;
    }

    public boolean supportsRestart() {
        return !this.fAttached;
    }

    public boolean supportsStepping() {
        return true;
    }

    public boolean supportsTerminate() {
        return true;
    }

    public boolean supportsResume() {
        return true;
    }

    public boolean supportsSuspend() {
        String string = null;
        try {
            string = System.getProperty("os.name", "");
        }
        catch (SecurityException securityException) {}
        Process process = this.miSession.getGDBProcess();
        if (process instanceof Spawner) {
            if (this.fAttached) {
                return true;
            }
            if (string.equals("SunOS")) {
                MIInferior mIInferior = this.miSession.getMIInferior();
                return mIInferior.getPTY() == null;
            }
            return true;
        }
        return false;
    }

    public boolean terminateSessionOnExit() {
        return true;
    }
}

