/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDIMemoryManager;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterManager;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.ICDISignalManager;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.event.ChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.CreatedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.DestroyedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.DisconnectedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.ExitedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.MemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.ResumedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.SuspendedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MICommand;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MICreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDestroyedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIGDBExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorSignalExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackInfoDepthInfo;

public class EventManager
extends SessionObject
implements ICDIEventManager,
Observer {
    List list = Collections.synchronizedList(new ArrayList(1));
    List tokenList = new ArrayList(1);
    MIRunningEvent lastRunningEvent;
    Command lastUserCommand = null;

    public void update(Observable observable, Object object) {
        Object object2;
        MIEvent mIEvent = (MIEvent)object;
        Session session = (Session)this.getSession();
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        if (!this.ignoreEventToken(mIEvent.getToken())) {
            if (mIEvent instanceof MIStoppedEvent) {
                if (this.processSuspendedEvent((MIStoppedEvent)mIEvent)) {
                    arrayList.add(new SuspendedEvent(session, mIEvent));
                }
            } else if (mIEvent instanceof MIRunningEvent) {
                if (this.processRunningEvent((MIRunningEvent)mIEvent)) {
                    arrayList.add(new ResumedEvent(session, (MIRunningEvent)mIEvent));
                }
            } else if (mIEvent instanceof MIChangedEvent) {
                if (mIEvent instanceof MIVarChangedEvent) {
                    arrayList.add(new ChangedEvent(session, (MIVarChangedEvent)mIEvent));
                } else if (mIEvent instanceof MIRegisterChangedEvent) {
                    arrayList.add(new ChangedEvent(session, (MIRegisterChangedEvent)mIEvent));
                } else if (mIEvent instanceof MIMemoryChangedEvent) {
                    object2 = (MemoryManager)session.getMemoryManager();
                    MemoryBlock[] memoryBlockArray = ((MemoryManager)object2).listMemoryBlocks();
                    MIMemoryChangedEvent mIMemoryChangedEvent = (MIMemoryChangedEvent)mIEvent;
                    Long[] longArray = mIMemoryChangedEvent.getAddresses();
                    int n = 0;
                    while (n < memoryBlockArray.length) {
                        if (memoryBlockArray[n].contains(longArray) && (!memoryBlockArray[n].isFrozen() || memoryBlockArray[n].isDirty())) {
                            arrayList.add(new MemoryChangedEvent(session, memoryBlockArray[n], mIMemoryChangedEvent));
                            memoryBlockArray[n].setDirty(false);
                        }
                        ++n;
                    }
                } else if (mIEvent instanceof MIBreakpointChangedEvent) {
                    object2 = (MIBreakpointChangedEvent)mIEvent;
                    if (((MIBreakpointChangedEvent)object2).getNumber() > 0) {
                        arrayList.add(new ChangedEvent(session, (MIBreakpointChangedEvent)object2));
                    } else {
                        try {
                            session.getBreakpointManager().update();
                        }
                        catch (CDIException cDIException) {}
                    }
                } else if (mIEvent instanceof MISharedLibChangedEvent) {
                    arrayList.add(new ChangedEvent(session, (MISharedLibChangedEvent)mIEvent));
                } else if (mIEvent instanceof MISignalChangedEvent) {
                    object2 = (MISignalChangedEvent)mIEvent;
                    String string = ((MISignalChangedEvent)object2).getName();
                    if (string == null || string.length() == 0) {
                        try {
                            session.getSignalManager().update();
                        }
                        catch (CDIException cDIException) {}
                    } else {
                        arrayList.add(new ChangedEvent(session, (MISignalChangedEvent)object2));
                    }
                }
            } else if (mIEvent instanceof MIDestroyedEvent) {
                if (mIEvent instanceof MIThreadExitEvent) {
                    arrayList.add(new DestroyedEvent(session, (MIThreadExitEvent)mIEvent));
                } else if (mIEvent instanceof MIInferiorSignalExitEvent) {
                    arrayList.add(new ExitedEvent(session, (MIInferiorSignalExitEvent)mIEvent));
                } else if (mIEvent instanceof MIInferiorExitEvent) {
                    arrayList.add(new ExitedEvent(session, (MIInferiorExitEvent)mIEvent));
                } else if (mIEvent instanceof MIGDBExitEvent) {
                    arrayList.add(new DestroyedEvent(session));
                } else if (mIEvent instanceof MIDetachedEvent) {
                    arrayList.add(new DisconnectedEvent(session));
                } else if (mIEvent instanceof MIBreakpointDeletedEvent) {
                    object2 = (MIBreakpointDeletedEvent)mIEvent;
                    if (((MIBreakpointDeletedEvent)object2).getNumber() > 0) {
                        arrayList.add(new DestroyedEvent(session, (MIBreakpointDeletedEvent)object2));
                    } else {
                        try {
                            session.getBreakpointManager().update();
                        }
                        catch (CDIException cDIException) {}
                    }
                } else if (mIEvent instanceof MISharedLibUnloadedEvent) {
                    arrayList.add(new DestroyedEvent(session, (MISharedLibUnloadedEvent)mIEvent));
                } else if (mIEvent instanceof MIVarDeletedEvent) {
                    arrayList.add(new DestroyedEvent(session, (MIVarDeletedEvent)mIEvent));
                }
            } else if (mIEvent instanceof MICreatedEvent) {
                if (mIEvent instanceof MIBreakpointCreatedEvent) {
                    object2 = (MIBreakpointCreatedEvent)mIEvent;
                    if (((MIBreakpointCreatedEvent)object2).getNumber() > 0) {
                        arrayList.add(new CreatedEvent(session, (MIBreakpointCreatedEvent)object2));
                    } else {
                        try {
                            session.getBreakpointManager().update();
                        }
                        catch (CDIException cDIException) {}
                    }
                } else if (mIEvent instanceof MIVarCreatedEvent) {
                    arrayList.add(new CreatedEvent(session, (MIVarCreatedEvent)mIEvent));
                } else if (mIEvent instanceof MIRegisterCreatedEvent) {
                    arrayList.add(new CreatedEvent(session, (MIRegisterCreatedEvent)mIEvent));
                } else if (mIEvent instanceof MIThreadCreatedEvent) {
                    arrayList.add(new CreatedEvent(session, (MIThreadCreatedEvent)mIEvent));
                } else if (mIEvent instanceof MIMemoryCreatedEvent) {
                    arrayList.add(new CreatedEvent(session, (MIMemoryCreatedEvent)mIEvent));
                } else if (mIEvent instanceof MISharedLibCreatedEvent) {
                    arrayList.add(new CreatedEvent(session, (MISharedLibCreatedEvent)mIEvent));
                }
            }
        }
        object2 = arrayList.toArray(new ICDIEvent[0]);
        this.fireEvents((ICDIEvent[])object2);
    }

    public EventManager(Session session) {
        super(session);
    }

    public void addEventListener(ICDIEventListener iCDIEventListener) {
        this.list.add(iCDIEventListener);
    }

    public void removeEventListener(ICDIEventListener iCDIEventListener) {
        this.list.remove(iCDIEventListener);
    }

    private void fireEvents(ICDIEvent[] iCDIEventArray) {
        if (iCDIEventArray != null) {
            int n = 0;
            while (n < iCDIEventArray.length) {
                this.fireEvent(iCDIEventArray[n]);
                ++n;
            }
        }
    }

    private void fireEvent(ICDIEvent iCDIEvent) {
        if (iCDIEvent != null) {
            ICDIEventListener[] iCDIEventListenerArray = this.list.toArray(new ICDIEventListener[0]);
            int n = 0;
            while (n < iCDIEventListenerArray.length) {
                iCDIEventListenerArray[n].handleDebugEvent(iCDIEvent);
                ++n;
            }
        }
    }

    boolean processSuspendedEvent(MIStoppedEvent mIStoppedEvent) {
        ICDIExpressionManager iCDIExpressionManager;
        Target target;
        Session session = (Session)this.getSession();
        ICDITarget iCDITarget = session.getCurrentTarget();
        if (this.processSharedLibEvent(mIStoppedEvent)) {
            return false;
        }
        int n = mIStoppedEvent.getThreadId();
        if (iCDITarget instanceof Target) {
            target = (Target)iCDITarget;
            target.updateState(n);
            try {
                iCDIExpressionManager = target.getCurrentThread();
                if (iCDIExpressionManager == null) {
                    return true;
                }
                iCDIExpressionManager.getCurrentStackFrame();
            }
            catch (CDIException cDIException) {
                return true;
            }
        }
        target = session.getVariableManager();
        iCDIExpressionManager = session.getExpressionManager();
        ICDIRegisterManager iCDIRegisterManager = session.getRegisterManager();
        ICDIMemoryManager iCDIMemoryManager = session.getMemoryManager();
        ICDIBreakpointManager iCDIBreakpointManager = session.getBreakpointManager();
        ICDISignalManager iCDISignalManager = session.getSignalManager();
        ICDISourceManager iCDISourceManager = session.getSourceManager();
        ICDISharedLibraryManager iCDISharedLibraryManager = session.getSharedLibraryManager();
        try {
            if (target.isAutoUpdate()) {
                target.update();
            }
            if (iCDIExpressionManager.isAutoUpdate()) {
                iCDIExpressionManager.update();
            }
            if (iCDIRegisterManager.isAutoUpdate()) {
                iCDIRegisterManager.update();
            }
            if (iCDIMemoryManager.isAutoUpdate()) {
                iCDIMemoryManager.update();
            }
            if (iCDIBreakpointManager.isAutoUpdate()) {
                iCDIBreakpointManager.update();
            }
            if (iCDISignalManager.isAutoUpdate()) {
                iCDISignalManager.update();
            }
            if (iCDISharedLibraryManager.isAutoUpdate()) {
                iCDISharedLibraryManager.update();
            }
            if (iCDISourceManager.isAutoUpdate()) {
                iCDISourceManager.update();
            }
        }
        catch (CDIException cDIException) {}
        return true;
    }

    boolean processSharedLibEvent(MIStoppedEvent mIStoppedEvent) {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        ICDITarget iCDITarget = session.getCurrentTarget();
        ICDISharedLibraryManager iCDISharedLibraryManager = session.getSharedLibraryManager();
        SharedLibraryManager sharedLibraryManager = null;
        if (iCDISharedLibraryManager instanceof SharedLibraryManager) {
            sharedLibraryManager = (SharedLibraryManager)iCDISharedLibraryManager;
        }
        if (sharedLibraryManager != null && sharedLibraryManager.isDeferredBreakpoint()) {
            if (mIStoppedEvent instanceof MISharedLibEvent) {
                Object object;
                MICommand mICommand;
                int n;
                Object object2;
                int n2;
                Object object3;
                Object object4;
                List list = null;
                try {
                    list = sharedLibraryManager.updateState();
                }
                catch (CDIException cDIException) {
                    list = Collections.EMPTY_LIST;
                }
                if (list.size() > 0) {
                    MIEvent[] mIEventArray;
                    object4 = session.getBreakpointManager();
                    if (object4 instanceof BreakpointManager) {
                        mIEventArray = (MIEvent[])object4;
                        object3 = null;
                        try {
                            object3 = mIEventArray.getDeferredBreakpoints();
                        }
                        catch (CDIException cDIException) {
                            object3 = new ICDIBreakpoint[]{};
                        }
                        n2 = 0;
                        while (n2 < ((ICDIBreakpoint[])object3).length) {
                            if (object3[n2] instanceof Breakpoint) {
                                object2 = (Breakpoint)object3[n2];
                                try {
                                    mIEventArray.setLocationBreakpoint((Breakpoint)object2);
                                    mIEventArray.deleteFromDeferredList((Breakpoint)object2);
                                    mIEventArray.addToBreakpointList((Breakpoint)object2);
                                    list.add(new MIBreakpointCreatedEvent(((Breakpoint)object2).getMIBreakpoint().getNumber()));
                                }
                                catch (CDIException cDIException) {}
                            }
                            ++n2;
                        }
                    }
                    mIEventArray = list.toArray(new MIEvent[0]);
                    mISession.fireEvents(mIEventArray);
                }
                object4 = mISession.getCommandFactory();
                int n3 = n = this.lastRunningEvent == null ? 0 : this.lastRunningEvent.getType();
                if (this.lastUserCommand == null) {
                    switch (n) {
                        case 1: {
                            this.lastUserCommand = ((CommandFactory)object4).createMIExecNext();
                            break;
                        }
                        case 2: {
                            this.lastUserCommand = ((CommandFactory)object4).createMIExecNextInstruction();
                            break;
                        }
                        case 3: {
                            this.lastUserCommand = ((CommandFactory)object4).createMIExecStep();
                            break;
                        }
                        case 4: {
                            this.lastUserCommand = ((CommandFactory)object4).createMIExecStepInstruction();
                            break;
                        }
                        case 5: {
                            this.lastUserCommand = ((CommandFactory)object4).createMIExecFinish();
                            break;
                        }
                        case 7: {
                            this.lastUserCommand = ((CommandFactory)object4).createMIExecReturn();
                            break;
                        }
                        case 0: {
                            object3 = ((CommandFactory)object4).createMIExecContinue();
                            try {
                                mISession.postCommand((Command)object3);
                                MIInfo mIInfo = ((Command)object3).getMIInfo();
                            }
                            catch (MIException mIException) {}
                            return true;
                        }
                    }
                }
                int n4 = 0;
                n2 = 0;
                object2 = null;
                try {
                    object2 = iCDITarget.getCurrentThread();
                }
                catch (CDIException cDIException) {}
                if (object2 instanceof Thread) {
                    n2 = ((Thread)object2).getId();
                }
                ICDIStackFrame iCDIStackFrame = null;
                try {
                    iCDIStackFrame = object2.getCurrentStackFrame();
                }
                catch (CDIException cDIException) {}
                int n5 = 0;
                try {
                    mICommand = ((CommandFactory)object4).createMIStackInfoDepth();
                    mISession.postCommand(mICommand);
                    object = mICommand.getMIStackInfoDepthInfo();
                    n5 = ((MIStackInfoDepthInfo)object).getDepth();
                }
                catch (MIException mIException) {}
                if (iCDIStackFrame != null) {
                    n4 = n5 - iCDIStackFrame.getLevel() - 1;
                }
                if (n2 > 0) {
                    mICommand = ((CommandFactory)object4).createMIThreadSelect(n2);
                    try {
                        mISession.postCommand(mICommand);
                    }
                    catch (MIException mIException) {}
                }
                if (n4 >= 0) {
                    mICommand = ((CommandFactory)object4).createMIStackSelectFrame(n4);
                    object = ((CommandFactory)object4).createMIExecFinish();
                    try {
                        mISession.postCommand(mICommand);
                        mISession.postCommand((Command)object);
                    }
                    catch (MIException mIException) {}
                }
                return true;
            }
            if (this.lastUserCommand != null) {
                Command command = this.lastUserCommand;
                this.lastUserCommand = null;
                try {
                    mISession.postCommand(command);
                }
                catch (MIException mIException) {}
                return true;
            }
        }
        return false;
    }

    boolean processRunningEvent(MIRunningEvent mIRunningEvent) {
        this.lastRunningEvent = mIRunningEvent;
        return true;
    }

    void disableEventToken(int n) {
        this.tokenList.add(new Integer(n));
    }

    void disableEventTokens(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.disableEventToken(nArray[n]);
            ++n;
        }
    }

    void enableEventToken(int n) {
        Integer n2 = new Integer(n);
        if (this.tokenList.contains(n2)) {
            this.tokenList.remove(n2);
        }
    }

    void enableEventTokens(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.enableEventToken(nArray[n]);
            ++n;
        }
    }

    private boolean ignoreEventToken(int n) {
        return this.tokenList.contains(new Integer(n));
    }
}

