/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MISteppingRangeEvent
extends MIStoppedEvent {
    public MISteppingRangeEvent(MIExecAsyncOutput mIExecAsyncOutput) {
        super(mIExecAsyncOutput);
        this.parse();
    }

    public MISteppingRangeEvent(MIResultRecord mIResultRecord) {
        super(mIResultRecord);
        this.parse();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("thread-id=").append(this.getThreadId()).append('\n');
        MIFrame mIFrame = this.getFrame();
        if (mIFrame != null) {
            stringBuffer.append(this.getFrame().toString());
        }
        return stringBuffer.toString();
    }

    void parse() {
        MIResult[] mIResultArray = null;
        MIExecAsyncOutput mIExecAsyncOutput = this.getMIExecAsyncOutput();
        MIResultRecord mIResultRecord = this.getMIResultRecord();
        if (mIExecAsyncOutput != null) {
            mIResultArray = mIExecAsyncOutput.getMIResults();
        } else if (mIResultRecord != null) {
            mIResultArray = mIResultRecord.getMIResults();
        }
        if (mIResultArray != null) {
            int n = 0;
            while (n < mIResultArray.length) {
                Object object;
                String string = mIResultArray[n].getVariable();
                MIValue mIValue = mIResultArray[n].getMIValue();
                if (string.equals("thread-id")) {
                    if (mIValue instanceof MIConst) {
                        object = ((MIConst)mIValue).getString();
                        try {
                            int n2 = Integer.parseInt(((String)object).trim());
                            this.setThreadId(n2);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (string.equals("frame") && mIValue instanceof MITuple) {
                    object = new MIFrame((MITuple)mIValue);
                    this.setFrame((MIFrame)object);
                }
                ++n;
            }
        }
    }
}

