/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class RunToLineRulerAction
extends Action
implements IUpdate,
ISelectionListener,
INullSelectionListener {
    private IVerticalRulerInfo fInfo;
    private ITextEditor fTextEditor;
    private IRunToLine fTarget = null;

    public RunToLineRulerAction(IVerticalRulerInfo iVerticalRulerInfo, ITextEditor iTextEditor) {
        this.setInfo(iVerticalRulerInfo);
        this.setTextEditor(iTextEditor);
        this.setText(CDebugUIPlugin.getResourceString("internal.ui.actions.RunToLineRulerAction.Run_To_Line"));
        this.initializeTarget();
        this.update();
    }

    public void update() {
        boolean bl = false;
        IFile iFile = this.getFile();
        int n = this.getLineNumber();
        IDocumentProvider iDocumentProvider = this.getTextEditor().getDocumentProvider();
        IDocument iDocument = iDocumentProvider.getDocument((Object)this.getTextEditor().getEditorInput());
        if (iFile != null && n <= iDocument.getNumberOfLines() && n > 0) {
            bl = this.getTarget() != null && this.getTarget().canRunToLine(iFile, n);
        }
        this.setEnabled(bl);
    }

    public void run() {
        this.runToLine(this.getFile(), this.getLineNumber());
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IRunToLine iRunToLine = null;
        if (iWorkbenchPart.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            Object object;
            if (iSelection != null && iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) != null && object instanceof IRunToLine) {
                iRunToLine = (IRunToLine)object;
            }
            this.setTarget(iRunToLine);
            this.update();
        }
    }

    protected void initializeTarget() {
        this.setTarget(null);
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        if (iAdaptable != null && iAdaptable instanceof IRunToLine) {
            this.setTarget((IRunToLine)iAdaptable);
        }
    }

    protected void setTarget(IRunToLine iRunToLine) {
        this.fTarget = iRunToLine;
    }

    protected IRunToLine getTarget() {
        return this.fTarget;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo iVerticalRulerInfo) {
        this.fInfo = iVerticalRulerInfo;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor iTextEditor) {
        this.fTextEditor = iTextEditor;
    }

    protected IFile getFile() {
        IEditorInput iEditorInput = this.getTextEditor().getEditorInput();
        if (iEditorInput != null && iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        return null;
    }

    protected int getLineNumber() {
        return this.getInfo().getLineOfLastMouseButtonActivity() + 1;
    }

    protected void runToLine(IFile iFile, int n) {
        if (!this.getTarget().canRunToLine(iFile, n)) {
            this.getTextEditor().getSite().getShell().getDisplay().beep();
            return;
        }
        try {
            this.getTarget().runToLine(iFile, n);
        }
        catch (DebugException debugException) {
            CDebugUIPlugin.errorDialog(debugException.getMessage(), debugException);
        }
    }
}

