/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class BasicSearchMatch
implements IMatch,
Comparable {
    public String name = null;
    public String parentName = null;
    public String returnType;
    public IResource resource = null;
    public IPath path = null;
    public int startOffset = 0;
    public int endOffset = 0;
    public int type = 0;
    public int visibility = 0;
    boolean isConst = false;
    boolean isVolatile = false;
    boolean isStatic = false;

    public BasicSearchMatch() {
    }

    public BasicSearchMatch(BasicSearchMatch basicSearchMatch) {
        this.name = basicSearchMatch.name;
        this.parentName = basicSearchMatch.parentName;
        this.returnType = basicSearchMatch.returnType;
        this.resource = basicSearchMatch.resource;
        this.path = basicSearchMatch.path;
        this.startOffset = basicSearchMatch.startOffset;
        this.endOffset = basicSearchMatch.endOffset;
    }

    public int hashCode() {
        String string = "";
        string = String.valueOf(string) + this.name;
        string = String.valueOf(string) + ":" + this.parentName;
        string = String.valueOf(string) + ":" + this.returnType;
        if (this.getLocation() != null) {
            string = String.valueOf(string) + ":" + this.getLocation().toString();
        }
        string = String.valueOf(string) + ":" + this.startOffset + ":" + this.endOffset;
        string = String.valueOf(string) + ":" + this.type + ":" + this.visibility;
        return string.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicSearchMatch)) {
            return false;
        }
        BasicSearchMatch basicSearchMatch = (BasicSearchMatch)object;
        if (this.startOffset != basicSearchMatch.getStartOffset() || this.endOffset != basicSearchMatch.getEndOffset()) {
            return false;
        }
        if (this.type != basicSearchMatch.getElementType() || this.visibility != basicSearchMatch.getVisibility()) {
            return false;
        }
        if (this.name != null && basicSearchMatch.getName() != null ? !this.name.equals(basicSearchMatch.getName()) : this.name != basicSearchMatch.getName()) {
            return false;
        }
        if (this.parentName != null && basicSearchMatch.getParentName() != null ? !this.parentName.equals(basicSearchMatch.getParentName()) : this.parentName != basicSearchMatch.getParentName()) {
            return false;
        }
        if (this.returnType != null && basicSearchMatch.getReturnType() != null ? !this.returnType.equals(basicSearchMatch.getReturnType()) : this.returnType != basicSearchMatch.getReturnType()) {
            return false;
        }
        IPath iPath = this.getLocation();
        IPath iPath2 = basicSearchMatch.getLocation();
        return !(iPath != null && iPath2 != null ? !iPath.equals((Object)iPath2) : iPath != iPath2);
    }

    public int compareTo(Object object) {
        if (!(object instanceof BasicSearchMatch)) {
            throw new ClassCastException();
        }
        BasicSearchMatch basicSearchMatch = (BasicSearchMatch)object;
        String string = this.getLocation().toString();
        String string2 = basicSearchMatch.getLocation().toString();
        string = String.valueOf(string) + " " + this.getStartOffset() + " ";
        string2 = String.valueOf(string2) + " " + basicSearchMatch.getStartOffset() + " ";
        string = String.valueOf(string) + this.getName() + " " + this.getParentName() + " " + this.getReturnType();
        string2 = String.valueOf(string2) + basicSearchMatch.getName() + " " + basicSearchMatch.getParentName() + " " + this.getReturnType();
        return string.compareTo(string2);
    }

    public int getElementType() {
        return this.type;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public IResource getResource() {
        return this.resource;
    }

    public IPath getLocation() {
        if (this.resource != null) {
            return this.resource.getLocation();
        }
        if (this.path != null) {
            return this.path;
        }
        return null;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public int getType() {
        return this.type;
    }

    public void setEndOffset(int n) {
        this.endOffset = n;
    }

    public void setConst(boolean bl) {
        this.isConst = bl;
    }

    public void setStatic(boolean bl) {
        this.isStatic = bl;
    }

    public void setVolatile(boolean bl) {
        this.isVolatile = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParentName(String string) {
        this.parentName = string;
    }

    public void setReturnType(String string) {
        this.returnType = string;
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setVisibility(int n) {
        this.visibility = n;
    }
}

