/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.cdt.internal.core.CExtensionInfo;
import org.eclipse.cdt.internal.core.CExtensionReference;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.InternalCExtension;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CDescriptor
implements ICDescriptor {
    private COwner fOwner;
    private IProject fProject;
    private HashMap extMap = new HashMap(4);
    private HashMap extInfoMap = new HashMap(4);
    private Document dataDoc;
    static final String CEXTENSION_NAME = "cextension";
    static final String DESCRIPTION_FILE_NAME = ".cdtproject";
    private static final char[][] NO_CHAR_CHAR = new char[0][];
    private static final String PROJECT_DESCRIPTION = "cdtproject";
    private static final String PROJECT_EXTENSION = "extension";
    private static final String PROJECT_EXTENSION_ATTRIBUTE = "attribute";
    private static final String PROJECT_DATA = "data";
    private static final String PROJECT_DATA_ITEM = "item";
    private static final String PROJECT_DATA_ID = "id";
    private boolean fDirty;
    private boolean autoSave;

    protected CDescriptor(IProject iProject, String string) throws CoreException {
        IPath iPath;
        this.fProject = iProject;
        IPath iPath2 = iProject.getDescription().getLocation();
        if (iPath2 == null) {
            iPath2 = this.getProjectDefaultLocation(iProject);
        }
        if ((iPath = iPath2.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            Status status;
            String string2 = this.readCDTProject(iPath);
            if (string2.equals(string)) {
                this.fOwner = new COwner(string2);
                status = new Status(2, "org.eclipse.cdt.core", 1, CCorePlugin.getResourceString("CDescriptor.exception.projectAlreadyExists"), null);
            } else {
                status = new Status(4, "org.eclipse.cdt.core", 2, CCorePlugin.getResourceString("CDescriptor.exception.unmatchedOwnerId"), null);
            }
            throw new CoreException((IStatus)status);
        }
        this.fOwner = new COwner(string);
    }

    protected CDescriptor(IProject iProject) throws CoreException {
        IPath iPath;
        this.fProject = iProject;
        IPath iPath2 = iProject.getDescription().getLocation();
        if (iPath2 == null) {
            iPath2 = this.getProjectDefaultLocation(iProject);
        }
        if (!(iPath = iPath2.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.fileNotFound"), null);
            throw new CoreException((IStatus)status);
        }
        this.fOwner = new COwner(this.readCDTProject(iPath));
    }

    protected CDescriptor(IProject iProject, COwner cOwner) throws CoreException {
        IPath iPath;
        this.fProject = iProject;
        IPath iPath2 = iProject.getDescription().getLocation();
        if (iPath2 == null) {
            iPath2 = this.getProjectDefaultLocation(iProject);
        }
        if (!(iPath = iPath2.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.fileNotFound"), null);
            throw new CoreException((IStatus)status);
        }
        this.readCDTProject(iPath);
        this.fOwner = cOwner;
        this.setDirty();
    }

    protected COwner getOwner() {
        return this.fOwner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readCDTProject(IPath iPath) throws CoreException {
        String string;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(iPath.toFile());
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(fileInputStream);
                Node node = document.getFirstChild();
                if (!node.getNodeName().equals(PROJECT_DESCRIPTION)) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.missingElement"), null);
                    throw new CoreException((IStatus)status);
                }
                String string2 = node.getAttributes().getNamedItem(PROJECT_DATA_ID).getNodeValue();
                if (string2 == null) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.missingOwnerId"), null);
                    throw new CoreException((IStatus)status);
                }
                this.readProjectDescription(node);
                string = string2;
                Object var8_11 = null;
                if (fileInputStream == null) return string;
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.cdt.core", -1, exception.getLocalizedMessage(), (Throwable)exception);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return string;
    }

    private IPath getProjectDefaultLocation(IProject iProject) {
        return Platform.getLocation().append(iProject.getFullPath());
    }

    public ICOwnerInfo getProjectOwner() {
        return this.fOwner;
    }

    public String getPlatform() {
        return this.fOwner.getPlatform();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public ICExtensionReference[] get(String string) {
        ICExtensionReference[] iCExtensionReferenceArray = (CExtensionReference[])this.extMap.get(string);
        if (iCExtensionReferenceArray == null) {
            return new ICExtensionReference[0];
        }
        return iCExtensionReferenceArray;
    }

    public ICExtensionReference[] get(String string, boolean bl) {
        ICExtensionReference[] iCExtensionReferenceArray = this.get(string);
        if (iCExtensionReferenceArray.length == 0 && bl) {
            try {
                this.fOwner.update(this.fProject, this, string);
                this.saveInfo();
                iCExtensionReferenceArray = this.get(string);
            }
            catch (CoreException coreException) {}
        }
        return iCExtensionReferenceArray;
    }

    public ICExtensionReference create(String string, String string2) throws CoreException {
        CExtensionReference[] cExtensionReferenceArray = (CExtensionReference[])this.extMap.get(string);
        if (cExtensionReferenceArray == null) {
            cExtensionReferenceArray = new CExtensionReference[1];
            this.extMap.put(string, cExtensionReferenceArray);
        } else {
            CExtensionReference[] cExtensionReferenceArray2 = new CExtensionReference[cExtensionReferenceArray.length + 1];
            System.arraycopy(cExtensionReferenceArray, 0, cExtensionReferenceArray2, 0, cExtensionReferenceArray.length);
            cExtensionReferenceArray = cExtensionReferenceArray2;
            this.extMap.put(string, cExtensionReferenceArray);
        }
        cExtensionReferenceArray[cExtensionReferenceArray.length - 1] = new CExtensionReference(this, string, string2);
        this.setDirty();
        return cExtensionReferenceArray[cExtensionReferenceArray.length - 1];
    }

    public void remove(ICExtensionReference iCExtensionReference) throws CoreException {
        CExtensionReference[] cExtensionReferenceArray = (CExtensionReference[])this.extMap.get(iCExtensionReference.getExtension());
        int n = 0;
        while (n < cExtensionReferenceArray.length) {
            if (cExtensionReferenceArray[n] == iCExtensionReference) {
                System.arraycopy(cExtensionReferenceArray, n, cExtensionReferenceArray, n + 1, cExtensionReferenceArray.length - 1 - n);
                CExtensionReference[] cExtensionReferenceArray2 = new CExtensionReference[cExtensionReferenceArray.length - 1];
                System.arraycopy(cExtensionReferenceArray, 0, cExtensionReferenceArray2, 0, cExtensionReferenceArray.length);
                cExtensionReferenceArray = cExtensionReferenceArray2;
                if (cExtensionReferenceArray.length == 0) {
                    this.extMap.put(iCExtensionReference.getExtension(), null);
                } else {
                    this.extMap.put(iCExtensionReference.getExtension(), cExtensionReferenceArray);
                }
                this.setDirty();
            }
            ++n;
        }
    }

    public void remove(String string) throws CoreException {
        CExtensionReference[] cExtensionReferenceArray = (CExtensionReference[])this.extMap.get(string);
        if (cExtensionReferenceArray != null) {
            this.extMap.remove(string);
            this.setDirty();
        }
    }

    public CExtensionInfo getInfo(CExtensionReference cExtensionReference) {
        CExtensionInfo cExtensionInfo = (CExtensionInfo)this.extInfoMap.get(cExtensionReference);
        if (cExtensionInfo == null) {
            cExtensionInfo = new CExtensionInfo();
            this.extInfoMap.put(cExtensionReference, cExtensionInfo);
        }
        return cExtensionInfo;
    }

    protected void saveInfo() throws CoreException {
        String string;
        if (!this.isDirty()) {
            return;
        }
        try {
            string = this.getAsXML();
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, iOException.getMessage(), (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        IFile iFile = this.getProject().getFile(DESCRIPTION_FILE_NAME);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, 1, null);
        } else {
            iFile.create((InputStream)byteArrayInputStream, 1, null);
        }
        this.fDirty = false;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean bl) {
        this.autoSave = bl;
    }

    protected void setDirty() throws CoreException {
        this.fDirty = true;
        if (this.isAutoSave()) {
            this.saveInfo();
        }
    }

    protected boolean isDirty() {
        return this.fDirty;
    }

    protected String serializeDocument(Document document) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndenting(true);
        outputFormat.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8"), outputFormat);
        serializer.asDOMSerializer().serialize(document);
        return byteArrayOutputStream.toString("UTF8");
    }

    private void readProjectDescription(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 1) {
                if (node2.getNodeName().equals(PROJECT_EXTENSION)) {
                    try {
                        this.decodeProjectExtension((Element)node2);
                    }
                    catch (CoreException coreException) {
                        CCorePlugin.log(coreException);
                    }
                } else if (node2.getNodeName().equals(PROJECT_DATA)) {
                    try {
                        this.decodeProjectData((Element)node2);
                    }
                    catch (CoreException coreException) {
                        CCorePlugin.log(coreException);
                    }
                }
            }
            ++n;
        }
    }

    private void decodeProjectExtension(Element element) throws CoreException {
        ICExtensionReference iCExtensionReference = this.create(element.getAttribute("point"), element.getAttribute(PROJECT_DATA_ID));
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeName().equals(PROJECT_EXTENSION_ATTRIBUTE)) {
                NamedNodeMap namedNodeMap = nodeList.item(n).getAttributes();
                iCExtensionReference.setExtensionData(namedNodeMap.getNamedItem("key").getNodeValue(), namedNodeMap.getNamedItem("value").getNodeValue());
            }
            ++n;
        }
    }

    protected String getAsXML() throws IOException {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement(PROJECT_DESCRIPTION);
        documentImpl.appendChild(element);
        element.setAttribute(PROJECT_DATA_ID, this.fOwner.getID());
        this.encodeProjectExtensions((Document)documentImpl, element);
        this.encodeProjectData((Document)documentImpl, element);
        return this.serializeDocument((Document)documentImpl);
    }

    private void encodeProjectExtensions(Document document, Element element) {
        Iterator iterator = this.extMap.values().iterator();
        while (iterator.hasNext()) {
            CExtensionReference[] cExtensionReferenceArray = (CExtensionReference[])iterator.next();
            int n = 0;
            while (n < cExtensionReferenceArray.length) {
                Element element2 = document.createElement(PROJECT_EXTENSION);
                element.appendChild(element2);
                element2.setAttribute("point", cExtensionReferenceArray[n].getExtension());
                element2.setAttribute(PROJECT_DATA_ID, cExtensionReferenceArray[n].getID());
                CExtensionInfo cExtensionInfo = (CExtensionInfo)this.extInfoMap.get(cExtensionReferenceArray[n]);
                if (cExtensionInfo != null) {
                    Iterator iterator2 = cExtensionInfo.getAttributes().entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry = iterator2.next();
                        Element element3 = document.createElement(PROJECT_EXTENSION_ATTRIBUTE);
                        element3.setAttribute("key", (String)entry.getKey());
                        element3.setAttribute("value", (String)entry.getValue());
                        element2.appendChild(element3);
                    }
                }
                ++n;
            }
        }
    }

    protected ICExtension createExtensions(ICExtensionReference iCExtensionReference) throws CoreException {
        InternalCExtension internalCExtension = null;
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint(iCExtensionReference.getExtension());
        IExtension iExtension = iExtensionPoint.getExtension(iCExtensionReference.getID());
        if (iExtension == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.providerNotFound"), null));
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equalsIgnoreCase(CEXTENSION_NAME)) {
                internalCExtension = (InternalCExtension)((Object)iConfigurationElementArray[n].createExecutableExtension("run"));
                internalCExtension.setExtenionReference(iCExtensionReference);
                internalCExtension.setProject(this.fProject);
                break;
            }
            ++n;
        }
        return (ICExtension)((Object)internalCExtension);
    }

    protected IConfigurationElement[] getConfigurationElement(ICExtensionReference iCExtensionReference) throws CoreException {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint(iCExtensionReference.getExtension());
        IExtension iExtension = iExtensionPoint.getExtension(iCExtensionReference.getID());
        if (iExtension == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptor.exception.providerNotFound"), null));
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equalsIgnoreCase(CEXTENSION_NAME)) {
                return iConfigurationElementArray[n].getChildren();
            }
            ++n;
        }
        return new IConfigurationElement[0];
    }

    private Document getProjectDataDoc() throws CoreException {
        if (this.dataDoc == null) {
            try {
                this.dataDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 4, "getProjectDataDoc", (Throwable)parserConfigurationException));
            }
            Element element = this.dataDoc.createElement(PROJECT_DATA);
            this.dataDoc.appendChild(element);
        }
        return this.dataDoc;
    }

    private void decodeProjectData(Element element) throws CoreException {
        Document document = this.getProjectDataDoc();
        document.replaceChild(document.importNode(element, true), document.getDocumentElement());
    }

    public Element getProjectData(String string) throws CoreException {
        NodeList nodeList = this.getProjectDataDoc().getDocumentElement().getElementsByTagName(PROJECT_DATA_ITEM);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            if (element.getAttribute(PROJECT_DATA_ID).equals(string)) {
                return element;
            }
            ++n;
        }
        Element element = this.dataDoc.createElement(PROJECT_DATA_ITEM);
        element.setAttribute(PROJECT_DATA_ID, string);
        this.dataDoc.getDocumentElement().appendChild(element);
        return element;
    }

    public void saveProjectData() throws CoreException {
        this.setDirty();
    }

    private void encodeProjectData(Document document, Element element) {
        if (this.dataDoc != null) {
            element.appendChild(document.importNode(this.dataDoc.getDocumentElement(), true));
        }
    }
}

