/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexOutput;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.Int;
import org.eclipse.cdt.internal.core.index.impl.Util;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.processing.JobManager;

public class MergeFactory {
    protected IndexInput addsInput;
    protected IndexInput oldInput;
    protected BlocksIndexOutput mergeOutput;
    protected Map removedInOld;
    protected Map removedInAdds;
    protected int[] mappingOld;
    protected int[] mappingAdds;
    public static final int ADDS_INDEX = 0;
    public static final int OLD_INDEX = 1;

    public MergeFactory(IndexInput indexInput, IndexInput indexInput2, BlocksIndexOutput blocksIndexOutput, Map map, Map map2) {
        this.oldInput = indexInput;
        this.addsInput = indexInput2;
        this.mergeOutput = blocksIndexOutput;
        this.removedInOld = map;
        this.removedInAdds = map2;
    }

    protected void init() {
        this.mappingOld = new int[this.oldInput.getNumFiles() + 1];
        this.mappingAdds = new int[this.addsInput.getNumFiles() + 1];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void merge() throws IOException {
        try {
            try {
                this.addsInput.open();
                this.oldInput.open();
                this.mergeOutput.open();
                this.init();
                this.mergeFiles();
                this.mergeReferences();
                this.mergeIncludes();
                this.mergeOutput.flush();
            }
            catch (Exception exception) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> got the following exception during merge:");
                    exception.printStackTrace();
                }
            }
            catch (VirtualMachineError virtualMachineError) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> got the following exception during merge:");
                    virtualMachineError.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.oldInput.close();
            this.addsInput.close();
            this.mergeOutput.close();
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        this.oldInput.close();
        this.addsInput.close();
        this.mergeOutput.close();
    }

    protected void mergeFiles() throws IOException {
        int n = 1;
        while (this.oldInput.hasMoreFiles() || this.addsInput.hasMoreFiles()) {
            IndexedFile indexedFile = this.oldInput.getCurrentFile();
            IndexedFile indexedFile2 = this.addsInput.getCurrentFile();
            while (indexedFile != null && this.wasRemoved(indexedFile, 1)) {
                this.oldInput.moveToNextFile();
                indexedFile = this.oldInput.getCurrentFile();
            }
            while (indexedFile2 != null && this.wasRemoved(indexedFile2, 0)) {
                this.addsInput.moveToNextFile();
                indexedFile2 = this.addsInput.getCurrentFile();
            }
            if (indexedFile == null && indexedFile2 == null) break;
            int n2 = indexedFile == null ? 1 : (indexedFile2 == null ? -1 : indexedFile.getPath().compareTo(indexedFile2.getPath()));
            if (n2 == 0) {
                this.removeFile(indexedFile, 1);
                this.mappingAdds[indexedFile2.getFileNumber()] = n;
                indexedFile.setFileNumber(n);
                this.mergeOutput.addFile(indexedFile);
                this.oldInput.moveToNextFile();
                this.addsInput.moveToNextFile();
            } else if (n2 < 0) {
                this.mappingOld[indexedFile.getFileNumber()] = n;
                indexedFile.setFileNumber(n);
                this.mergeOutput.addFile(indexedFile);
                this.oldInput.moveToNextFile();
            } else {
                this.mappingAdds[indexedFile2.getFileNumber()] = n;
                indexedFile2.setFileNumber(n);
                this.mergeOutput.addFile(indexedFile2);
                this.addsInput.moveToNextFile();
            }
            ++n;
        }
        this.mergeOutput.flushFiles();
    }

    protected void mergeReferences() throws IOException {
        while (this.oldInput.hasMoreWords() || this.addsInput.hasMoreWords()) {
            WordEntry wordEntry = this.oldInput.getCurrentWordEntry();
            WordEntry wordEntry2 = this.addsInput.getCurrentWordEntry();
            if (wordEntry == null && wordEntry2 == null) break;
            int n = wordEntry == null ? 1 : (wordEntry2 == null ? -1 : Util.compare(wordEntry.getWord(), wordEntry2.getWord()));
            if (n < 0) {
                wordEntry.mapRefs(this.mappingOld);
                this.mergeOutput.addWord(wordEntry);
                this.oldInput.moveToNextWordEntry();
                continue;
            }
            if (n > 0) {
                wordEntry2.mapRefs(this.mappingAdds);
                this.mergeOutput.addWord(wordEntry2);
                this.addsInput.moveToNextWordEntry();
                continue;
            }
            wordEntry.mapRefs(this.mappingOld);
            wordEntry2.mapRefs(this.mappingAdds);
            wordEntry.addRefs(wordEntry2.getRefs());
            this.mergeOutput.addWord(wordEntry);
            this.addsInput.moveToNextWordEntry();
            this.oldInput.moveToNextWordEntry();
        }
        this.mergeOutput.flushWords();
    }

    protected void mergeIncludes() throws IOException {
        while (this.oldInput.hasMoreIncludes() || this.addsInput.hasMoreIncludes()) {
            IncludeEntry includeEntry = this.oldInput.getCurrentIncludeEntry();
            IncludeEntry includeEntry2 = this.addsInput.getCurrentIncludeEntry();
            if (includeEntry == null && includeEntry2 == null) break;
            int n = includeEntry == null ? 1 : (includeEntry2 == null ? -1 : Util.compare(includeEntry.getFile(), includeEntry2.getFile()));
            if (n < 0) {
                includeEntry.mapRefs(this.mappingOld);
                this.mergeOutput.addInclude(includeEntry);
                this.oldInput.moveToNextIncludeEntry();
                continue;
            }
            if (n > 0) {
                includeEntry2.mapRefs(this.mappingAdds);
                this.mergeOutput.addInclude(includeEntry2);
                this.addsInput.moveToNextIncludeEntry();
                continue;
            }
            includeEntry.mapRefs(this.mappingOld);
            includeEntry2.mapRefs(this.mappingAdds);
            includeEntry.addRefs(includeEntry2.getRefs());
            this.mergeOutput.addInclude(includeEntry);
            this.addsInput.moveToNextIncludeEntry();
            this.oldInput.moveToNextIncludeEntry();
        }
        this.mergeOutput.flushIncludes();
    }

    protected void removeFile(IndexedFile indexedFile, int n) {
        if (n == 1) {
            this.mappingOld[indexedFile.getFileNumber()] = -1;
        } else {
            this.mappingAdds[indexedFile.getFileNumber()] = -1;
        }
    }

    protected boolean wasRemoved(IndexedFile indexedFile, int n) {
        int n2;
        Int intVal;
        String string = indexedFile.getPath();
        if (n == 1) {
            if (this.removedInOld.remove(string) != null) {
                this.mappingOld[indexedFile.getFileNumber()] = -1;
                return true;
            }
        } else if (n == 0 && (intVal = (Int)this.removedInAdds.get(string)) != null && intVal.value >= (n2 = indexedFile.getFileNumber())) {
            this.mappingAdds[n2] = -1;
            return true;
        }
        return false;
    }
}

