/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.Archive;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelCache;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.DeltaProcessor;
import org.eclipse.cdt.internal.core.model.NullBinaryParser;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceMapper;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CModelManager
implements IResourceChangeListener {
    final CModel cModel = new CModel();
    public static HashSet OptionNames = new HashSet(20);
    protected DeltaProcessor fDeltaProcessor = new DeltaProcessor();
    private ArrayList fCModelDeltas = new ArrayList();
    protected boolean fFire = true;
    protected ArrayList fElementChangedListeners = new ArrayList();
    public Map sharedWorkingCopies = new HashMap();
    protected Map elementsOutOfSynchWithBuffers = new HashMap(11);
    protected CModelCache cache = new CModelCache();
    public ICProject[] cProjectsCache;
    private HashMap binaryRunners = new HashMap();
    private HashMap binaryParsersMap = new HashMap();
    private HashMap sourceMappers = new HashMap();
    public static final String[] sourceExtensions = new String[]{"c", "cxx", "cc", "C", "cpp"};
    public static final String[] headerExtensions = new String[]{"h", "hh", "hpp", "H"};
    public static final String[] assemblyExtensions = new String[]{"s", "S"};
    public static final IWorkingCopy[] NoWorkingCopy = new IWorkingCopy[0];
    static CModelManager factory = null;

    private CModelManager() {
    }

    public static CModelManager getDefault() {
        if (factory == null) {
            factory = new CModelManager();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)factory, 15);
        }
        return factory;
    }

    public ICModel getCModel(IWorkspaceRoot iWorkspaceRoot) {
        return this.getCModel();
    }

    public ICModel getCModel() {
        return this.cModel;
    }

    public ICElement create(IPath iPath) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(iPath);
        if (iResource == null) {
            IPath iPath2 = iWorkspaceRoot.getLocation();
            if (iPath.equals((Object)iPath2)) {
                return this.getCModel(iWorkspaceRoot);
            }
            iResource = iWorkspaceRoot.getContainerForLocation(iPath);
            if (iResource == null || !iResource.exists()) {
                iResource = iWorkspaceRoot.getFileForLocation(iPath);
            }
            if (iResource != null && !iResource.exists()) {
                iResource = null;
            }
        }
        return this.create(iResource);
    }

    public ICElement create(IResource iResource) {
        if (iResource == null) {
            return null;
        }
        int n = iResource.getType();
        switch (n) {
            case 4: {
                return this.create((IProject)iResource);
            }
            case 1: {
                return this.create((IFile)iResource);
            }
            case 2: {
                return this.create((IFolder)iResource);
            }
            case 8: {
                return this.create((IWorkspaceRoot)iResource);
            }
        }
        return null;
    }

    public ICElement create(ICElement iCElement, IResource iResource) {
        int n = iResource.getType();
        switch (n) {
            case 4: {
                return this.create(iCElement, (IProject)iResource);
            }
            case 1: {
                return this.create(iCElement, (IFile)iResource);
            }
            case 2: {
                return this.create(iCElement, (IFolder)iResource);
            }
            case 8: {
                return this.create((IWorkspaceRoot)iResource);
            }
        }
        return null;
    }

    public ICElement create(IFile iFile) {
        IContainer iContainer = iFile.getParent();
        ICContainer iCContainer = null;
        if (iContainer instanceof IFolder) {
            iCContainer = this.create((IFolder)iContainer);
        } else if (iContainer instanceof IProject) {
            iCContainer = this.create((IProject)iContainer);
        }
        if (iCContainer != null) {
            return this.create((ICElement)iCContainer, iFile);
        }
        return null;
    }

    public ICElement create(ICElement iCElement, IFile iFile) {
        return this.create(iCElement, iFile, null);
    }

    public synchronized ICElement create(ICElement iCElement, IFile iFile, IBinaryParser.IBinaryFile iBinaryFile) {
        Openable openable = null;
        if (this.isTranslationUnit(iFile)) {
            openable = new TranslationUnit(iCElement, iFile);
        } else if (iFile.exists()) {
            if (iBinaryFile == null) {
                iBinaryFile = this.createBinaryFile(iFile);
            }
            if (iBinaryFile != null) {
                openable = iBinaryFile.getType() == 8 ? new Archive(iCElement, iFile, (IBinaryParser.IBinaryArchive)iBinaryFile) : new Binary(iCElement, iFile, iBinaryFile);
            }
        }
        if (openable != null && (openable instanceof IBinary || openable instanceof IArchive)) {
            if (iBinaryFile == null) {
                iBinaryFile = this.createBinaryFile(iFile);
            }
            if (iBinaryFile != null) {
                if (iBinaryFile.getType() == 8) {
                    CProject cProject = (CProject)openable.getCProject();
                    ArchiveContainer archiveContainer = (ArchiveContainer)cProject.getArchiveContainer();
                    archiveContainer.addChild(openable);
                } else if (iBinaryFile.getType() == 2 || iBinaryFile.getType() == 4) {
                    CProject cProject = (CProject)openable.getCProject();
                    BinaryContainer binaryContainer = (BinaryContainer)cProject.getBinaryContainer();
                    binaryContainer.addChild(openable);
                }
            }
        }
        return openable;
    }

    public ICContainer create(IFolder iFolder) {
        IContainer iContainer = iFolder.getParent();
        ICContainer iCContainer = null;
        if (iContainer instanceof IFolder) {
            iCContainer = this.create((IFolder)iContainer);
        } else if (iContainer instanceof IProject) {
            iCContainer = this.create((IProject)iContainer);
        }
        if (iCContainer != null) {
            return this.create((ICElement)iCContainer, iFolder);
        }
        return null;
    }

    public ICContainer create(ICElement iCElement, IFolder iFolder) {
        return new CContainer(iCElement, (IResource)iFolder);
    }

    public ICProject create(IProject iProject) {
        IContainer iContainer = iProject.getParent();
        ICModel iCModel = null;
        if (iContainer instanceof IWorkspaceRoot) {
            iCModel = this.create((IWorkspaceRoot)iContainer);
        }
        return this.create(iCModel, iProject);
    }

    public ICProject create(ICElement iCElement, IProject iProject) {
        if (this.hasCNature(iProject)) {
            return new CProject(iCElement, iProject);
        }
        return null;
    }

    public ICModel create(IWorkspaceRoot iWorkspaceRoot) {
        return this.getCModel();
    }

    public void releaseCElement(ICElement iCElement) {
        Object object;
        block14: {
            CElementDelta cElementDelta;
            int n;
            ICElement[] iCElementArray;
            Object object2;
            block15: {
                IProject iProject;
                BinaryRunner binaryRunner;
                if (iCElement == null) {
                    return;
                }
                int n2 = iCElement.getElementType();
                if (n2 == 18) {
                    object = (CProject)iCElement.getCProject();
                    object2 = (ArchiveContainer)((CProject)object).getArchiveContainer();
                    object2.removeChild(iCElement);
                    iCElementArray = new CElementDelta(this.getCModel());
                    iCElementArray.changed((ICElement)object2, 4);
                    this.registerCModelDelta((ICElementDelta)iCElementArray);
                } else if (n2 == 14 && !((IBinary)iCElement).isObject()) {
                    object = (CProject)iCElement.getCProject();
                    object2 = (BinaryContainer)((CProject)object).getBinaryContainer();
                    object2.removeChild(iCElement);
                    iCElementArray = new CElementDelta(this.getCModel());
                    iCElementArray.changed((ICElement)object2, 4);
                    this.registerCModelDelta((ICElementDelta)iCElementArray);
                }
                if (!(iCElement instanceof IParent)) break block14;
                if (this.peekAtInfo(iCElement) == null) break block15;
                object = ((CElement)iCElement).getElementInfo();
                if (object == null) break block14;
                object2 = ((CElementInfo)object).getChildren();
                int n3 = 0;
                while (n3 < ((ICElement[])object2).length) {
                    this.releaseCElement(object2[n3]);
                    ++n3;
                }
                if (!(object instanceof CProjectInfo)) break block14;
                CProjectInfo cProjectInfo = (CProjectInfo)object;
                if (cProjectInfo.vBin != null) {
                    this.releaseCElement(cProjectInfo.vBin);
                }
                if (cProjectInfo.vLib != null) {
                    this.releaseCElement(cProjectInfo.vLib);
                }
                if ((binaryRunner = (BinaryRunner)this.binaryRunners.remove(iProject = iCElement.getCProject().getProject())) == null) break block14;
                binaryRunner.stop();
                break block14;
            }
            object = iCElement.getCProject();
            object2 = (CProjectInfo)this.peekAtInfo((ICElement)object);
            if (object2 != null && object2.vBin != null && this.peekAtInfo(object2.vBin) != null) {
                iCElementArray = object2.vBin.getChildren();
                n = 0;
                while (n < iCElementArray.length) {
                    if (iCElement.getPath().isPrefixOf(iCElementArray[n].getPath())) {
                        cElementDelta = new CElementDelta(this.getCModel());
                        cElementDelta.changed(object2.vBin, 4);
                        this.registerCModelDelta(cElementDelta);
                        object2.vBin.removeChild(iCElementArray[n]);
                    }
                    ++n;
                }
            }
            if (object2 != null && object2.vLib != null && this.peekAtInfo(object2.vLib) != null) {
                iCElementArray = object2.vLib.getChildren();
                n = 0;
                while (n < iCElementArray.length) {
                    if (iCElement.getPath().isPrefixOf(iCElementArray[n].getPath())) {
                        cElementDelta = new CElementDelta(this.getCModel());
                        cElementDelta.changed(object2.vLib, 4);
                        this.registerCModelDelta(cElementDelta);
                        object2.vLib.removeChild(iCElementArray[n]);
                    }
                    ++n;
                }
            }
        }
        if ((object = (Parent)iCElement.getParent()) != null) {
            ((Parent)object).removeChild(iCElement);
        }
        this.removeInfo(iCElement);
    }

    public IBinaryParser[] getBinaryParser(IProject iProject) {
        try {
            IBinaryParser[] iBinaryParserArray = (IBinaryParser[])this.binaryParsersMap.get(iProject);
            if (iBinaryParserArray == null) {
                iBinaryParserArray = CCorePlugin.getDefault().getBinaryParser(iProject);
            }
            if (iBinaryParserArray != null) {
                this.binaryParsersMap.put(iProject, iBinaryParserArray);
                return iBinaryParserArray;
            }
        }
        catch (CoreException coreException) {}
        return new IBinaryParser[]{new NullBinaryParser()};
    }

    public IBinaryParser.IBinaryFile createBinaryFile(IFile iFile) {
        Object object;
        int n;
        Object object2;
        IBinaryParser[] iBinaryParserArray = this.getBinaryParser(iFile.getProject());
        int n2 = 0;
        int n3 = 0;
        while (n3 < iBinaryParserArray.length) {
            object2 = iBinaryParserArray[n3];
            if (object2.getHintBufferSize() > n2) {
                n2 = object2.getHintBufferSize();
            }
            ++n3;
        }
        Object object3 = new byte[n2];
        if (n2 > 0) {
            try {
                object2 = iFile.getContents();
                n = ((InputStream)object2).read((byte[])object3);
                ((InputStream)object2).close();
                if (n > 0 && n < ((byte[])object3).length) {
                    object = new byte[n];
                    System.arraycopy(object3, 0, object, 0, n);
                    object3 = object;
                }
            }
            catch (CoreException coreException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        object2 = iFile.getLocation();
        n = 0;
        while (n < iBinaryParserArray.length) {
            try {
                object = iBinaryParserArray[n].getBinary((byte[])object3, (IPath)object2);
                if (object != null) {
                    return object;
                }
            }
            catch (IOException iOException) {}
            ++n;
        }
        return null;
    }

    public void resetBinaryParser(IProject iProject) {
        ICProject iCProject;
        if (iProject != null && (iCProject = this.create(iProject)) != null) {
            this.releaseCElement(iCProject);
            this.binaryParsersMap.remove(iProject);
            iCProject = this.create(iProject);
            Parent parent = (Parent)iCProject.getParent();
            CElementInfo cElementInfo = parent.getElementInfo();
            cElementInfo.addChild(iCProject);
            CElementDelta cElementDelta = new CElementDelta(this.getCModel());
            cElementDelta.binaryParserChanged(iCProject);
            this.registerCModelDelta(cElementDelta);
            this.fire(1);
        }
    }

    public boolean isSharedLib(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        if (iCElement instanceof IBinary) {
            return ((IBinary)iCElement).isSharedLib();
        }
        return false;
    }

    public boolean isObject(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        if (iCElement instanceof IBinary) {
            return ((IBinary)iCElement).isObject();
        }
        return false;
    }

    public boolean isExecutable(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        if (iCElement instanceof IBinary) {
            return ((IBinary)iCElement).isExecutable();
        }
        return false;
    }

    public boolean isBinary(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        return iCElement instanceof IBinary;
    }

    public boolean isArchive(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        return iCElement instanceof IArchive;
    }

    public boolean isTranslationUnit(IFile iFile) {
        return iFile != null && this.isValidTranslationUnitName(iFile.getName());
    }

    public boolean isSourceUnit(IFile iFile) {
        return iFile != null && this.isValidSourceUnitName(iFile.getName());
    }

    public boolean isHeaderUnit(IFile iFile) {
        return iFile != null && this.isValidHeaderUnitName(iFile.getName());
    }

    public boolean isAssemblyUnit(IFile iFile) {
        return iFile != null && this.isValidAssemblyUnitName(iFile.getName());
    }

    public boolean isValidTranslationUnitName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        String[] stringArray = this.getTranslationUnitExtensions();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValidSourceUnitName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        String[] stringArray = this.getSourceExtensions();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValidHeaderUnitName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        String[] stringArray = this.getHeaderExtensions();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValidAssemblyUnitName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        String[] stringArray = this.getAssemblyExtensions();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] getHeaderExtensions() {
        return headerExtensions;
    }

    public String[] getSourceExtensions() {
        return sourceExtensions;
    }

    public String[] getAssemblyExtensions() {
        return assemblyExtensions;
    }

    public String[] getTranslationUnitExtensions() {
        String[] stringArray = this.getSourceExtensions();
        String[] stringArray2 = this.getHeaderExtensions();
        String[] stringArray3 = this.getAssemblyExtensions();
        String[] stringArray4 = new String[stringArray2.length + stringArray.length + stringArray3.length];
        System.arraycopy(stringArray, 0, stringArray4, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray4, stringArray.length, stringArray2.length);
        System.arraycopy(stringArray3, 0, stringArray4, stringArray.length + stringArray2.length, stringArray3.length);
        return stringArray4;
    }

    public boolean hasCNature(IProject iProject) {
        boolean bl = false;
        try {
            bl = iProject.isOpen() && iProject.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {}
        return bl;
    }

    public boolean hasCCNature(IProject iProject) {
        boolean bl = false;
        try {
            bl = iProject.isOpen() && iProject.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException coreException) {}
        return bl;
    }

    public BinaryRunner getBinaryRunner(ICProject iCProject) {
        BinaryRunner binaryRunner = null;
        HashMap hashMap = this.binaryRunners;
        synchronized (hashMap) {
            binaryRunner = (BinaryRunner)this.binaryRunners.get(iCProject.getProject());
            if (binaryRunner == null) {
                binaryRunner = new BinaryRunner(iCProject.getProject());
                this.binaryRunners.put(iCProject.getProject(), binaryRunner);
                binaryRunner.start();
            }
        }
        return binaryRunner;
    }

    public SourceMapper getSourceMapper(ICProject iCProject) {
        SourceMapper sourceMapper = null;
        HashMap hashMap = this.sourceMappers;
        synchronized (hashMap) {
            sourceMapper = (SourceMapper)this.sourceMappers.get(iCProject);
            if (sourceMapper == null) {
                sourceMapper = new SourceMapper(iCProject);
                this.sourceMappers.put(iCProject, sourceMapper);
            }
        }
        return sourceMapper;
    }

    public synchronized void addElementChangedListener(IElementChangedListener iElementChangedListener) {
        if (this.fElementChangedListeners.indexOf(iElementChangedListener) < 0) {
            this.fElementChangedListeners.add(iElementChangedListener);
        }
    }

    public synchronized void removeElementChangedListener(IElementChangedListener iElementChangedListener) {
        int n = this.fElementChangedListeners.indexOf(iElementChangedListener);
        if (n != -1) {
            this.fElementChangedListeners.remove(n);
        }
    }

    public synchronized void registerCModelDelta(ICElementDelta iCElementDelta) {
        this.fCModelDeltas.add(iCElementDelta);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getSource() instanceof IWorkspace) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            IResource iResource = iResourceChangeEvent.getResource();
            switch (iResourceChangeEvent.getType()) {
                case 4: {
                    try {
                        if (iResource.getType() != 4 || !((IProject)iResource).hasNature("org.eclipse.cdt.core.cnature") && !((IProject)iResource).hasNature("org.eclipse.cdt.core.ccnature")) break;
                        this.deleting((IProject)iResource);
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                case 8: {
                    if (iResourceDelta == null) break;
                    this.checkProjectsBeingAddedOrRemoved(iResourceDelta);
                    break;
                }
                case 1: {
                    try {
                        if (iResourceDelta == null) break;
                        ICElementDelta[] iCElementDeltaArray = this.fDeltaProcessor.processResourceDelta(iResourceDelta);
                        if (iCElementDeltaArray.length > 0) {
                            int n = 0;
                            while (n < iCElementDeltaArray.length) {
                                this.registerCModelDelta(iCElementDeltaArray[n]);
                                ++n;
                            }
                        }
                        this.fire(1);
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void fire(int n) {
        if (!this.fFire) return;
        this.mergeDeltas();
        try {
            Iterator iterator = ((AbstractList)this.fCModelDeltas).iterator();
            while (iterator.hasNext()) {
                ICElementDelta iCElementDelta = (ICElementDelta)iterator.next();
                this.fire(iCElementDelta, n);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.flush();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.flush();
            return;
        }
    }

    public synchronized void fire(ICElementDelta iCElementDelta, int n) {
        ElementChangedEvent elementChangedEvent = new ElementChangedEvent(iCElementDelta, n);
        ArrayList arrayList = (ArrayList)this.fElementChangedListeners.clone();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            IElementChangedListener iElementChangedListener = (IElementChangedListener)arrayList.get(n2);
            iElementChangedListener.elementChanged(elementChangedEvent);
            ++n2;
        }
    }

    protected synchronized void flush() {
        this.fCModelDeltas = new ArrayList();
    }

    private void mergeDeltas() {
        if (this.fCModelDeltas.size() <= 1) {
            return;
        }
        Iterator iterator = ((AbstractList)this.fCModelDeltas).iterator();
        ICModel iCModel = this.getCModel();
        CElementDelta cElementDelta = new CElementDelta(iCModel);
        boolean bl = false;
        while (iterator.hasNext()) {
            CElementDelta cElementDelta2 = (CElementDelta)iterator.next();
            ICElement iCElement = cElementDelta2.getElement();
            if (iCModel.equals(iCElement)) {
                ICElementDelta[] iCElementDeltaArray = cElementDelta2.getAffectedChildren();
                int n = 0;
                while (n < iCElementDeltaArray.length) {
                    CElementDelta cElementDelta3 = (CElementDelta)iCElementDeltaArray[n];
                    cElementDelta.insertDeltaTree(cElementDelta3.getElement(), cElementDelta3);
                    bl = true;
                    ++n;
                }
                continue;
            }
            cElementDelta.insertDeltaTree(iCElement, cElementDelta2);
            bl = true;
        }
        if (bl) {
            this.fCModelDeltas = new ArrayList(1);
            this.fCModelDeltas.add(cElementDelta);
        } else {
            this.fCModelDeltas = new ArrayList(0);
        }
    }

    /*
     * Exception decompiling
     */
    public void runOperation(CModelOperation var1_1, IProgressMonitor var2_2) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 150->154)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void checkProjectsBeingAddedOrRemoved(IResourceDelta iResourceDelta) {
        IResource iResource = iResourceDelta.getResource();
        switch (iResource.getType()) {
            case 8: {
                if (this.cProjectsCache == null) {
                    this.cProjectsCache = this.getCModel().getCProjects();
                }
                IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                int n = 0;
                int n2 = iResourceDeltaArray.length;
                while (n < n2) {
                    this.checkProjectsBeingAddedOrRemoved(iResourceDeltaArray[n]);
                    ++n;
                }
                break;
            }
            case 4: {
                if ((iResourceDelta.getFlags() & 0x4000) != 0) {
                    IProject iProject = (IProject)iResource;
                    if (!iProject.isOpen()) {
                        BinaryRunner binaryRunner = (BinaryRunner)this.binaryRunners.get(iProject);
                        if (binaryRunner == null) break;
                        binaryRunner.stop();
                        break;
                    }
                    if (this.binaryRunners.get(iProject) != null) break;
                    this.binaryRunners.put(iProject, new BinaryRunner(iProject));
                    break;
                }
                if ((iResourceDelta.getFlags() & 2) == 0) break;
                IProject iProject = (IProject)iResource;
                BinaryRunner binaryRunner = (BinaryRunner)this.binaryRunners.remove(iProject);
                if (binaryRunner != null) {
                    binaryRunner.stop();
                }
                this.binaryParsersMap.remove(iProject);
            }
        }
    }

    protected Map getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public Object getInfo(ICElement iCElement) {
        return this.cache.getInfo(iCElement);
    }

    protected Object peekAtInfo(ICElement iCElement) {
        return this.cache.peekAtInfo(iCElement);
    }

    protected void putInfo(ICElement iCElement, Object object) {
        this.cache.putInfo(iCElement, object);
    }

    protected void removeInfo(ICElement iCElement) {
        this.cache.removeInfo(iCElement);
    }

    public void startup() {
    }

    public void shutdown() {
        if (this.fDeltaProcessor.indexManager != null) {
            this.fDeltaProcessor.indexManager.shutdown();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)factory);
        BinaryRunner[] binaryRunnerArray = this.binaryRunners.values().toArray(new BinaryRunner[0]);
        int n = 0;
        while (n < binaryRunnerArray.length) {
            binaryRunnerArray[n].stop();
            ++n;
        }
    }

    public IndexManager getIndexManager() {
        return this.fDeltaProcessor.indexManager;
    }

    public void deleting(IProject iProject) {
        this.getIndexManager().discardJobs(iProject.getName());
    }
}

