/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AddFileToIndex
extends IndexRequest {
    IFile resource;

    public AddFileToIndex(IFile iFile, IPath iPath, IndexManager indexManager) {
        super(iPath, indexManager);
        this.resource = iFile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        IIndex iIndex = this.manager.getIndex(this.indexPath, true, true);
        if (iIndex == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = this.manager.getMonitorFor(iIndex);
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            try {
                readWriteMonitor.enterWrite();
                if (!this.indexDocument(iIndex)) {
                    Object var5_4 = null;
                    readWriteMonitor.exitWrite();
                    return false;
                }
            }
            catch (IOException iOException) {
                Util.log(null, "Index I/O Exception: " + iOException.getMessage() + " on File: " + this.resource.getName(), ICLogConstants.CDT);
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.resource + " because of the following exception:");
                    iOException.printStackTrace();
                }
                Object var5_5 = null;
                readWriteMonitor.exitWrite();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            readWriteMonitor.exitWrite();
            throw throwable;
        }
        {
            Object var5_7 = null;
            readWriteMonitor.exitWrite();
            return true;
        }
    }

    protected abstract boolean indexDocument(IIndex var1) throws IOException;

    public String toString() {
        return "indexing " + this.resource.getFullPath();
    }
}

