/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.IFileDocument;
import org.eclipse.cdt.internal.core.search.SimpleLookupTable;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexAllProject
extends IndexRequest {
    IProject project;

    public IndexAllProject(IProject iProject, IndexManager indexManager) {
        super(iProject.getFullPath(), indexManager);
        this.project = iProject;
    }

    public boolean equals(Object object) {
        if (object instanceof IndexAllProject) {
            return this.project.equals((Object)((IndexAllProject)object).project);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        ReadWriteMonitor readWriteMonitor;
        block25: {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                return true;
            }
            if (!this.project.isAccessible()) {
                return true;
            }
            IIndex iIndex = this.manager.getIndex(this.indexPath, true, true);
            if (iIndex == null) {
                return true;
            }
            readWriteMonitor = this.manager.getMonitorFor(iIndex);
            if (readWriteMonitor == null) {
                return true;
            }
            try {
                try {
                    Object object;
                    readWriteMonitor.enterRead();
                    this.saveIfNecessary(iIndex, readWriteMonitor);
                    IQueryResult[] iQueryResultArray = iIndex.queryInDocumentNames("");
                    int n = iQueryResultArray == null ? 0 : iQueryResultArray.length;
                    final SimpleLookupTable simpleLookupTable = new SimpleLookupTable(n == 0 ? 33 : n + 11);
                    int n2 = 0;
                    while (true) {
                        block27: {
                            if (n2 < n) break block27;
                        }
                        simpleLookupTable.put(iQueryResultArray[n2].getPath(), "DELETED");
                        ++n2;
                    }
                    final long l = n == 0 ? 0L : iIndex.getIndexFile().lastModified();
                    IPath iPath = this.project.getFullPath();
                    IWorkspaceRoot iWorkspaceRoot = this.project.getWorkspace().getRoot();
                    IResource iResource = iWorkspaceRoot.findMember(iPath);
                    if (this.isCancelled) {
                        Object var19_14 = null;
                        readWriteMonitor.exitRead();
                        return false;
                    }
                    if (iResource != null) {
                        object = new HashSet();
                        final boolean bl = !((HashSet)object).isEmpty();
                        final char[][] cArray = null;
                        if (n == 0) {
                            iResource.accept(new IResourceProxyVisitor((HashSet)object){
                                private final /* synthetic */ HashSet val$outputs;
                                {
                                    this.val$outputs = hashSet;
                                }

                                public boolean visit(IResourceProxy iResourceProxy) {
                                    if (IndexAllProject.this.isCancelled) {
                                        return false;
                                    }
                                    switch (iResourceProxy.getType()) {
                                        case 1: {
                                            IResource iResource;
                                            if (Util.isCCFileName(iResourceProxy.getName()) && (iResource = iResourceProxy.requestResource()).getLocation() != null && (cArray == null || !Util.isExcluded(iResource, cArray))) {
                                                String string = new IFileDocument((IFile)iResource).getName();
                                                simpleLookupTable.put(string, iResource);
                                            }
                                            return false;
                                        }
                                        case 2: {
                                            if (cArray != null && Util.isExcluded(iResourceProxy.requestResource(), cArray)) {
                                                return false;
                                            }
                                            if (!bl || !this.val$outputs.contains(iResourceProxy.requestFullPath())) break;
                                            return false;
                                        }
                                    }
                                    return true;
                                }
                            }, 0);
                        } else {
                            iResource.accept(new IResourceProxyVisitor((HashSet)object){
                                private final /* synthetic */ HashSet val$outputs;
                                {
                                    this.val$outputs = hashSet;
                                }

                                public boolean visit(IResourceProxy iResourceProxy) {
                                    if (IndexAllProject.this.isCancelled) {
                                        return false;
                                    }
                                    switch (iResourceProxy.getType()) {
                                        case 1: {
                                            IResource iResource;
                                            IPath iPath;
                                            if (Util.isCCFileName(iResourceProxy.getName()) && (iPath = (iResource = iResourceProxy.requestResource()).getLocation()) != null && (cArray == null || !Util.isExcluded(iResource, cArray))) {
                                                String string;
                                                simpleLookupTable.put(string, simpleLookupTable.get(string = new IFileDocument((IFile)iResource).getName()) == null || l < iPath.toFile().lastModified() ? iResource : "OK");
                                            }
                                            return false;
                                        }
                                        case 2: {
                                            if (cArray != null && Util.isExcluded(iResourceProxy.requestResource(), cArray)) {
                                                return false;
                                            }
                                            if (!bl || !this.val$outputs.contains(iResourceProxy.requestFullPath())) break;
                                            return false;
                                        }
                                    }
                                    return true;
                                }
                            }, 0);
                        }
                    }
                    object = simpleLookupTable.keyTable;
                    Object[] objectArray = simpleLookupTable.valueTable;
                    boolean bl = false;
                    int n3 = 0;
                    int n4 = ((Object)object).length;
                    while (true) {
                        if (n3 >= n4) {
                            if (bl) {
                                this.manager.request(new SaveIndex(this.indexPath, this.manager));
                            }
                            break block25;
                        }
                        String string = (String)object[n3];
                        if (string != null) {
                            if (this.isCancelled) {
                                break;
                            }
                            Object object2 = objectArray[n3];
                            if (object2 != "OK") {
                                bl = true;
                                if (object2 == "DELETED") {
                                    this.manager.remove(string, this.indexPath);
                                } else {
                                    this.manager.addSource((IFile)object2, this.indexPath);
                                }
                            }
                        }
                        ++n3;
                    }
                }
                catch (CoreException coreException) {
                    if (IndexManager.VERBOSE) {
                        JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                        coreException.printStackTrace();
                    }
                    this.manager.removeIndex(this.indexPath);
                    Object var19_16 = null;
                    readWriteMonitor.exitRead();
                    return false;
                }
                catch (IOException iOException) {
                    if (IndexManager.VERBOSE) {
                        JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                        iOException.printStackTrace();
                    }
                    this.manager.removeIndex(this.indexPath);
                    Object var19_17 = null;
                    readWriteMonitor.exitRead();
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                readWriteMonitor.exitRead();
                throw throwable;
            }
            Object var19_15 = null;
            readWriteMonitor.exitRead();
            return false;
        }
        Object var19_19 = null;
        readWriteMonitor.exitRead();
        return true;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }
}

