/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.corext.textmanipulation.MoveTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.NopTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.cdt.internal.corext.textmanipulation.UndoMemento;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.Assert;

abstract class TextEditNode {
    TextEditNode fParent;
    List fChildren;
    TextEdit fEdit;

    static TextEditNode create(TextEdit textEdit) {
        if (textEdit instanceof MoveTextEdit) {
            return new MoveNode(textEdit);
        }
        if (textEdit instanceof MoveTextEdit.TargetMark) {
            return new TargetMarkNode(textEdit);
        }
        return new DefaultNode(textEdit);
    }

    static RootNode createRoot(int n) {
        return new RootNode(n);
    }

    protected TextEditNode(TextEdit textEdit) {
        this.fEdit = textEdit;
    }

    protected void add(TextEditNode textEditNode) {
        TextEditNode textEditNode2;
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(1);
            textEditNode.fParent = this;
            this.fChildren.add(textEditNode);
            return;
        }
        Iterator iterator = this.fChildren.iterator();
        while (iterator.hasNext()) {
            textEditNode2 = (TextEditNode)iterator.next();
            if (!textEditNode2.covers(textEditNode)) continue;
            textEditNode2.add(textEditNode);
            return;
        }
        int n = 0;
        while (n < this.fChildren.size()) {
            textEditNode2 = (TextEditNode)this.fChildren.get(n);
            if (textEditNode.covers(textEditNode2)) {
                this.fChildren.remove(n);
                textEditNode.add(textEditNode2);
                continue;
            }
            ++n;
        }
        textEditNode.fParent = this;
        this.fChildren.add(textEditNode);
    }

    public boolean covers(TextEditNode textEditNode) {
        return false;
    }

    protected RootNode getRoot() {
        TextEditNode textEditNode = this;
        while (textEditNode.fParent != null) {
            textEditNode = textEditNode.fParent;
        }
        return (RootNode)textEditNode;
    }

    protected boolean isSynthetic() {
        return this.fEdit.isSynthetic;
    }

    public boolean isMove() {
        return false;
    }

    protected void checkRange(DocumentEvent documentEvent) {
        TextRange textRange = this.getTextRange();
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getLength();
        int n3 = n + n2 - 1;
        Assert.isTrue((textRange.fOffset <= n && n3 <= textRange.getInclusiveEnd() ? 1 : 0) != 0);
    }

    protected TextRange getTextRange() {
        return this.fEdit.getTextRange();
    }

    protected TextRange getChildRange() {
        return this.getTextRange();
    }

    protected TextRange getParentRange() {
        return this.getTextRange();
    }

    public boolean validate(int n) {
        if (this.fChildren == null) {
            return true;
        }
        if (!(this.fEdit instanceof MoveTextEdit) && !(this.fEdit instanceof NopTextEdit)) {
            return false;
        }
        TextRange textRange = null;
        Iterator iterator = this.fChildren.iterator();
        while (iterator.hasNext()) {
            TextEditNode textEditNode = (TextEditNode)iterator.next();
            if (!textEditNode.validate(n)) {
                return false;
            }
            TextRange textRange2 = textEditNode.fEdit.getTextRange();
            if (!textRange2.isValid() || textRange2.fOffset + textRange2.fLength > n) {
                return false;
            }
            if (textRange != null && !textRange2.isInsertionPointAt(textRange.fOffset) && !textRange2.liesBehind(textRange)) {
                return false;
            }
            textRange = textRange2;
        }
        return true;
    }

    protected boolean activeNodeChanged(int n) {
        TextRange textRange = this.getTextRange();
        textRange.fLength += n;
        return false;
    }

    protected void previousNodeChanged(int n) {
        TextRange textRange = this.getTextRange();
        textRange.fOffset += n;
    }

    protected void childNodeChanged(int n) {
        this.getTextRange().fLength += n;
    }

    protected void performDo(TextBuffer textBuffer, RangeUpdater rangeUpdater, UndoMemento undoMemento, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = this.fChildren != null ? this.fChildren.size() : 0;
        int n2 = n - 1;
        while (n2 >= 0) {
            TextEditNode textEditNode = (TextEditNode)this.fChildren.get(n2);
            textEditNode.performDo(textBuffer, rangeUpdater, undoMemento, iProgressMonitor);
            --n2;
        }
        rangeUpdater.setActiveNode(this);
        if (this.isSynthetic()) {
            this.fEdit.perform(textBuffer);
        } else {
            undoMemento.add(this.fEdit.perform(textBuffer));
        }
        iProgressMonitor.worked(1);
    }

    public void performedDo() {
        int n = this.fChildren != null ? this.fChildren.size() : 0;
        int n2 = n - 1;
        while (n2 >= 0) {
            TextEditNode textEditNode = (TextEditNode)this.fChildren.get(n2);
            textEditNode.performedDo();
            --n2;
        }
        this.fEdit.performed();
    }

    protected void performUndo(TextBuffer textBuffer, RangeUpdater rangeUpdater, UndoMemento undoMemento, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = this.fChildren != null ? this.fChildren.size() : 0;
        int n2 = 0;
        while (n2 < n) {
            this.setUndoIndex(n2);
            TextEditNode textEditNode = (TextEditNode)this.fChildren.get(n2);
            textEditNode.performUndo(textBuffer, rangeUpdater, undoMemento, iProgressMonitor);
            ++n2;
        }
        rangeUpdater.setActiveNode(this);
        if (this.isSynthetic()) {
            this.fEdit.perform(textBuffer);
        } else {
            undoMemento.add(this.fEdit.perform(textBuffer));
        }
        iProgressMonitor.worked(1);
    }

    protected void setUndoIndex(int n) {
    }

    public void performedUndo() {
        int n = this.fChildren != null ? this.fChildren.size() : 0;
        int n2 = 0;
        while (n2 < n) {
            TextEditNode textEditNode = (TextEditNode)this.fChildren.get(n2);
            textEditNode.performedUndo();
            ++n2;
        }
        this.fEdit.performed();
    }

    static class DefaultNode
    extends TextEditNode {
        public DefaultNode(TextEdit textEdit) {
            super(textEdit);
        }
    }

    static class RootNode
    extends TextEditNode {
        private int fUndoIndex;

        public RootNode(int n) {
            super(new NopTextEdit(new TextRange(0, n)));
            this.fEdit.isSynthetic = true;
        }

        public boolean covers(TextEditNode textEditNode) {
            return true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public UndoMemento performDo(TextBuffer textBuffer, IProgressMonitor iProgressMonitor) throws CoreException {
            DoRangeUpdater doRangeUpdater = new DoRangeUpdater();
            UndoMemento undoMemento = new UndoMemento(2);
            try {
                textBuffer.registerUpdater(doRangeUpdater);
                this.performDo(textBuffer, doRangeUpdater, undoMemento, iProgressMonitor);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                textBuffer.unregisterUpdater(doRangeUpdater);
                doRangeUpdater.setActiveNode(null);
                throw throwable;
            }
            {
                Object var5_7 = null;
                textBuffer.unregisterUpdater(doRangeUpdater);
                doRangeUpdater.setActiveNode(null);
                return undoMemento;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public UndoMemento performUndo(TextBuffer textBuffer, IProgressMonitor iProgressMonitor) throws CoreException {
            UndoRangeUpdater undoRangeUpdater = new UndoRangeUpdater(this);
            UndoMemento undoMemento = new UndoMemento(1);
            try {
                textBuffer.registerUpdater(undoRangeUpdater);
                this.performUndo(textBuffer, undoRangeUpdater, undoMemento, iProgressMonitor);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                textBuffer.unregisterUpdater(undoRangeUpdater);
                undoRangeUpdater.setActiveNode(null);
                throw throwable;
            }
            {
                Object var5_7 = null;
                textBuffer.unregisterUpdater(undoRangeUpdater);
                undoRangeUpdater.setActiveNode(null);
                return undoMemento;
            }
        }

        protected void setUndoIndex(int n) {
            this.fUndoIndex = n;
        }

        protected int getUndoIndex() {
            return this.fUndoIndex;
        }
    }

    static abstract class AbstractMoveNode
    extends TextEditNode {
        private int state;
        private int fTargetIndex;
        private int fSourceIndex;
        private List fAffectedChildren;

        public AbstractMoveNode(TextEdit textEdit) {
            super(textEdit);
            this.reset();
        }

        protected abstract TextRange getSourceRange();

        protected abstract TextRange getTargetRange();

        protected abstract boolean isUpMove();

        protected boolean isDownMove() {
            return !this.isUpMove();
        }

        public boolean isMove() {
            return true;
        }

        protected void checkRange(DocumentEvent documentEvent) {
            TextRange textRange = this.getChildRange();
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = n + n2 - 1;
            Assert.isTrue((textRange.fOffset <= n && n3 <= textRange.getInclusiveEnd() ? 1 : 0) != 0);
        }

        protected boolean activeNodeChanged(int n) {
            TextRange textRange = this.getTargetRange();
            TextRange textRange2 = this.getSourceRange();
            switch (this.state) {
                case 0: {
                    this.init();
                    Assert.isTrue((Math.abs(n) == textRange2.fLength ? 1 : 0) != 0);
                    if (this.isUpMove()) {
                        AbstractMoveNode.updateOffset(this.fAffectedChildren, n);
                        textRange.fOffset += n;
                    }
                    textRange2.fLength = 0;
                    this.state = 1;
                    break;
                }
                case 1: {
                    TextEditNode textEditNode = (TextEditNode)this.fParent.fChildren.get(this.fTargetIndex);
                    TextEditNode textEditNode2 = (TextEditNode)this.fParent.fChildren.get(this.fSourceIndex);
                    AbstractMoveNode.updateOffset(textEditNode2.fChildren, textRange.fOffset - textRange2.fOffset);
                    textEditNode.fChildren = textEditNode2.fChildren;
                    if (textEditNode.fChildren != null) {
                        Iterator iterator = textEditNode.fChildren.iterator();
                        while (iterator.hasNext()) {
                            ((TextEditNode)iterator.next()).fParent = textEditNode;
                        }
                    }
                    textEditNode2.fChildren = null;
                    if (this.isDownMove()) {
                        AbstractMoveNode.updateOffset(this.fAffectedChildren, n);
                        textRange2.fOffset += n;
                    }
                    textRange.fLength = n;
                    this.reset();
                }
            }
            return true;
        }

        private static void updateOffset(List list, int n) {
            if (list == null) {
                return;
            }
            int n2 = list.size() - 1;
            while (n2 >= 0) {
                TextEditNode textEditNode = (TextEditNode)list.get(n2);
                TextRange textRange = textEditNode.getTextRange();
                textRange.fOffset += n;
                AbstractMoveNode.updateOffset(textEditNode.fChildren, n);
                --n2;
            }
        }

        private void init() {
            TextRange textRange = this.getSourceRange();
            TextRange textRange2 = this.getTargetRange();
            List list = this.fParent.fChildren;
            int n = list.size() - 1;
            while (n >= 0) {
                TextEditNode textEditNode = (TextEditNode)list.get(n);
                TextRange textRange3 = textEditNode.fEdit.getTextRange();
                if (textRange3 == textRange) {
                    this.fSourceIndex = n;
                } else if (textRange3 == textRange2) {
                    this.fTargetIndex = n;
                }
                --n;
            }
            n = Math.min(this.fTargetIndex, this.fSourceIndex);
            int n2 = Math.max(this.fTargetIndex, this.fSourceIndex);
            this.fAffectedChildren = new ArrayList(3);
            int n3 = n + 1;
            while (n3 < n2) {
                this.fAffectedChildren.add(list.get(n3));
                ++n3;
            }
        }

        private void reset() {
            this.state = 0;
            this.fSourceIndex = -1;
            this.fTargetIndex = -1;
        }
    }

    static class MoveNode
    extends AbstractMoveNode {
        public MoveNode(TextEdit textEdit) {
            super(textEdit);
        }

        protected TextRange getChildRange() {
            return ((MoveTextEdit)this.fEdit).getChildRange();
        }

        protected TextRange getSourceRange() {
            return ((MoveTextEdit)this.fEdit).getSourceRange();
        }

        protected TextRange getTargetRange() {
            return ((MoveTextEdit)this.fEdit).getTargetRange();
        }

        protected boolean isUpMove() {
            return ((MoveTextEdit)this.fEdit).isUpMove();
        }

        public boolean isMovePartner(TextEditNode textEditNode) {
            if (!(textEditNode instanceof TargetMarkNode)) {
                return false;
            }
            return this.fEdit == ((MoveTextEdit.TargetMark)textEditNode.fEdit).getMoveTextEdit();
        }

        public boolean covers(TextEditNode textEditNode) {
            MoveTextEdit.TargetMark targetMark;
            if (textEditNode instanceof TargetMarkNode && (targetMark = (MoveTextEdit.TargetMark)textEditNode.fEdit).getMoveTextEdit() == this.fEdit) {
                return false;
            }
            return this.getParentRange().covers(textEditNode.getChildRange());
        }
    }

    static class TargetMarkNode
    extends AbstractMoveNode {
        public TargetMarkNode(TextEdit textEdit) {
            super(textEdit);
        }

        protected TextRange getChildRange() {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit().getChildRange();
        }

        protected TextRange getSourceRange() {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit().getSourceRange();
        }

        protected TextRange getTargetRange() {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit().getTargetRange();
        }

        protected boolean isUpMove() {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit().isUpMove();
        }

        public boolean isMovePartner(TextEditNode textEditNode) {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit() == textEditNode.fEdit;
        }
    }

    private static abstract class RangeUpdater
    implements IDocumentListener {
        protected TextEditNode fActiveNode;

        RangeUpdater() {
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void setActiveNode(TextEditNode textEditNode) {
            this.fActiveNode = textEditNode;
        }

        public void updateParents(int n) {
            TextEditNode textEditNode = this.fActiveNode.fParent;
            while (textEditNode != null) {
                textEditNode.childNodeChanged(n);
                textEditNode = textEditNode.fParent;
            }
        }

        public static int getDelta(DocumentEvent documentEvent) {
            return (documentEvent.getText() == null ? 0 : documentEvent.getText().length()) - documentEvent.getLength();
        }

        public abstract void documentChanged(DocumentEvent var1);
    }

    private static class DoRangeUpdater
    extends RangeUpdater {
        private List fProcessedNodes = new ArrayList(10);

        DoRangeUpdater() {
        }

        public void setActiveNode(TextEditNode textEditNode) {
            if (this.fActiveNode != null) {
                this.fProcessedNodes.add(this.fActiveNode);
            }
            super.setActiveNode(textEditNode);
        }

        public void documentChanged(DocumentEvent documentEvent) {
            this.fActiveNode.checkRange(documentEvent);
            int n = RangeUpdater.getDelta(documentEvent);
            if (!this.fActiveNode.activeNodeChanged(n)) {
                Iterator iterator = this.fProcessedNodes.iterator();
                while (iterator.hasNext()) {
                    ((TextEditNode)iterator.next()).previousNodeChanged(n);
                }
            }
            this.updateParents(n);
        }
    }

    private static class UndoRangeUpdater
    extends RangeUpdater {
        private RootNode fRootNode;

        public UndoRangeUpdater(RootNode rootNode) {
            this.fRootNode = rootNode;
        }

        public void setActiveNode(TextEditNode textEditNode) {
            super.setActiveNode(textEditNode);
        }

        public void documentChanged(DocumentEvent documentEvent) {
            this.fActiveNode.checkRange(documentEvent);
            int n = RangeUpdater.getDelta(documentEvent);
            if (!this.fActiveNode.activeNodeChanged(n)) {
                int n2 = this.fRootNode.getUndoIndex() + 1;
                List list = this.fRootNode.fChildren;
                int n3 = list != null ? list.size() : 0;
                int n4 = n2;
                while (n4 < n3) {
                    this.updateUndo((TextEditNode)list.get(n4), n);
                    ++n4;
                }
            }
            this.updateParents(n);
        }

        private void updateUndo(TextEditNode textEditNode, int n) {
            textEditNode.previousNodeChanged(n);
            List list = textEditNode.fChildren;
            int n2 = list != null ? list.size() : 0;
            int n3 = 0;
            while (n3 < n2) {
                this.updateUndo((TextEditNode)list.get(n3), n);
                ++n3;
            }
        }
    }
}

