/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.ConsoleEvent;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class BuildConsoleManager
implements IBuildConsoleManager,
IResourceChangeListener,
IPropertyChangeListener {
    private HashMap fConsoleDocumentMap;
    ListenerList listeners = new ListenerList(1);

    public BuildConsoleManager() {
        this.fConsoleDocumentMap = new HashMap();
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (this.fConsoleDocumentMap == null) {
            return;
        }
        IResource iResource = iResourceChangeEvent.getResource();
        if (iResource != null && iResource.getType() == 4 && (iResourceChangeEvent.getType() == 4 || iResourceChangeEvent.getType() == 2)) {
            this.fConsoleDocumentMap.remove(iResource);
            Object[] objectArray = this.listeners.getListeners();
            if (objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    IBuildConsoleListener iBuildConsoleListener = (IBuildConsoleListener)objectArray[n];
                    ConsoleEvent consoleEvent = new ConsoleEvent(this, (IProject)iResource, 2);
                    iBuildConsoleListener.consoleChange(consoleEvent);
                    ++n;
                }
            }
        }
    }

    public void shutdown() {
        CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void startup() {
        CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private BuildConsole getBuildConsole(IProject iProject) {
        BuildConsole buildConsole = (BuildConsole)((Object)this.fConsoleDocumentMap.get(iProject));
        if (buildConsole == null) {
            buildConsole = new BuildConsole();
            this.fConsoleDocumentMap.put(iProject, buildConsole);
        }
        return buildConsole;
    }

    public IConsole getConsole(IProject iProject) {
        return this.getBuildConsole(iProject);
    }

    public IDocument getConsoleDocument(IProject iProject) {
        return this.getBuildConsole(iProject).getDocument();
    }

    public void addConsoleListener(IBuildConsoleListener iBuildConsoleListener) {
        this.listeners.add((Object)iBuildConsoleListener);
    }

    public void removeConsoleListener(IBuildConsoleListener iBuildConsoleListener) {
        this.listeners.remove((Object)iBuildConsoleListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty() == "buildConsoleLines") {
            Collection collection = this.fConsoleDocumentMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BuildConsole buildConsole = (BuildConsole)((Object)iterator.next());
                buildConsole.setConsoleSize(BuildConsolePreferencePage.buildConsoleLines());
            }
        }
    }

    private class BuildConsoleDocument
    extends Document {
        private int fMaxLines;

        public BuildConsoleDocument(int n) {
            this.fMaxLines = n;
        }

        public void setDocumentSize(int n) {
            this.fMaxLines = n;
            n = this.getNumberOfLines();
            if (n > this.fMaxLines) {
                try {
                    int n2 = this.getLineOffset(n - this.fMaxLines);
                    String string = this.get(n2, this.getLength() - n2);
                    this.set(string);
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public BuildConsoleDocument(String string) {
            super(string);
        }

        public void replace(int n, int n2, String string) throws BadLocationException {
            super.replace(n, n2, string);
            int n3 = this.getNumberOfLines();
            if (n3 > this.fMaxLines) {
                int n4 = this.getLineOffset(n3 - this.fMaxLines);
                String string2 = this.get(n4, this.getLength() - n4);
                this.set(string2);
            }
        }
    }

    private class BuildConsole
    extends ConsoleOutputStream
    implements IConsole {
        protected BuildConsoleDocument fDocument;

        public BuildConsole() {
            this.fDocument = new BuildConsoleDocument(BuildConsolePreferencePage.buildConsoleLines());
        }

        public void setConsoleSize(int n) {
            this.fDocument.setDocumentSize(n);
        }

        public void start(IProject iProject) {
            Object[] objectArray;
            if (BuildConsolePreferencePage.isClearBuildConsole()) {
                this.clear();
            }
            if ((objectArray = BuildConsoleManager.this.listeners.getListeners()).length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    IBuildConsoleListener iBuildConsoleListener = (IBuildConsoleListener)objectArray[n];
                    ConsoleEvent consoleEvent = new ConsoleEvent(BuildConsoleManager.this, iProject, 1);
                    iBuildConsoleListener.consoleChange(consoleEvent);
                    ++n;
                }
            }
        }

        public void clear() {
            super.clear();
            Display.getDefault().syncExec(new Runnable(this){
                final /* synthetic */ BuildConsole this$1;
                {
                    this.this$1 = buildConsole;
                }

                public void run() {
                    this.this$1.fDocument.set("");
                }
            });
        }

        public ConsoleOutputStream getOutputStream() {
            return this;
        }

        public IDocument getDocument() {
            return this.fDocument;
        }

        public void flush() throws IOException {
            Display.getDefault().syncExec(new Runnable(this){
                final /* synthetic */ BuildConsole this$1;
                {
                    this.this$1 = buildConsole;
                }

                public void run() {
                    this.this$1.bringConsoleOnTop();
                    try {
                        int n = this.this$1.fDocument.getLength();
                        this.this$1.fDocument.replace(n, 0, this.this$1.readBuffer());
                    }
                    catch (BadLocationException badLocationException) {}
                }
            });
        }

        void bringConsoleOnTop() {
            IWorkbenchWindow iWorkbenchWindow = CUIPlugin.getDefault().getActiveWorkbenchWindow();
            if (iWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null) {
                try {
                    IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.cdt.ui.BuildConsoleView");
                    if (iViewPart == null && BuildConsolePreferencePage.isAutoOpenConsole()) {
                        IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
                        iViewPart = iWorkbenchPage.showView("org.eclipse.cdt.ui.BuildConsoleView");
                        iWorkbenchPage.activate(iWorkbenchPart);
                    }
                    if (iViewPart != null && BuildConsolePreferencePage.isConsoleOnTop()) {
                        iWorkbenchPage.bringToTop((IWorkbenchPart)iViewPart);
                    }
                }
                catch (PartInitException partInitException) {}
            }
        }

        public void close() throws IOException {
            this.flush();
        }
    }
}

