/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.text.HTMLPrinter;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class DefaultCEditorTextHover
implements ITextHover {
    protected IEditorPart fEditor;

    public DefaultCEditorTextHover(IEditorPart iEditorPart) {
        this.fEditor = iEditorPart;
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        String string = null;
        if (this.fEditor == null) {
            return null;
        }
        try {
            string = iTextViewer.getDocument().get(iRegion.getOffset(), iRegion.getLength());
            string = string.trim();
            if (string.length() == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            IFunctionSummary iFunctionSummary = CCompletionContributorManager.getDefault().getFunctionInfo(string);
            if (iFunctionSummary != null) {
                stringBuffer.append(CEditorMessages.getString("DefaultCEditorTextHover.html.name"));
                stringBuffer.append(HTMLPrinter.convertToHTMLContent(iFunctionSummary.getName()));
                stringBuffer.append(CEditorMessages.getString("DefaultCEditorTextHover.html.prototype"));
                stringBuffer.append(HTMLPrinter.convertToHTMLContent(iFunctionSummary.getPrototype().getPrototypeString(false)));
                if (iFunctionSummary.getDescription() != null) {
                    stringBuffer.append(CEditorMessages.getString("DefaultCEditorTextHover.html.description"));
                    stringBuffer.append(iFunctionSummary.getDescription());
                }
            }
            if (stringBuffer.length() > 0) {
                HTMLPrinter.insertPageProlog(stringBuffer, 0);
                HTMLPrinter.addPageEpilog(stringBuffer);
                return stringBuffer.toString();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        Point point = iTextViewer.getSelectedRange();
        if (point.x >= 0 && point.y > 0 && n >= point.x && n <= point.x + point.y) {
            return new Region(point.x, point.y);
        }
        if (iTextViewer != null) {
            return CWordFinder.findWord(iTextViewer.getDocument(), n);
        }
        return null;
    }
}

