/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.opentype;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.opentype.TypeSearchMatch;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TypeSearchMatchLabelProvider
extends LabelProvider {
    public static final int SHOW_FULLYQUALIFIED = 1;
    public static final int SHOW_FILENAME_POSTFIX = 2;
    public static final int SHOW_FILENAME_ONLY = 4;
    public static final int SHOW_ROOT_POSTFIX = 8;
    public static final int SHOW_TYPE_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    private static final Image HEADER_ICON = CPluginImages.get("org.eclipse.cdt.ui.h_file_obj.gif");
    private static final Image SOURCE_ICON = CPluginImages.get("org.eclipse.cdt.ui.c_file_obj.gif");
    private static final Image NAMESPACE_ICON = CPluginImages.get("org.eclipse.cdt.ui.container_obj.gif");
    private static final Image TEMPLATE_ICON = CPluginImages.get("org.eclipse.cdt.ui.template_obj.gif");
    private static final Image CLASS_ICON = CPluginImages.get("org.eclipse.cdt.ui.class_obj.gif");
    private static final Image STRUCT_ICON = CPluginImages.get("org.eclipse.cdt.ui.struct_obj.gif");
    private static final Image TYPEDEF_ICON = CPluginImages.get("org.eclipse.cdt.ui.typedef_obj.gif");
    private static final Image UNION_ICON = CPluginImages.get("org.eclipse.cdt.ui.union_obj.gif");
    private static final Image ENUM_ICON = CPluginImages.get("org.eclipse.cdt.ui.enum_obj.gif");
    private int fFlags;

    public TypeSearchMatchLabelProvider(int n) {
        this.fFlags = n;
    }

    private boolean isSet(int n) {
        return (this.fFlags & n) != 0;
    }

    public String getText(Object object) {
        String string;
        if (!(object instanceof TypeSearchMatch)) {
            return super.getText(object);
        }
        TypeSearchMatch typeSearchMatch = (TypeSearchMatch)((Object)object);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSet(16)) {
            string = typeSearchMatch.getName();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
        } else if (this.isSet(32)) {
            string = typeSearchMatch.getQualifiedParentName();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
        } else if (this.isSet(4)) {
            string = typeSearchMatch.getFileName();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
        } else {
            if (this.isSet(1)) {
                string = typeSearchMatch.getFullyQualifiedName();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(string);
                }
            } else {
                string = typeSearchMatch.getParentName();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(string);
                }
            }
            if (this.isSet(2) && (string = typeSearchMatch.getFileName()) != null && string.length() > 0) {
                stringBuffer.append(OpenTypeMessages.getString("TypeInfoLabelProvider.dash"));
                stringBuffer.append(string);
            }
        }
        if (this.isSet(8) && (string = typeSearchMatch.getFilePath()) != null && string.length() > 0) {
            stringBuffer.append(OpenTypeMessages.getString("TypeInfoLabelProvider.dash"));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private Image getFileIcon(TypeSearchMatch typeSearchMatch) {
        String string = typeSearchMatch.getFileExtension();
        if (string != null) {
            String[] stringArray = CoreModel.getDefault().getHeaderExtensions();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return HEADER_ICON;
                }
                ++n;
            }
        }
        return SOURCE_ICON;
    }

    private Image getIcon(TypeSearchMatch typeSearchMatch) {
        switch (typeSearchMatch.getType()) {
            case 61: {
                return NAMESPACE_ICON;
            }
            case 73: {
                return TEMPLATE_ICON;
            }
            case 64: {
                return CLASS_ICON;
            }
            case 65: {
                return STRUCT_ICON;
            }
            case 66: {
                return UNION_ICON;
            }
            case 63: {
                return ENUM_ICON;
            }
            case 78: {
                return TYPEDEF_ICON;
            }
        }
        return CLASS_ICON;
    }

    public Image getImage(Object object) {
        if (!(object instanceof TypeSearchMatch)) {
            return super.getImage(object);
        }
        TypeSearchMatch typeSearchMatch = (TypeSearchMatch)((Object)object);
        if (this.isSet(32)) {
            return this.getFileIcon(typeSearchMatch);
        }
        if (this.isSet(4)) {
            return this.getFileIcon(typeSearchMatch);
        }
        return this.getIcon(typeSearchMatch);
    }
}

