/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.io.CharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.parser.util.ASTUtil;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistElementRequestor;
import org.eclipse.cdt.internal.ui.text.contentassist.ICompletionRequestor;
import org.eclipse.cdt.internal.ui.text.contentassist.RelevanceConstants;
import org.eclipse.cdt.internal.ui.util.IDebugLogConstants;
import org.eclipse.cdt.internal.ui.util.Util;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;

public class CompletionEngine
implements RelevanceConstants {
    ICompletionRequestor requestor;
    int completionStart = 0;
    int completionLength = 0;
    IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
    private Map macroMap = new HashMap();
    private static final String exceptionKeyword = "...";
    private int numFields = 0;
    private int numVariables = 0;
    private int numLocalVariables = 0;
    private int numMethods = 0;
    private int numFunctions = 0;
    private int numClasses = 0;
    private int numStructs = 0;
    private int numUnions = 0;
    private int numEnumerations = 0;
    private int numEnumerators = 0;
    private int numNamespaces = 0;

    public CompletionEngine(ICompletionRequestor iCompletionRequestor) {
        this.requestor = iCompletionRequestor;
    }

    private int computeCaseMatchingRelevance(String string, String string2) {
        if (CharOperation.prefixEquals((char[])string.toCharArray(), (char[])string2.toCharArray(), (boolean)true)) {
            if (CharOperation.equals((char[])string.toCharArray(), (char[])string2.toCharArray(), (boolean)true)) {
                return 190;
            }
            return 150;
        }
        return 0;
    }

    private int computeTypeRelevance(int n) {
        switch (n) {
            case 76: {
                return 130;
            }
            case 69: {
                return 120;
            }
            case 74: 
            case 75: {
                return 110;
            }
            case 67: 
            case 68: {
                return 100;
            }
            case 70: 
            case 71: {
                return 90;
            }
            case 64: {
                return 80;
            }
            case 65: {
                return 70;
            }
            case 66: {
                return 60;
            }
            case 61: {
                return 50;
            }
            case 77: {
                return 40;
            }
            case 63: {
                return 30;
            }
            case 79: {
                return 20;
            }
        }
        return 0;
    }

    public int computeRelevance(int n, String string, String string2) {
        int n2 = this.computeTypeRelevance(n);
        return n2 += this.computeCaseMatchingRelevance(string, string2);
    }

    private IASTCompletionNode parse(IWorkingCopy iWorkingCopy, int n) {
        IScannerInfo iScannerInfo;
        ContentAssistElementRequestor contentAssistElementRequestor = new ContentAssistElementRequestor();
        IResource iResource = iWorkingCopy.getResource();
        IPath iPath = iResource.getLocation();
        IProject iProject = iResource.getProject();
        CharArrayReader charArrayReader = new CharArrayReader(iWorkingCopy.getContents());
        ScannerInfo scannerInfo = new ScannerInfo();
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        if (iScannerInfoProvider != null && (iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject)) != null) {
            scannerInfo = new ScannerInfo(iScannerInfo.getDefinedSymbols(), iScannerInfo.getIncludePaths());
        }
        iScannerInfo = CoreModel.getDefault().hasCCNature(iProject) ? ParserLanguage.CPP : ParserLanguage.C;
        IParser iParser = null;
        IScanner iScanner = null;
        this.macroMap.clear();
        try {
            iScanner = ParserFactory.createScanner((Reader)charArrayReader, (String)iPath.toOSString(), (IScannerInfo)scannerInfo, (ParserMode)ParserMode.COMPLETION_PARSE, (ParserLanguage)iScannerInfo, (ISourceElementRequestor)contentAssistElementRequestor, (IParserLogService)ParserUtil.getScannerLogService());
            iParser = ParserFactory.createParser((IScanner)iScanner, (ISourceElementRequestor)contentAssistElementRequestor, (ParserMode)ParserMode.COMPLETION_PARSE, (ParserLanguage)iScannerInfo, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        if (iParser != null) {
            IASTCompletionNode iASTCompletionNode = null;
            try {
                iASTCompletionNode = iParser.parse(n);
                this.macroMap = iScanner.getDefinitions();
            }
            catch (ParseError parseError) {}
            return iASTCompletionNode;
        }
        return null;
    }

    private void addNodeToCompletions(IASTNode iASTNode, String string, int n) {
        if (iASTNode instanceof IASTField) {
            ++this.numFields;
            IASTField iASTField = (IASTField)iASTNode;
            int n2 = this.computeRelevance(69, string, iASTField.getName());
            this.requestor.acceptField(iASTField.getName(), ASTUtil.getType((IASTAbstractDeclaration)iASTField.getAbstractDeclaration()), iASTField.getVisiblity(), this.completionStart, this.completionLength, n2 += n - this.numFields);
        } else if (iASTNode instanceof IASTParameterDeclaration) {
            ++this.numLocalVariables;
            IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iASTNode;
            int n3 = this.computeRelevance(76, string, iASTParameterDeclaration.getName());
            this.requestor.acceptLocalVariable(iASTParameterDeclaration.getName(), ASTUtil.getType((IASTAbstractDeclaration)iASTParameterDeclaration), this.completionStart, this.completionLength, n3 += n - this.numLocalVariables);
        } else if (iASTNode instanceof IASTVariable) {
            IASTVariable iASTVariable = (IASTVariable)iASTNode;
            IASTScope iASTScope = iASTVariable.getOwnerScope();
            if (iASTScope instanceof IASTCodeScope) {
                ++this.numLocalVariables;
                int n4 = this.computeRelevance(76, string, iASTVariable.getName());
                this.requestor.acceptLocalVariable(iASTVariable.getName(), ASTUtil.getType((IASTAbstractDeclaration)iASTVariable.getAbstractDeclaration()), this.completionStart, this.completionLength, n4 += n - this.numLocalVariables);
            } else {
                ++this.numVariables;
                int n5 = this.computeRelevance(74, string, iASTVariable.getName());
                this.requestor.acceptVariable(iASTVariable.getName(), ASTUtil.getType((IASTAbstractDeclaration)iASTVariable.getAbstractDeclaration()), this.completionStart, this.completionLength, n5 += n - this.numVariables);
            }
        } else if (iASTNode instanceof IASTMethod) {
            ++this.numMethods;
            IASTMethod iASTMethod = (IASTMethod)iASTNode;
            int n6 = this.computeRelevance(67, string, iASTMethod.getName());
            String string2 = ASTUtil.getParametersString((String[])ASTUtil.getFunctionParameterTypes((IASTFunction)iASTMethod));
            this.requestor.acceptMethod(iASTMethod.getName(), string2, ASTUtil.getType((IASTAbstractDeclaration)iASTMethod.getReturnType()), iASTMethod.getVisiblity(), this.completionStart, this.completionLength, n6 += n - this.numMethods);
        } else if (iASTNode instanceof IASTFunction) {
            ++this.numFunctions;
            IASTFunction iASTFunction = (IASTFunction)iASTNode;
            int n7 = this.computeRelevance(71, string, iASTFunction.getName());
            String string3 = ASTUtil.getParametersString((String[])ASTUtil.getFunctionParameterTypes((IASTFunction)iASTFunction));
            this.requestor.acceptFunction(iASTFunction.getName(), string3, ASTUtil.getType((IASTAbstractDeclaration)iASTFunction.getReturnType()), this.completionStart, this.completionLength, n7 += n - this.numFunctions);
        } else if (iASTNode instanceof IASTClassSpecifier) {
            int n8;
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTNode;
            ASTClassKind aSTClassKind = iASTClassSpecifier.getClassKind();
            if (aSTClassKind == ASTClassKind.CLASS) {
                ++this.numClasses;
                n8 = this.computeRelevance(64, string, iASTClassSpecifier.getName());
                this.requestor.acceptClass(iASTClassSpecifier.getName(), this.completionStart, this.completionLength, n8 += n - this.numClasses);
            }
            if (aSTClassKind == ASTClassKind.STRUCT) {
                ++this.numStructs;
                n8 = this.computeRelevance(65, string, iASTClassSpecifier.getName());
                this.requestor.acceptStruct(iASTClassSpecifier.getName(), this.completionStart, this.completionLength, n8 += n - this.numStructs);
            }
            if (aSTClassKind == ASTClassKind.UNION) {
                ++this.numUnions;
                n8 = this.computeRelevance(66, string, iASTClassSpecifier.getName());
                this.requestor.acceptUnion(iASTClassSpecifier.getName(), this.completionStart, this.completionLength, n8 += n - this.numUnions);
            }
        } else if (iASTNode instanceof IASTNamespaceDefinition) {
            ++this.numNamespaces;
            IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iASTNode;
            int n9 = this.computeRelevance(61, string, iASTNamespaceDefinition.getName());
            this.requestor.acceptNamespace(iASTNamespaceDefinition.getName(), this.completionStart, this.completionLength, n9 += n - this.numNamespaces);
        } else if (iASTNode instanceof IASTEnumerationSpecifier) {
            ++this.numEnumerations;
            IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)iASTNode;
            int n10 = this.computeRelevance(63, string, iASTEnumerationSpecifier.getName());
            this.requestor.acceptEnumeration(iASTEnumerationSpecifier.getName(), this.completionStart, this.completionLength, n10 += n - this.numEnumerations);
        } else if (iASTNode instanceof IASTEnumerator) {
            ++this.numEnumerators;
            IASTEnumerator iASTEnumerator = (IASTEnumerator)iASTNode;
            int n11 = this.computeRelevance(79, string, iASTEnumerator.getName());
            this.requestor.acceptEnumerator(iASTEnumerator.getName(), this.completionStart, this.completionLength, n11 += n - this.numEnumerators);
        }
    }

    private void addKeywordToCompletions(String string) {
        int n = 10;
        this.requestor.acceptKeyword(string, this.completionStart, this.completionLength, n);
    }

    private void addKeywordsToCompletions(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addKeywordToCompletions(string);
            ++n;
        }
        this.log("No of Keywords       = " + n);
    }

    private void addMacroToCompletions(String string) {
        int n = 40;
        this.requestor.acceptMacro(string, this.completionStart, this.completionLength, n);
    }

    private void addMacrosToCompletions(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addMacroToCompletions(string);
            ++n;
        }
        this.log("No of Macros         = " + n);
    }

    private void resetElementNumbers() {
        this.numFields = 0;
        this.numVariables = 0;
        this.numLocalVariables = 0;
        this.numMethods = 0;
        this.numFunctions = 0;
        this.numClasses = 0;
        this.numStructs = 0;
        this.numUnions = 0;
        this.numEnumerations = 0;
        this.numEnumerators = 0;
        this.numNamespaces = 0;
    }

    private void addToCompletions(IASTNode.ILookupResult iLookupResult) {
        if (iLookupResult == null) {
            this.log("Lookup Results       = null ................. !!! No Lookup Results found !!! ");
            return;
        }
        Iterator iterator = iLookupResult.getNodes();
        int n = iLookupResult.getResultsSize();
        this.log("No of Lookup Results = " + n);
        this.resetElementNumbers();
        while (iterator.hasNext()) {
            IASTNode iASTNode = (IASTNode)iterator.next();
            this.addNodeToCompletions(iASTNode, iLookupResult.getPrefix(), n);
        }
    }

    private IASTNode.ILookupResult lookup(IASTScope iASTScope, String string, IASTNode.LookupKind[] lookupKindArray, IASTNode iASTNode) {
        try {
            this.logLookups(lookupKindArray);
            IASTNode.ILookupResult iLookupResult = iASTScope.lookup(string, lookupKindArray, iASTNode);
            return iLookupResult;
        }
        catch (IASTNode.LookupError lookupError) {
            lookupError.printStackTrace();
            return null;
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {
            aSTNotImplementedException.printStackTrace();
            return null;
        }
    }

    private List lookupMacros(String string) {
        TreeSet treeSet = new TreeSet(this.macroMap.keySet());
        Iterator iterator = treeSet.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = "";
            string3 = string2.length() > string.length() ? string2.substring(0, string.length()) : string2;
            if (string3.equalsIgnoreCase(string)) {
                IMacroDescriptor iMacroDescriptor = (IMacroDescriptor)this.macroMap.get(string2);
                if (iMacroDescriptor.getMacroType() == IMacroDescriptor.MacroType.FUNCTION_LIKE) {
                    arrayList.add(iMacroDescriptor.getCompleteSignature());
                    continue;
                }
                arrayList.add(iMacroDescriptor.getName());
                continue;
            }
            if (string3.compareToIgnoreCase(string) > 0) break;
        }
        return arrayList;
    }

    private void completionOnMemberReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.ILookupResult iLookupResult = null;
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.FIELDS, IASTNode.LookupKind.METHODS};
        iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext());
        this.addToCompletions(iLookupResult);
    }

    private void completionOnTypeReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        if (iASTCompletionNode.getCompletionPrefix().length() > 0) {
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES, IASTNode.LookupKind.ENUMERATIONS, IASTNode.LookupKind.NAMESPACES};
            IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext());
            this.addToCompletions(iLookupResult);
        }
    }

    private void completionOnFieldType(IASTCompletionNode iASTCompletionNode) {
        IASTClassSpecifier iASTClassSpecifier;
        this.completionOnTypeReference(iASTCompletionNode);
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        if (iASTCompletionNode.getCompletionPrefix().length() == 0 && iASTScope instanceof IASTClassSpecifier && (iASTClassSpecifier = (IASTClassSpecifier)iASTScope).getClassKind() == ASTClassKind.CLASS) {
            IASTNode.ILookupResult iLookupResult = null;
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES};
            iLookupResult = this.lookup(iASTScope, iASTClassSpecifier.getName(), lookupKindArray, iASTCompletionNode.getCompletionContext());
            this.addToCompletions(iLookupResult);
        }
    }

    private void completionOnVariableType(IASTCompletionNode iASTCompletionNode) {
        this.completionOnTypeReference(iASTCompletionNode);
    }

    private void completionOnSingleNameReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.ILookupResult iLookupResult = null;
        if (iASTCompletionNode.getCompletionPrefix().length() > 0) {
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
            String string = iASTCompletionNode.getCompletionPrefix();
            if (string.equals("(")) {
                string = "";
            }
            iLookupResult = this.lookup(iASTScope, string, lookupKindArray, iASTCompletionNode.getCompletionContext());
            this.addToCompletions(iLookupResult);
            List list = this.lookupMacros(iASTCompletionNode.getCompletionPrefix());
            this.addMacrosToCompletions(list.iterator());
        } else {
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.THIS};
            iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext());
            this.addToCompletions(iLookupResult);
            lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES};
            iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext());
            this.addToCompletions(iLookupResult);
        }
    }

    private void completionOnClassReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.CLASSES};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext());
        this.addToCompletions(iLookupResult);
    }

    private void completionOnNamespaceReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.NAMESPACES};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext());
        this.addToCompletions(iLookupResult);
    }

    private void completionOnExceptionReference(IASTCompletionNode iASTCompletionNode) {
        this.completionOnTypeReference(iASTCompletionNode);
        if (iASTCompletionNode.getCompletionPrefix().length() == 0) {
            this.addKeywordToCompletions(exceptionKeyword);
        }
    }

    private void completionOnMacroReference(IASTCompletionNode iASTCompletionNode) {
        iASTCompletionNode.getCompletionScope();
        List list = this.lookupMacros(iASTCompletionNode.getCompletionPrefix());
        this.addMacrosToCompletions(list.iterator());
    }

    private void completionOnNewTypeReference(IASTCompletionNode iASTCompletionNode) {
        iASTCompletionNode.getCompletionScope();
        iASTCompletionNode.getCompletionContext();
        this.completionOnTypeReference(iASTCompletionNode);
    }

    private void completionOnConstructorReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.CONSTRUCTORS};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext());
        this.addToCompletions(iLookupResult);
    }

    private void completionOnFunctionReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.FUNCTIONS, IASTNode.LookupKind.METHODS};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext());
        this.addToCompletions(iLookupResult);
    }

    public IASTCompletionNode complete(IWorkingCopy iWorkingCopy, int n) {
        long l = System.currentTimeMillis();
        IASTCompletionNode iASTCompletionNode = this.parse(iWorkingCopy, n);
        this.log("");
        if (iASTCompletionNode == null) {
            this.log("Null Completion Node Error");
            return null;
        }
        this.log("Offset  = " + n);
        this.logNode("Scope   = ", (IASTNode)iASTCompletionNode.getCompletionScope());
        this.logNode("Context = ", iASTCompletionNode.getCompletionContext());
        this.logKind("Kind    = ", iASTCompletionNode.getCompletionKind());
        this.log("Prefix  = " + iASTCompletionNode.getCompletionPrefix());
        if (iASTCompletionNode.getCompletionScope() == null) {
            this.log("Null Completion Scope Error");
            return null;
        }
        this.completionStart = n - iASTCompletionNode.getCompletionPrefix().length();
        this.completionLength = iASTCompletionNode.getCompletionPrefix().length();
        IASTCompletionNode.CompletionKind completionKind = iASTCompletionNode.getCompletionKind();
        if (completionKind == IASTCompletionNode.CompletionKind.MEMBER_REFERENCE) {
            this.completionOnMemberReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.FIELD_TYPE) {
            this.completionOnFieldType(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.VARIABLE_TYPE) {
            this.completionOnVariableType(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.ARGUMENT_TYPE) {
            this.completionOnTypeReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            this.completionOnSingleNameReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.TYPE_REFERENCE) {
            this.completionOnTypeReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.CLASS_REFERENCE) {
            this.completionOnClassReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.NAMESPACE_REFERENCE) {
            this.completionOnNamespaceReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.EXCEPTION_REFERENCE) {
            this.completionOnExceptionReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.MACRO_REFERENCE) {
            this.completionOnMacroReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE) {
            this.completionOnNewTypeReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.FUNCTION_REFERENCE) {
            this.completionOnFunctionReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE) {
            this.completionOnConstructorReference(iASTCompletionNode);
        }
        if (completionKind != IASTCompletionNode.CompletionKind.MEMBER_REFERENCE) {
            this.addKeywordsToCompletions(iASTCompletionNode.getKeywords());
        }
        this.log("Time spent in Completion Engine = " + (System.currentTimeMillis() - l) + " ms");
        return iASTCompletionNode;
    }

    private void logKind(String string, IASTCompletionNode.CompletionKind completionKind) {
        if (!CCorePlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        String string2 = "";
        if (completionKind == IASTCompletionNode.CompletionKind.MEMBER_REFERENCE) {
            string2 = "MEMBER_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.FIELD_TYPE) {
            string2 = "FIELD_TYPE Class Scope";
        } else if (completionKind == IASTCompletionNode.CompletionKind.VARIABLE_TYPE) {
            string2 = "VARIABLE_TYPE Global Scope";
        } else if (completionKind == IASTCompletionNode.CompletionKind.ARGUMENT_TYPE) {
            string2 = "ARGUMENT_TYPE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            string2 = "SINGLE_NAME_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.TYPE_REFERENCE) {
            string2 = "TYPE_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.CLASS_REFERENCE) {
            string2 = "CLASS_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.NAMESPACE_REFERENCE) {
            string2 = "NAMESPACE_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.EXCEPTION_REFERENCE) {
            string2 = "EXCEPTION_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.MACRO_REFERENCE) {
            string2 = "MACRO_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE) {
            string2 = "CONSTRUCTOR_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE) {
            string2 = "NEW_TYPE_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.PREPROCESSOR_DIRECTIVE) {
            string2 = "PREPROCESSOR_DIRECTIVE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.USER_SPECIFIED_NAME) {
            string2 = "USER_SPECIFIED_NAME";
        } else if (completionKind == IASTCompletionNode.CompletionKind.NO_SUCH_KIND) {
            string2 = "NO_SUCH_KIND";
        }
        this.log(String.valueOf(string) + string2);
    }

    private void logNode(String string, IASTNode iASTNode) {
        if (!CCorePlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        if (iASTNode == null) {
            this.log(String.valueOf(string) + "null");
            return;
        }
        if (iASTNode instanceof IASTMethod) {
            String string2 = "Method: ";
            string2 = String.valueOf(string2) + ((IASTMethod)iASTNode).getName();
            this.log(String.valueOf(string) + string2);
            return;
        }
        if (iASTNode instanceof IASTFunction) {
            String string3 = "Function: ";
            string3 = String.valueOf(string3) + ((IASTFunction)iASTNode).getName();
            this.log(String.valueOf(string) + string3);
            return;
        }
        if (iASTNode instanceof IASTClassSpecifier) {
            String string4 = "Class: ";
            string4 = String.valueOf(string4) + ((IASTClassSpecifier)iASTNode).getName();
            this.log(String.valueOf(string) + string4);
            return;
        }
        if (iASTNode instanceof IASTCompilationUnit) {
            String string5 = "Global";
            this.log(String.valueOf(string) + string5);
            return;
        }
        if (iASTNode instanceof IASTCodeScope) {
            String string6 = "Code Scope";
            this.log(String.valueOf(string) + string6);
            return;
        }
        this.log(String.valueOf(string) + iASTNode.toString());
    }

    private void logLookups(IASTNode.LookupKind[] lookupKindArray) {
        if (!CCorePlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Looking For ");
        int n = 0;
        while (n < lookupKindArray.length) {
            IASTNode.LookupKind lookupKind = lookupKindArray[n];
            if (lookupKind == IASTNode.LookupKind.ALL) {
                stringBuffer.append("ALL");
            } else if (lookupKind == IASTNode.LookupKind.STRUCTURES) {
                stringBuffer.append("STRUCTURES");
            } else if (lookupKind == IASTNode.LookupKind.STRUCTS) {
                stringBuffer.append("STRUCTS");
            } else if (lookupKind == IASTNode.LookupKind.UNIONS) {
                stringBuffer.append("UNIONS");
            } else if (lookupKind == IASTNode.LookupKind.CLASSES) {
                stringBuffer.append("CLASSES");
            } else if (lookupKind == IASTNode.LookupKind.FUNCTIONS) {
                stringBuffer.append("FUNCTIONS");
            } else if (lookupKind == IASTNode.LookupKind.VARIABLES) {
                stringBuffer.append("VARIABLES");
            } else if (lookupKind == IASTNode.LookupKind.LOCAL_VARIABLES) {
                stringBuffer.append("LOCAL_VARIABLES");
            } else if (lookupKind == IASTNode.LookupKind.MEMBERS) {
                stringBuffer.append("MEMBERS");
            } else if (lookupKind == IASTNode.LookupKind.METHODS) {
                stringBuffer.append("METHODS");
            } else if (lookupKind == IASTNode.LookupKind.FIELDS) {
                stringBuffer.append("FIELDS");
            } else if (lookupKind == IASTNode.LookupKind.CONSTRUCTORS) {
                stringBuffer.append("CONSTRUCTORS");
            } else if (lookupKind == IASTNode.LookupKind.NAMESPACES) {
                stringBuffer.append("NAMESPACES");
            } else if (lookupKind == IASTNode.LookupKind.ENUMERATIONS) {
                stringBuffer.append("ENUMERATIONS");
            } else if (lookupKind == IASTNode.LookupKind.ENUMERATORS) {
                stringBuffer.append("ENUMERATORS");
            } else if (lookupKind == IASTNode.LookupKind.THIS) {
                stringBuffer.append("THIS");
            }
            stringBuffer.append(", ");
            ++n;
        }
        this.log(stringBuffer.toString());
    }

    private void log(String string) {
        if (!CUIPlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        Util.debugLog(string, IDebugLogConstants.CONTENTASSIST);
    }
}

