/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LinkToFileGroup;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class NewClassWizardPage
extends WizardPage
implements Listener {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private final String HEADER_EXT = ".h";
    private final String BODY_EXT = ".cpp";
    private IStructuredSelection currentSelection;
    private ICElement eSelection = null;
    private ITranslationUnit parentHeaderTU = null;
    private ITranslationUnit parentBodyTU = null;
    private ICElement createdClass = null;
    private List elementsOfTypeClassInProject = null;
    private StringDialogField fClassNameDialogField;
    private StringButtonDialogField fBaseClassDialogField;
    private SelectionButtonDialogFieldGroup fAccessButtons;
    private SelectionButtonDialogFieldGroup fConstDestButtons;
    private LinkToFileGroup linkedResourceGroupForHeader;
    private LinkToFileGroup linkedResourceGroupForBody;
    private final int PUBLIC_INDEX = 0;
    private final int PROTECTED_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int DEFAULT_INDEX = 3;
    private IStatus fCurrStatus;
    protected IStatus fClassNameStatus;
    protected IStatus fBaseClassStatus;
    private boolean hasCppNature = false;
    BasicSearchResultCollector resultCollector;
    SearchEngine searchEngine;

    public NewClassWizardPage(IStructuredSelection iStructuredSelection) {
        super(PAGE_NAME);
        this.currentSelection = iStructuredSelection;
        this.hasCppNature = this.isSelectionCPP(this.currentSelection);
        if (this.hasCppNature) {
            this.initializePageControls();
        }
    }

    protected void initializePageControls() {
        TypeFieldsAdapter typeFieldsAdapter = new TypeFieldsAdapter();
        this.fClassNameDialogField = new StringDialogField();
        this.fClassNameDialogField.setDialogFieldListener(typeFieldsAdapter);
        this.fClassNameDialogField.setLabelText(NewWizardMessages.getString("NewClassWizardPage.classname.label"));
        this.fBaseClassDialogField = new StringButtonDialogField(typeFieldsAdapter);
        this.fBaseClassDialogField.setDialogFieldListener(typeFieldsAdapter);
        this.fBaseClassDialogField.setLabelText(NewWizardMessages.getString("NewClassWizardPage.baseclass.label"));
        this.fBaseClassDialogField.setButtonLabel(NewWizardMessages.getString("NewClassWizardPage.baseclass.button"));
        String[] stringArray = new String[]{NewWizardMessages.getString("NewClassWizardPage.baseclass.access.public"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.protected"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.private"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.access")};
        this.fAccessButtons = new SelectionButtonDialogFieldGroup(16, stringArray, 4);
        this.fAccessButtons.setDialogFieldListener(typeFieldsAdapter);
        this.fAccessButtons.setLabelText(NewWizardMessages.getString("NewClassWizardPage.baseclass.access.label"));
        this.fAccessButtons.setSelection(0, true);
        String[] stringArray2 = new String[]{NewWizardMessages.getString("NewClassWizardPage.constdest.inline"), NewWizardMessages.getString("NewClassWizardPage.constdest.virtualdestructor"), NewWizardMessages.getString("NewClassWizardPage.constdest.includeguard")};
        this.fConstDestButtons = new SelectionButtonDialogFieldGroup(32, stringArray2, 3);
        this.fConstDestButtons.setDialogFieldListener(typeFieldsAdapter);
        this.linkedResourceGroupForHeader = new LinkToFileGroup(typeFieldsAdapter, this);
        this.linkedResourceGroupForHeader.setLabelText(NewWizardMessages.getString("NewClassWizardPage.files.header"));
        this.linkedResourceGroupForBody = new LinkToFileGroup(typeFieldsAdapter, this);
        this.linkedResourceGroupForBody.setLabelText(NewWizardMessages.getString("NewClassWizardPage.files.body"));
        this.fClassNameStatus = new StatusInfo();
        this.fBaseClassStatus = new StatusInfo();
        this.resultCollector = new BasicSearchResultCollector();
        this.searchEngine = new SearchEngine();
    }

    public void init() {
        if (this.hasCppNature) {
            this.fAccessButtons.setEnabled(false);
            this.setPageComplete(false);
            this.eSelection = this.getSelectionCElement(this.currentSelection);
        } else {
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.NotAvailableForNonCppProjects"));
            this.updateStatus(statusInfo);
        }
    }

    public void createControl(Composite composite) {
        if (!this.hasCppNature) {
            this.setControl((Control)new Composite(composite, 0));
            return;
        }
        int n = 5;
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(n, false));
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        this.createClassNameControls(composite2, n);
        this.createBaseClassControls(composite2, n);
        this.createModifierControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createFilesControls(composite2, n);
        composite2.layout();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
    }

    protected void createClassNameControls(Composite composite, int n) {
        this.fClassNameDialogField.doFillIntoGrid(composite, n - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fClassNameDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void createBaseClassControls(Composite composite, int n) {
        this.fBaseClassDialogField.doFillIntoGrid(composite, n);
        LayoutUtil.setWidthHint((Control)this.fBaseClassDialogField.getTextControl(null), this.getMaxFieldWidth());
        this.createAccessControls(composite, n);
    }

    protected void createAccessControls(Composite composite, int n) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccessButtons.getLabelControl(composite), 1);
        Composite composite2 = this.fAccessButtons.getSelectionButtonsGroup(composite);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n - 2;
        composite2.setLayoutData((Object)gridData);
        DialogField.createEmptySpace(composite);
    }

    protected void createModifierControls(Composite composite, int n) {
        LayoutUtil.setHorizontalSpan((Control)this.fConstDestButtons.getLabelControl(composite), 1);
        Composite composite2 = this.fConstDestButtons.getSelectionButtonsGroup(composite);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n - 1;
        composite2.setLayoutData((Object)gridData);
        DialogField.createEmptySpace(composite);
    }

    protected void createFilesControls(Composite composite, int n) {
        this.linkedResourceGroupForHeader.doFillIntoGrid(composite, n);
        this.linkedResourceGroupForBody.doFillIntoGrid(composite, n);
    }

    protected void createSeparator(Composite composite, int n) {
        new Separator(258).doFillIntoGrid(composite, n, this.convertHeightInCharsToPixels(1));
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    public void handleEvent(Event event) {
    }

    private void classPageChangeControlPressed(DialogField dialogField) {
        BasicSearchMatch basicSearchMatch;
        if (dialogField == this.fBaseClassDialogField && (basicSearchMatch = (BasicSearchMatch)this.chooseBaseClass()) != null) {
            this.fBaseClassDialogField.setText(basicSearchMatch.getName());
        }
    }

    private void classPageCustomButtonPressed(DialogField dialogField, int n) {
    }

    private void classPageDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fClassNameDialogField) {
            String string = this.fClassNameDialogField.getText();
            if (!this.linkedResourceGroupForHeader.linkCreated()) {
                if (string.length() > 0) {
                    this.linkedResourceGroupForHeader.setText(String.valueOf(string) + ".h");
                } else {
                    this.linkedResourceGroupForHeader.setText(string);
                }
            }
            if (!this.linkedResourceGroupForBody.linkCreated()) {
                if (string.length() > 0) {
                    this.linkedResourceGroupForBody.setText(String.valueOf(string) + ".cpp");
                } else {
                    this.linkedResourceGroupForBody.setText(string);
                }
            }
            this.fClassNameStatus = this.classNameChanged();
        }
        if (dialogField == this.fBaseClassDialogField) {
            if (this.fBaseClassDialogField.getText().length() >= 0) {
                this.fAccessButtons.setEnabled(true);
                this.fBaseClassStatus = this.baseClassNameChanged();
            } else {
                this.fAccessButtons.setEnabled(false);
            }
        }
        this.doStatusUpdate();
    }

    public boolean selectionIsCpp() {
        return this.hasCppNature;
    }

    private boolean isSelectionCPP(IStructuredSelection iStructuredSelection) {
        IProject iProject = null;
        ICElement iCElement = this.getSelectionCElement(iStructuredSelection);
        if (iCElement == null) {
            IResource iResource = this.getSelectionResourceElement(iStructuredSelection);
            iProject = iResource.getProject();
        } else {
            iProject = iCElement.getCProject().getProject();
        }
        if (iProject != null) {
            return CoreModel.getDefault().hasCCNature(iProject);
        }
        return false;
    }

    private ICElement getSelectionCElement(IStructuredSelection iStructuredSelection) {
        Object e;
        List list;
        if (!iStructuredSelection.isEmpty() && iStructuredSelection instanceof IStructuredSelection && (list = iStructuredSelection.toList()).size() == 1 && (e = list.get(0)) instanceof ICElement) {
            return (ICElement)e;
        }
        return null;
    }

    private IResource getSelectionResourceElement(IStructuredSelection iStructuredSelection) {
        Object e;
        List list;
        if (!iStructuredSelection.isEmpty() && iStructuredSelection instanceof IStructuredSelection && (list = iStructuredSelection.toList()).size() == 1 && (e = list.get(0)) instanceof IResource) {
            if (e instanceof IFile) {
                IFile iFile = (IFile)e;
                return (IResource)iFile.getParent();
            }
            return (IResource)e;
        }
        return null;
    }

    private void getChildrenOfTypeClass(IParent iParent, List list, IProgressMonitor iProgressMonitor, int n) {
        ICElement[] iCElementArray = iParent.getChildren();
        iProgressMonitor.worked(n);
        int n2 = 0;
        while (n2 < iCElementArray.length) {
            ICElement iCElement = iCElementArray[n2];
            if (iCElement.getElementType() == 64) {
                list.add(iCElement);
            }
            if (iCElement instanceof IParent) {
                this.getChildrenOfTypeClass((IParent)iCElement, list, iProgressMonitor, n + 1);
            }
            ++n2;
        }
    }

    private void searchForClasses(ICProject iCProject, List list, IProgressMonitor iProgressMonitor, int n) {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false);
        ICElement[] iCElementArray = new ICElement[]{iCProject};
        ICSearchScope iCSearchScope = SearchEngine.createCSearchScope((ICElement[])iCElementArray, (boolean)true);
        try {
            this.searchEngine.search(CUIPlugin.getWorkspace(), iCSearchPattern, iCSearchScope, (ICSearchResultCollector)this.resultCollector, false);
        }
        catch (InterruptedException interruptedException) {}
        list.addAll(this.resultCollector.getSearchResults());
    }

    private List getClassElementsInProject() {
        return this.elementsOfTypeClassInProject;
    }

    private List findClassElementsInProject() {
        if (this.eSelection == null) {
            return new LinkedList();
        }
        if (this.elementsOfTypeClassInProject != null) {
            return this.elementsOfTypeClassInProject;
        }
        this.elementsOfTypeClassInProject = new LinkedList();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                iProgressMonitor.beginTask(NewWizardMessages.getString("NewClassWizardPage.operations.getProjectClasses"), 5);
                try {
                    ICProject iCProject = NewClassWizardPage.this.eSelection.getCProject();
                    NewClassWizardPage.this.searchForClasses(iCProject, NewClassWizardPage.this.elementsOfTypeClassInProject, iProgressMonitor, 1);
                    iProgressMonitor.worked(5);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                iProgressMonitor.done();
            }
        };
        try {
            this.getWizard().getContainer().run(false, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return this.elementsOfTypeClassInProject;
    }

    protected Object chooseBaseClass() {
        List list = this.findClassElementsInProject();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new CSearchResultLabelProvider());
        elementListSelectionDialog.setTitle(NewWizardMessages.getString("BaseClassSelectionDialog.title"));
        elementListSelectionDialog.setMessage(NewWizardMessages.getString("BaseClassSelectionDialog.message"));
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setFilter("*");
        if (elementListSelectionDialog.open() == 0) {
            Object object = elementListSelectionDialog.getFirstResult();
            return object;
        }
        return null;
    }

    public String getNewClassName() {
        return this.fClassNameDialogField.getText();
    }

    public String getBaseClassName() {
        return this.fBaseClassDialogField.getText();
    }

    public boolean isIncludeGuard() {
        return this.fConstDestButtons.isSelected(2);
    }

    public boolean isVirtualDestructor() {
        return this.fConstDestButtons.isSelected(1);
    }

    public boolean isInline() {
        return this.fConstDestButtons.isSelected(0);
    }

    public String getAccess() {
        if (this.fAccessButtons.isSelected(0)) {
            return "public";
        }
        if (this.fAccessButtons.isSelected(1)) {
            return "protected";
        }
        if (this.fAccessButtons.isSelected(2)) {
            return "private";
        }
        return "";
    }

    public ITranslationUnit getCreatedClassHeaderFile() {
        return this.parentHeaderTU;
    }

    public ITranslationUnit getCreatedClassBodyFile() {
        return this.parentBodyTU;
    }

    public ICElement getCreatedClassElement() {
        return this.createdClass;
    }

    public IStructure getBaseClassElement() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createClass(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(NewWizardMessages.getString("NewTypeWizardPage.operationdesc"), 10);
        try {
            try {
                IWorkingCopy iWorkingCopy;
                IWorkingCopy iWorkingCopy2;
                String string;
                String string2 = null;
                string2 = System.getProperty("line.separator", "\n");
                this.parentHeaderTU = this.createTranslationUnit(this.linkedResourceGroupForHeader);
                this.parentBodyTU = this.createTranslationUnit(this.linkedResourceGroupForBody);
                iProgressMonitor.worked(1);
                if (this.parentHeaderTU != null) {
                    string = this.constructHeaderFileContent(string2);
                    iWorkingCopy2 = this.parentHeaderTU.getSharedWorkingCopy(null, CUIPlugin.getDefault().getDocumentProvider().getBufferFactory());
                    iWorkingCopy2.getBuffer().append(string);
                    iWorkingCopy = iWorkingCopy2;
                    synchronized (iWorkingCopy) {
                        iWorkingCopy2.reconcile();
                        iWorkingCopy2.commit(true, iProgressMonitor);
                    }
                    this.createdClass = iWorkingCopy2.getElement(this.getNewClassName());
                }
                if (this.parentBodyTU != null) {
                    string = this.constructBodyFileContent(string2);
                    iWorkingCopy2 = this.parentBodyTU.getSharedWorkingCopy(null, CUIPlugin.getDefault().getDocumentProvider().getBufferFactory());
                    iWorkingCopy2.getBuffer().append(string);
                    iWorkingCopy = iWorkingCopy2;
                    synchronized (iWorkingCopy) {
                        iWorkingCopy2.reconcile();
                        iWorkingCopy2.commit(true, iProgressMonitor);
                    }
                }
                Object var6_7 = null;
            }
            catch (CModelException cModelException) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.internalErrorTitle"), (String)WorkbenchMessages.format((String)"WizardNewFileCreationPage.internalErrorMessage", (Object[])new Object[]{cModelException.getMessage()}));
                Object var6_8 = null;
                iProgressMonitor.done();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return true;
    }

    protected ITranslationUnit createTranslationUnit(LinkToFileGroup linkToFileGroup) {
        ICElement iCElement;
        ITranslationUnit iTranslationUnit = null;
        IFile iFile = null;
        iFile = this.createNewFile(linkToFileGroup);
        if (iFile != null && (iCElement = CoreModel.getDefault().create(iFile)) instanceof ITranslationUnit) {
            iTranslationUnit = (ITranslationUnit)iCElement;
        }
        return iTranslationUnit;
    }

    protected IFile createNewFile(LinkToFileGroup linkToFileGroup) {
        final IPath iPath = this.getContainerFullPath(linkToFileGroup);
        final IFile iFile = this.createFileHandle(iPath);
        if (iFile.exists()) {
            return iFile;
        }
        final boolean bl = linkToFileGroup.linkCreated();
        final IPath iPath2 = this.getContainerPath(linkToFileGroup);
        final InputStream inputStream = this.getInitialContents();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
                try {
                    iProgressMonitor.beginTask(WorkbenchMessages.getString((String)"WizardNewFileCreationPage.progress"), 2000);
                    if (!NewClassWizardPage.this.containerExists(iPath2)) {
                        ContainerGenerator containerGenerator = new ContainerGenerator(iPath2);
                        containerGenerator.generateContainer((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                    }
                    NewClassWizardPage.this.createFile(iFile, inputStream, iPath, bl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                iProgressMonitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.errorTitle"), null, (IStatus)((CoreException)invocationTargetException.getTargetException()).getStatus());
            } else {
                WorkbenchPlugin.log((String)MessageFormat.format("Exception in {0}.getNewFile(): {1}", ((Object)((Object)this)).getClass().getName(), invocationTargetException.getTargetException()));
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.internalErrorTitle"), (String)WorkbenchMessages.format((String)"WizardNewFileCreationPage.internalErrorMessage", (Object[])new Object[]{invocationTargetException.getTargetException().getMessage()}));
            }
            return null;
        }
        return iFile;
    }

    protected IFile createFileHandle(IPath iPath) {
        IFile iFile = null;
        IWorkspaceRoot iWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        iFile = iWorkspaceRoot.getFileForLocation(iPath);
        if (iFile == null) {
            iFile = iWorkspaceRoot.getFile(iPath);
        }
        return iFile;
    }

    protected void createFile(IFile iFile, InputStream inputStream, IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(new byte[0]);
        }
        try {
            iFile.create(inputStream, false, iProgressMonitor);
        }
        catch (CoreException coreException) {
            coreException.getStatus().getCode();
            if (coreException.getStatus().getCode() == 374) {
                iFile.refreshLocal(0, null);
            }
            throw coreException;
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IPath getSelectionPath() {
        if (this.eSelection == null) {
            IResource iResource = this.getSelectionResourceElement(this.currentSelection);
            if (iResource != null) {
                return iResource.getLocation().makeAbsolute();
            }
            return null;
        }
        if (this.eSelection instanceof ITranslationUnit) {
            return this.eSelection.getParent().getPath();
        }
        if (this.eSelection instanceof IOpenable) {
            return this.eSelection.getPath();
        }
        ICElement iCElement = this.eSelection.getParent();
        while (iCElement != null) {
            if (iCElement instanceof IOpenable && !(iCElement instanceof ITranslationUnit)) {
                return iCElement.getPath();
            }
            iCElement = iCElement.getParent();
        }
        return null;
    }

    protected IPath getContainerPath(LinkToFileGroup linkToFileGroup) {
        if (linkToFileGroup.linkCreated()) {
            String string = linkToFileGroup.getResolvedPath();
            if (string == null || string.length() < 1) {
                return null;
            }
            Path path = new Path(string);
            return path.removeLastSegments(1).removeTrailingSeparator().makeAbsolute();
        }
        return this.getSelectionPath();
    }

    protected IPath getContainerFullPath(LinkToFileGroup linkToFileGroup) {
        if (linkToFileGroup.linkCreated()) {
            String string = linkToFileGroup.getResolvedPath();
            if (string == null || string.length() < 1) {
                return null;
            }
            return new Path(string).makeAbsolute();
        }
        String string = linkToFileGroup.getText();
        IPath iPath = this.getSelectionPath();
        iPath.addTrailingSeparator();
        return iPath.append(string).makeAbsolute();
    }

    protected boolean containerExists(IPath iPath) {
        IContainer iContainer = null;
        IWorkspaceRoot iWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        iContainer = iWorkspaceRoot.getContainerForLocation(iPath);
        return iContainer != null;
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getClassComment(ITranslationUnit iTranslationUnit) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.javadoc")) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getNewClassName());
                String string = CodeGeneration.getClassComment(iTranslationUnit, stringBuffer.toString(), String.valueOf('\n'));
                if (string != null && this.isValidComment(string)) {
                    return string;
                }
            }
            catch (CoreException coreException) {
                CUIPlugin.getDefault().log(coreException);
            }
        }
        return null;
    }

    protected String constructHeaderFileContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string2 = this.getBaseClassName();
        String string3 = "";
        if (string2 != null && string2.length() > 0) {
            bl = true;
            List list = this.findClassElementsInProject();
            BasicSearchMatch cfr_ignored_0 = (BasicSearchMatch)this.findInList(string2, null, list);
            string3 = String.valueOf(string2) + ".h";
        }
        if (this.isIncludeGuard()) {
            stringBuffer.append("#ifndef ");
            stringBuffer.append(this.getNewClassName().toUpperCase());
            stringBuffer.append("_H");
            stringBuffer.append(string);
            stringBuffer.append("#define ");
            stringBuffer.append(this.getNewClassName().toUpperCase());
            stringBuffer.append("_H");
            stringBuffer.append(string);
            stringBuffer.append(string);
        }
        if (bl) {
            stringBuffer.append("#include \"");
            stringBuffer.append(string3);
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append(string);
        }
        stringBuffer.append("class ");
        stringBuffer.append(this.getNewClassName());
        if (bl) {
            stringBuffer.append(" : ");
            stringBuffer.append(this.getAccess());
            stringBuffer.append(" ");
            stringBuffer.append(string2);
        }
        stringBuffer.append("{");
        stringBuffer.append(string);
        stringBuffer.append("public:");
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append('\t');
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("()");
        if (this.isInline()) {
            stringBuffer.append(" {}");
            stringBuffer.append(string);
        } else {
            stringBuffer.append(";");
            stringBuffer.append(string);
        }
        stringBuffer.append('\t');
        if (this.isVirtualDestructor()) {
            stringBuffer.append("virtual ");
        }
        stringBuffer.append("~");
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("()");
        if (this.isInline()) {
            stringBuffer.append(" {}");
            stringBuffer.append(string);
        } else {
            stringBuffer.append(";");
            stringBuffer.append(string);
        }
        stringBuffer.append("};");
        stringBuffer.append(string);
        if (this.isIncludeGuard()) {
            stringBuffer.append(string);
            stringBuffer.append("#endif // ");
            stringBuffer.append(this.getNewClassName().toUpperCase());
            stringBuffer.append("_H");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected String constructBodyFileContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#include \"");
        stringBuffer.append(this.getCreatedClassHeaderFile().getElementName());
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append(string);
        if (this.isInline()) {
            return stringBuffer.toString();
        }
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("::");
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("()");
        stringBuffer.append(string);
        stringBuffer.append("{}");
        stringBuffer.append(string);
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("::~");
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("()");
        stringBuffer.append(string);
        stringBuffer.append("{}");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected void doStatusUpdate() {
        IStatus[] iStatusArray = new IStatus[]{this.fClassNameStatus, this.fBaseClassStatus};
        this.updateStatus(iStatusArray);
    }

    protected void updateStatus(IStatus[] iStatusArray) {
        this.updateStatus(StatusUtil.getMostSevere(iStatusArray));
    }

    protected void updateStatus(IStatus iStatus) {
        this.fCurrStatus = iStatus;
        this.setPageComplete(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    protected boolean isValidComment(String string) {
        return true;
    }

    protected IStatus classNameChanged() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.getNewClassName();
        if (string.length() == 0) {
            statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterClassName"));
            return statusInfo;
        }
        if (string.indexOf("::") != -1) {
            statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.QualifiedName"));
            return statusInfo;
        }
        IStatus iStatus = CConventions.validateClassName((String)string);
        if (iStatus.getSeverity() == 4) {
            statusInfo.setError(NewWizardMessages.getFormattedString("NewClassWizardPage.error.InvalidClassName", iStatus.getMessage()));
            return statusInfo;
        }
        if (iStatus.getSeverity() == 2) {
            statusInfo.setWarning(NewWizardMessages.getFormattedString("NewClassWizardPage.warning.ClassNameDiscouraged", iStatus.getMessage()));
        }
        List list = this.findClassElementsInProject();
        if (this.foundInList(this.getNewClassName(), this.getContainerPath(this.linkedResourceGroupForHeader), list)) {
            statusInfo.setWarning(NewWizardMessages.getString("NewClassWizardPage.error.ClassNameExists"));
        }
        return statusInfo;
    }

    protected IStatus baseClassNameChanged() {
        String string = this.getBaseClassName();
        StatusInfo statusInfo = new StatusInfo();
        if (string.length() == 0) {
            return statusInfo;
        }
        IStatus iStatus = CConventions.validateClassName((String)string);
        if (iStatus.getSeverity() == 4) {
            statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.InvalidBaseClassName"));
            return statusInfo;
        }
        List list = this.findClassElementsInProject();
        if (!this.foundInList(string, null, list)) {
            statusInfo.setWarning(NewWizardMessages.getString("NewClassWizardPage.warning.BaseClassNotExists"));
        }
        return statusInfo;
    }

    private Object findInList(String string, IPath iPath, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BasicSearchMatch basicSearchMatch = (BasicSearchMatch)iterator.next();
            if (!(iPath != null ? string.equals(basicSearchMatch.getName()) && iPath.makeAbsolute().equals((Object)basicSearchMatch.getLocation()) : string.equals(basicSearchMatch.getName()))) continue;
            return basicSearchMatch;
        }
        return null;
    }

    private boolean foundInList(String string, IPath iPath, List list) {
        return this.findInList(string, iPath, list) != null;
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        TypeFieldsAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
            NewClassWizardPage.this.classPageChangeControlPressed(dialogField);
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            NewClassWizardPage.this.classPageCustomButtonPressed(listDialogField, n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NewClassWizardPage.this.classPageDialogFieldChanged(dialogField);
        }

        public void doubleClicked(ListDialogField listDialogField) {
        }
    }
}

