/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;

public class ScannerContext
implements IScannerContext {
    private Reader reader;
    private String filename;
    private int macroOffset = -1;
    private int macroLength = -1;
    private int line = 1;
    private int offset;
    private Stack undo = new Stack();
    private IScannerContext.ContextKind kind;
    private IASTInclusion inc = null;

    public ScannerContext(Reader reader, String string, IScannerContext.ContextKind contextKind, IASTInclusion iASTInclusion, int n, int n2, int n3) {
        this.reader = reader;
        this.filename = string;
        this.offset = 0;
        this.kind = contextKind;
        this.inc = iASTInclusion;
        this.macroOffset = n;
        this.macroLength = n2;
        this.line = n3;
    }

    public ScannerContext(Reader reader, String string, IScannerContext.ContextKind contextKind, IASTInclusion iASTInclusion) {
        this(reader, string, contextKind, iASTInclusion, -1, -1, 1);
    }

    public int read() throws IOException {
        ++this.offset;
        int n = this.reader.read();
        if ((char)n == '\n') {
            ++this.line;
        }
        return n;
    }

    public final String getFilename() {
        return this.filename;
    }

    public final int getMacroOffset() {
        return this.macroOffset;
    }

    public final int getMacroLength() {
        return this.macroLength;
    }

    public final int getOffset() {
        return this.macroOffset < 0 ? this.offset : this.macroOffset;
    }

    public final int getRelativeOffset() {
        return this.offset;
    }

    public final int getLine() {
        return this.line;
    }

    public final Reader getReader() {
        return this.reader;
    }

    public final int undoStackSize() {
        return this.undo.size();
    }

    public final int popUndo() {
        int n = (Integer)this.undo.pop();
        if ((char)n == '\n') {
            ++this.line;
        }
        return n;
    }

    public void pushUndo(int n) {
        if ((char)n == '\n') {
            --this.line;
        }
        this.undo.push(new Integer(n));
    }

    public IScannerContext.ContextKind getKind() {
        return this.kind;
    }

    public void setKind(IScannerContext.ContextKind contextKind) {
        this.kind = contextKind;
    }

    public IASTInclusion getExtension() {
        return this.inc;
    }

    public void setExtension(IASTInclusion iASTInclusion) {
        this.inc = iASTInclusion;
    }
}

