/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTBaseSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.UnresolvedReferenceDuple;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTClassSpecifier
extends ASTScope
implements IASTClassSpecifier {
    private List declarations = new ArrayList();
    private NamedOffsets offsets = new NamedOffsets();
    private final IASTClassSpecifier.ClassNameType classNameType;
    private final ASTClassKind classKind;
    private ASTAccessVisibility currentVisibility;
    private final ASTQualifiedNamedElement qualifiedName;
    private final ASTReferenceStore references;
    private List unresolvedCrossReferences = new ArrayList();
    private List resolvedCrossReferences = new ArrayList();

    public ASTClassSpecifier(ISymbol iSymbol, ASTClassKind aSTClassKind, IASTClassSpecifier.ClassNameType classNameType, ASTAccessVisibility aSTAccessVisibility, int n, int n2, int n3, int n4, int n5, List list) {
        super(iSymbol);
        this.classKind = aSTClassKind;
        this.classNameType = classNameType;
        this.currentVisibility = aSTAccessVisibility;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iSymbol.getName());
        this.references = new ASTReferenceStore(list);
    }

    public IASTClassSpecifier.ClassNameType getClassNameType() {
        return this.classNameType;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public Iterator getBaseClauses() {
        return new BaseIterator((IDerivableContainerSymbol)this.getSymbol());
    }

    public ASTAccessVisibility getCurrentVisibilityMode() {
        return this.currentVisibility;
    }

    public void setCurrentVisibility(ASTAccessVisibility aSTAccessVisibility) {
        this.currentVisibility = aSTAccessVisibility;
    }

    public String getName() {
        return this.symbol.getName();
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int n) {
        this.offsets.setNameOffset(n);
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor) {
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor) {
        this.references.processReferences(iSourceElementRequestor);
        try {
            iSourceElementRequestor.enterClassSpecifier(this);
        }
        catch (Exception exception) {}
        Iterator iterator = this.getBaseClauses();
        while (iterator.hasNext()) {
            IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator.next();
            iASTBaseSpecifier.acceptElement(iSourceElementRequestor);
        }
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor) {
        Iterator iterator = this.resolvedCrossReferences.iterator();
        while (iterator.hasNext()) {
            ((IASTReference)iterator.next()).acceptElement(iSourceElementRequestor);
        }
        try {
            iSourceElementRequestor.exitClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setStartingOffsetAndLineNumber(n, n2);
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setEndingOffsetAndLineNumber(n, n2);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.symbol.getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.offsets.setNameEndOffsetAndLineNumber(n, n2);
    }

    public Iterator getDeclarations() {
        if (!this.declarations.isEmpty()) {
            return this.declarations.iterator();
        }
        return super.getDeclarations();
    }

    public void addDeclaration(IASTDeclaration iASTDeclaration) {
        this.declarations.add(iASTDeclaration);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }

    public void addUnresolvedReference(UnresolvedReferenceDuple unresolvedReferenceDuple) {
        this.unresolvedCrossReferences.add(unresolvedReferenceDuple);
    }

    public Iterator getUnresolvedReferences() {
        return this.unresolvedCrossReferences.iterator();
    }

    public void setExtraReferences(List list) {
        this.resolvedCrossReferences.addAll(list);
    }

    public class BaseIterator
    implements Iterator {
        private final Iterator parents;

        public BaseIterator(IDerivableContainerSymbol iDerivableContainerSymbol) {
            this.parents = iDerivableContainerSymbol.getParents() != null ? iDerivableContainerSymbol.getParents().iterator() : null;
        }

        public boolean hasNext() {
            if (this.parents == null) {
                return false;
            }
            return this.parents.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IDerivableContainerSymbol.IParentSymbol iParentSymbol = (IDerivableContainerSymbol.IParentSymbol)this.parents.next();
            return new ASTBaseSpecifier(iParentSymbol.getParent(), iParentSymbol.isVirtual(), iParentSymbol.getAccess(), iParentSymbol.getOffset(), iParentSymbol.getReferences());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

