/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTConstructorMemberInitializer;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTFunction;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;

public class ASTMethod
extends ASTFunction
implements IASTMethod {
    private final List constructorChain;
    private final boolean isConstructor;
    private final boolean isPureVirtual;
    private final ASTAccessVisibility visibility;
    private final boolean isDestructor;

    public ASTMethod(IParameterizedSymbol iParameterizedSymbol, List list, IASTAbstractDeclaration iASTAbstractDeclaration, IASTExceptionSpecification iASTExceptionSpecification, int n, int n2, int n3, int n4, int n5, IASTTemplate iASTTemplate, List list2, boolean bl, boolean bl2, boolean bl3, boolean bl4, ASTAccessVisibility aSTAccessVisibility, List list3, boolean bl5) {
        super(iParameterizedSymbol, n4, list, iASTAbstractDeclaration, iASTExceptionSpecification, n, n2, n3, n5, iASTTemplate, list2, bl, bl5);
        this.visibility = aSTAccessVisibility;
        this.isConstructor = bl2;
        this.isDestructor = bl3;
        this.isPureVirtual = bl4;
        this.constructorChain = list3;
    }

    public boolean isVirtual() {
        return this.symbol.getTypeInfo().checkBit(2048);
    }

    public boolean isExplicit() {
        return this.symbol.getTypeInfo().checkBit(4096);
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isDestructor() {
        return this.isDestructor;
    }

    public boolean isConst() {
        return this.symbol.getTypeInfo().checkBit(32768);
    }

    public boolean isVolatile() {
        return this.symbol.getTypeInfo().checkBit(65536);
    }

    public boolean isPureVirtual() {
        return this.isPureVirtual;
    }

    public ASTAccessVisibility getVisiblity() {
        return this.visibility;
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor) {
        try {
            iSourceElementRequestor.acceptMethodDeclaration(this);
        }
        catch (Exception exception) {}
        this.methodCallbacks(iSourceElementRequestor);
    }

    protected void methodCallbacks(ISourceElementRequestor iSourceElementRequestor) {
        this.functionCallbacks(iSourceElementRequestor);
        this.processConstructorChain(iSourceElementRequestor);
    }

    protected void processConstructorChain(ISourceElementRequestor iSourceElementRequestor) {
        if (this.constructorChain != null) {
            Iterator iterator = this.getConstructorChainInitializers();
            while (iterator.hasNext()) {
                IASTConstructorMemberInitializer iASTConstructorMemberInitializer = (IASTConstructorMemberInitializer)iterator.next();
                iASTConstructorMemberInitializer.acceptElement(iSourceElementRequestor);
            }
        }
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor) {
        try {
            iSourceElementRequestor.enterMethodBody(this);
        }
        catch (Exception exception) {}
        this.methodCallbacks(iSourceElementRequestor);
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor) {
        try {
            iSourceElementRequestor.exitMethodBody(this);
        }
        catch (Exception exception) {}
    }

    public Iterator getConstructorChainInitializers() {
        if (this.constructorChain == null) {
            return new EmptyIterator();
        }
        return this.constructorChain.iterator();
    }

    public IASTClassSpecifier getOwnerClassSpecifier() {
        return (IASTClassSpecifier)this.getOwnerScope();
    }
}

