/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ParameterizedSymbol
extends ContainerSymbol
implements IParameterizedSymbol {
    private LinkedList _parameterList;
    private Map _parameterMap;
    private ISymbol _returnType;
    private boolean _hasVarArgs = false;

    protected ParameterizedSymbol(ParserSymbolTable parserSymbolTable, String string) {
        super(parserSymbolTable, string);
    }

    protected ParameterizedSymbol(ParserSymbolTable parserSymbolTable, String string, ISymbolASTExtension iSymbolASTExtension) {
        super(parserSymbolTable, string, iSymbolASTExtension);
    }

    protected ParameterizedSymbol(ParserSymbolTable parserSymbolTable, String string, TypeInfo.eType eType2) {
        super(parserSymbolTable, string, eType2);
    }

    public Object clone() {
        ParameterizedSymbol parameterizedSymbol = (ParameterizedSymbol)super.clone();
        LinkedList linkedList = parameterizedSymbol._parameterList = this._parameterList != null ? (LinkedList)this._parameterList.clone() : null;
        parameterizedSymbol._parameterMap = this.getSymbolTable().getParserMode() == ParserMode.COMPLETION_PARSE ? (this._parameterMap != null ? (Map)((TreeMap)this._parameterMap).clone() : null) : (this._parameterMap != null ? (Map)((HashMap)this._parameterMap).clone() : null);
        return parameterizedSymbol;
    }

    public ISymbol instantiate(ITemplateSymbol iTemplateSymbol, Map map) throws ParserSymbolTableException {
        if (!this.isTemplateMember()) {
            return null;
        }
        ParameterizedSymbol parameterizedSymbol = (ParameterizedSymbol)super.instantiate(iTemplateSymbol, map);
        if (this._returnType != null) {
            if (this._returnType.isType(TypeInfo.t_templateParameter)) {
                if (map.containsKey(this._returnType)) {
                    parameterizedSymbol.setReturnType(this.getSymbolTable().newSymbol(""));
                    parameterizedSymbol.getReturnType().setTypeInfo((TypeInfo)map.get(this._returnType));
                    parameterizedSymbol.getReturnType().setInstantiatedSymbol(this._returnType);
                }
            } else {
                parameterizedSymbol.setReturnType(this._returnType.instantiate(iTemplateSymbol, map));
            }
        }
        Iterator iterator = this.getParameterList().iterator();
        parameterizedSymbol.getParameterList().clear();
        parameterizedSymbol.getParameterMap().clear();
        ISymbol iSymbol = null;
        ISymbol iSymbol2 = null;
        while (iterator.hasNext()) {
            iSymbol = (ISymbol)iterator.next();
            iSymbol2 = iSymbol.instantiate(iTemplateSymbol, map);
            parameterizedSymbol.getParameterList().add(iSymbol2);
            if (iSymbol2.getName().equals("")) continue;
            parameterizedSymbol.getParameterMap().put(iSymbol2.getName(), iSymbol2);
        }
        return parameterizedSymbol;
    }

    public void addParameter(ISymbol iSymbol) {
        Object object;
        List list = this.getParameterList();
        list.add(iSymbol);
        String string = iSymbol.getName();
        if (string != null && !string.equals("") && !(object = this.getParameterMap()).containsKey(string)) {
            object.put(string, iSymbol);
        }
        iSymbol.setContainingSymbol(this);
        iSymbol.setIsTemplateMember(this.isTemplateMember() || this.getType() == TypeInfo.t_template);
        object = new AddParameterCommand(this, iSymbol);
        this.getSymbolTable().pushCommand((ParserSymbolTable.Command)object);
    }

    public void addParameter(TypeInfo.eType eType2, int n, TypeInfo.PtrOp ptrOp, boolean bl) {
        BasicSymbol basicSymbol = new BasicSymbol(this.getSymbolTable(), "");
        TypeInfo typeInfo = basicSymbol.getTypeInfo();
        typeInfo.setTypeInfo(n);
        typeInfo.setType(eType2);
        typeInfo.addPtrOperator(ptrOp);
        typeInfo.setHasDefault(bl);
        this.addParameter(basicSymbol);
    }

    public void addParameter(ISymbol iSymbol, int n, TypeInfo.PtrOp ptrOp, boolean bl) {
        BasicSymbol basicSymbol = new BasicSymbol(this.getSymbolTable(), "");
        TypeInfo typeInfo = basicSymbol.getTypeInfo();
        typeInfo.setTypeInfo(n);
        typeInfo.setType(TypeInfo.t_type);
        typeInfo.setTypeSymbol(iSymbol);
        typeInfo.addPtrOperator(ptrOp);
        typeInfo.setHasDefault(bl);
        this.addParameter(basicSymbol);
    }

    public Map getParameterMap() {
        if (this._parameterMap == null) {
            this._parameterMap = this.getSymbolTable().getParserMode() == ParserMode.COMPLETION_PARSE ? new TreeMap(new ContainerSymbol.SymbolTableComparator()) : new HashMap();
        }
        return this._parameterMap;
    }

    public List getParameterList() {
        if (this._parameterList == null) {
            this._parameterList = new LinkedList();
        }
        return this._parameterList;
    }

    public boolean hasSameParameters(IParameterizedSymbol iParameterizedSymbol) {
        int n;
        if (iParameterizedSymbol.getType() != this.getType()) {
            return false;
        }
        int n2 = this.getParameterList() == null ? 0 : this.getParameterList().size();
        int n3 = n = iParameterizedSymbol.getParameterList() == null ? 0 : iParameterizedSymbol.getParameterList().size();
        if (n != n2) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        Iterator iterator = this.getParameterList().iterator();
        Iterator iterator2 = iParameterizedSymbol.getParameterList().iterator();
        TypeInfo typeInfo = null;
        TypeInfo typeInfo2 = null;
        int n4 = n2;
        while (n4 > 0) {
            typeInfo = ((BasicSymbol)iterator.next()).getTypeInfo();
            typeInfo2 = ((BasicSymbol)iterator2.next()).getTypeInfo();
            typeInfo = ParserSymbolTable.getFlatTypeInfo(typeInfo);
            typeInfo2 = ParserSymbolTable.getFlatTypeInfo(typeInfo2);
            TypeInfo typeInfo3 = typeInfo;
            while (typeInfo3 != null) {
                TypeInfo.PtrOp ptrOp;
                ListIterator<TypeInfo.PtrOp> listIterator = typeInfo3.getPtrOperators().listIterator();
                if (listIterator.hasNext() && (ptrOp = (TypeInfo.PtrOp)listIterator.next()).getType() == TypeInfo.PtrOp.t_array) {
                    listIterator.remove();
                    listIterator.add(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, ptrOp.isConst(), ptrOp.isVolatile()));
                }
                if (typeInfo3.isType(TypeInfo.t_type) && typeInfo3.getTypeSymbol().isType(TypeInfo.t_function) && typeInfo3.getPtrOperators().size() == 0) {
                    typeInfo3.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
                }
                if (typeInfo3.getPtrOperators().size() == 0) {
                    typeInfo3.setBit(false, 32768);
                    typeInfo3.setBit(false, 65536);
                } else {
                    ptrOp = (TypeInfo.PtrOp)typeInfo3.getPtrOperators().listIterator(typeInfo3.getPtrOperators().size()).previous();
                    ptrOp.setConst(false);
                    ptrOp.setVolatile(false);
                }
                if (typeInfo3 == typeInfo2) break;
                typeInfo3 = typeInfo2;
            }
            if (!typeInfo.equals(typeInfo2)) {
                return false;
            }
            --n4;
        }
        return true;
    }

    public void setReturnType(ISymbol iSymbol) {
        this._returnType = iSymbol;
    }

    public ISymbol getReturnType() {
        return this._returnType;
    }

    public void setHasVariableArgs(boolean bl) {
        this._hasVarArgs = bl;
    }

    public boolean hasVariableArgs() {
        return this._hasVarArgs;
    }

    private static class AddParameterCommand
    extends ParserSymbolTable.Command {
        private IParameterizedSymbol _decl;
        private ISymbol _param;

        public AddParameterCommand(IParameterizedSymbol iParameterizedSymbol, ISymbol iSymbol) {
            this._decl = iParameterizedSymbol;
            this._param = iSymbol;
        }

        public void undoIt() {
            this._decl.getParameterList().remove(this._param);
            String string = this._param.getName();
            if (string != null && !string.equals("")) {
                this._decl.getParameterMap().remove(string);
            }
        }
    }
}

