/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.MemoryActionSelectionGroup;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.texteditor.IUpdate;

public class MemoryFormatAction
extends Action
implements IUpdate {
    private MemoryActionSelectionGroup fGroup;
    private MemoryViewer fMemoryViewer;
    private int fFormat = 0;

    public MemoryFormatAction(MemoryActionSelectionGroup memoryActionSelectionGroup, MemoryViewer memoryViewer, int n) {
        super(MemoryFormatAction.getLabel(n), 2);
        this.fGroup = memoryActionSelectionGroup;
        this.fMemoryViewer = memoryViewer;
        this.fFormat = n;
    }

    public void update() {
        this.setEnabled(this.fMemoryViewer.canChangeFormat(this.fFormat));
        this.setChecked(this.fMemoryViewer.getCurrentFormat() == this.fFormat);
    }

    public void run() {
        try {
            this.fMemoryViewer.setFormat(this.fFormat);
            this.fGroup.setCurrentSelection((IAction)this);
        }
        catch (DebugException debugException) {
            CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.MemoryFormatAction.Unable_to_change_format"), debugException.getStatus());
            this.setChecked(false);
        }
    }

    private static String getLabel(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = CDebugUIPlugin.getResourceString("internal.ui.actions.MemoryFormatAction.Hexadecimal");
                break;
            }
            case 3: {
                string = CDebugUIPlugin.getResourceString("internal.ui.actions.MemoryFormatAction.Signed_Decimal");
                break;
            }
            case 4: {
                string = CDebugUIPlugin.getResourceString("internal.ui.actions.MemoryFormatAction.Unsigned_Decimal");
            }
        }
        return string;
    }

    public String getActionId() {
        return "MemoryFormat" + this.fFormat;
    }
}

