/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.MemoryActionSelectionGroup;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.texteditor.IUpdate;

public class MemorySizeAction
extends Action
implements IUpdate {
    private MemoryActionSelectionGroup fGroup;
    private MemoryViewer fMemoryViewer;
    private int fId = 0;

    public MemorySizeAction(MemoryActionSelectionGroup memoryActionSelectionGroup, MemoryViewer memoryViewer, int n) {
        super(MemorySizeAction.getLabel(n), 2);
        this.fGroup = memoryActionSelectionGroup;
        this.fMemoryViewer = memoryViewer;
        this.fId = n;
    }

    public void update() {
        this.setEnabled(this.fMemoryViewer.canUpdate());
        this.setChecked(this.fMemoryViewer.getCurrentWordSize() == this.fId);
    }

    private static String getLabel(int n) {
        String string = "";
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                string = CDebugUIPlugin.getFormattedString("internal.ui.actions.MemorySizeAction.byte_bytes", new Integer(n));
            }
        }
        return string;
    }

    public void run() {
        try {
            this.fMemoryViewer.setWordSize(this.fId);
            this.fGroup.setCurrentSelection((IAction)this);
        }
        catch (DebugException debugException) {
            CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("MemorySizeAction.Unable_to_change_memory_unit_size"), debugException.getStatus());
            this.setChecked(false);
        }
    }

    public String getActionId() {
        return "MemorySize" + this.fId;
    }
}

