/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.wizards;

import java.io.File;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationBlock;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.INewSourceLocationWizard;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AddDirectorySourceLocationWizard
extends Wizard
implements INewSourceLocationWizard {
    protected static final String PAGE_NAME = "AddDirectorySourceLocationWizardPage";
    protected IDirectorySourceLocation fSourceLocation = null;
    private IPath fInitialAssociationPath = null;

    public AddDirectorySourceLocationWizard() {
    }

    public AddDirectorySourceLocationWizard(IPath iPath) {
        this.fInitialAssociationPath = iPath;
    }

    public boolean performFinish() {
        AddDirtectorySourceLocationWizardPage addDirtectorySourceLocationWizardPage = (AddDirtectorySourceLocationWizardPage)this.getStartingPage();
        if (addDirtectorySourceLocationWizardPage != null) {
            return addDirtectorySourceLocationWizardPage.finish();
        }
        return false;
    }

    public String getDescription() {
        return CDebugUIPlugin.getResourceString("internal.ui.wizards.AddDirectorySourceLocationWizard.Description");
    }

    public void addPages() {
        this.addPage((IWizardPage)new AddDirtectorySourceLocationWizardPage(this, this.fInitialAssociationPath));
    }

    public ICSourceLocation getSourceLocation() {
        return this.fSourceLocation;
    }

    public class AddDirtectorySourceLocationWizardPage
    extends WizardPage {
        private AddDirectorySourceLocationBlock fAttachBlock;

        public AddDirtectorySourceLocationWizardPage(AddDirectorySourceLocationWizard addDirectorySourceLocationWizard2, IPath iPath) {
            super(AddDirectorySourceLocationWizard.PAGE_NAME, CDebugUIPlugin.getResourceString("internal.ui.wizards.AddDirectorySourceLocationWizard.Select_Directory"), CDebugImages.DESC_WIZBAN_ADD_DIR_SOURCE_LOCATION);
            AddDirectorySourceLocationWizard.this.setWindowTitle(CDebugUIPlugin.getResourceString("internal.ui.wizards.AddDirectorySourceLocationWizard.WindowTitle"));
            this.setMessage(CDebugUIPlugin.getResourceString("internal.ui.wizards.AddDirectorySourceLocationWizard.WindowMessage"));
            this.setWizard(addDirectorySourceLocationWizard2);
            this.fAttachBlock = new AddDirectorySourceLocationBlock(iPath);
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout());
            composite2.setLayoutData((Object)new GridData(768));
            this.fAttachBlock.createControl(composite2);
            this.fAttachBlock.addDirectoryModifyListener(new ModifyListener(this){
                final /* synthetic */ AddDirtectorySourceLocationWizardPage this$1;
                {
                    this.this$1 = addDirtectorySourceLocationWizardPage;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    this.this$1.directoryChanged();
                }
            });
            this.fAttachBlock.addAssociationModifyListener(new ModifyListener(this){
                final /* synthetic */ AddDirtectorySourceLocationWizardPage this$1;
                {
                    this.this$1 = addDirtectorySourceLocationWizardPage;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    this.this$1.associationChanged();
                }
            });
            this.setControl((Control)composite2);
            this.updateState();
        }

        protected void directoryChanged() {
            this.updateState();
        }

        protected void associationChanged() {
            this.updateState();
        }

        private void updateState() {
            boolean bl = true;
            this.setErrorMessage(null);
            String string = this.fAttachBlock.getLocationPath();
            if (string.length() == 0) {
                this.setErrorMessage(CDebugUIPlugin.getResourceString("internal.ui.wizards.AddDirectorySourceLocationWizard.ErrorDirectoryEmpty"));
                bl = false;
            } else {
                File file = new File(string);
                if (!file.exists() || !file.isDirectory()) {
                    this.setErrorMessage(CDebugUIPlugin.getResourceString("internal.ui.wizards.AddDirectorySourceLocationWizard.ErrorDirectoryDoesNotExist"));
                    bl = false;
                } else if (!file.isAbsolute()) {
                    this.setErrorMessage(CDebugUIPlugin.getResourceString("internal.ui.wizards.AddDirectorySourceLocationWizard.ErrorDirectoryMustBeAbsolute"));
                    bl = false;
                }
            }
            this.setPageComplete(bl);
        }

        private IDirectorySourceLocation getSourceLocation() {
            return this.fAttachBlock.getSourceLocation();
        }

        protected boolean finish() {
            AddDirectorySourceLocationWizard.this.fSourceLocation = this.getSourceLocation();
            return AddDirectorySourceLocationWizard.this.fSourceLocation != null;
        }
    }
}

