/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLocator;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.Separator;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceListDialogField;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SourceLookupBlock
implements Observer {
    private Composite fControl = null;
    private CheckedListDialogField fGeneratedSourceListField = this.createGeneratedSourceListField();
    private SourceListDialogField fAddedSourceListField = this.createAddedSourceListField();
    private SelectionButtonDialogField fSearchForDuplicateFiles = this.createSearchForDuplicateFilesButton();
    private ILaunchConfigurationDialog fLaunchConfigurationDialog = null;
    private boolean fIsDirty = false;
    private IProject fProject = null;
    static /* synthetic */ Class class$0;

    public void createControl(Composite composite) {
        this.fControl = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fControl.setLayout((Layout)gridLayout);
        this.fControl.setLayoutData((Object)new GridData(1808));
        this.fControl.setFont(JFaceResources.getDialogFont());
        PixelConverter pixelConverter = new PixelConverter((Control)this.fControl);
        this.fGeneratedSourceListField.doFillIntoGrid(this.fControl, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fGeneratedSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fGeneratedSourceListField.getLabelControl(null), pixelConverter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fGeneratedSourceListField.getListControl(null));
        ((CheckboxTableViewer)this.fGeneratedSourceListField.getTableViewer()).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (checkStateChangedEvent.getElement() instanceof IProjectSourceLocation) {
                    SourceLookupBlock.this.doCheckStateChanged();
                }
            }
        });
        new Separator().doFillIntoGrid(this.fControl, 3, pixelConverter.convertHeightInCharsToPixels(1));
        this.fAddedSourceListField.doFillIntoGrid(this.fControl, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fAddedSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fAddedSourceListField.getLabelControl(null), pixelConverter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fAddedSourceListField.getListControl(null));
        this.fSearchForDuplicateFiles.doFillIntoGrid(this.fControl, 3);
    }

    public Control getControl() {
        return this.fControl;
    }

    public void initialize(ILaunchConfiguration iLaunchConfiguration) {
        block5: {
            IProject iProject = this.getProjectFromLaunchConfiguration(iLaunchConfiguration);
            if (iProject != null) {
                this.setProject(iProject);
                try {
                    String string = iLaunchConfiguration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "");
                    if (!this.isEmpty(string) && !CDebugUIPlugin.getDefaultSourceLocatorID().equals(string) && !CDebugUIPlugin.getDefaultSourceLocatorOldID().equals(string)) break block5;
                    String string2 = iLaunchConfiguration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
                    if (!this.isEmpty(string2)) {
                        this.initializeFromMemento(string2);
                        break block5;
                    }
                    this.initializeDefaults();
                }
                catch (CoreException coreException) {
                    this.initializeDefaults();
                }
            } else {
                this.initializeGeneratedLocations(null, new ICSourceLocation[0]);
                this.resetAdditionalLocations(CDebugCorePlugin.getDefault().getCommonSourceLocations());
                this.fSearchForDuplicateFiles.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES));
            }
        }
    }

    private void initializeFromMemento(String string) throws CoreException {
        IPersistableSourceLocator iPersistableSourceLocator = CDebugUIPlugin.createDefaultSourceLocator();
        iPersistableSourceLocator.initializeFromMemento(string);
        if (iPersistableSourceLocator instanceof IAdaptable) {
            ICSourceLocator iCSourceLocator;
            IAdaptable iAdaptable = (IAdaptable)iPersistableSourceLocator;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iCSourceLocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.initializeFromLocator(iCSourceLocator);
            }
        }
    }

    private void initializeDefaults() {
        this.fGeneratedSourceListField.removeAllElements();
        IProject iProject = this.getProject();
        if (iProject != null && iProject.exists() && iProject.isOpen()) {
            IProjectSourceLocation iProjectSourceLocation = SourceLookupFactory.createProjectSourceLocation((IProject)iProject, (boolean)true);
            this.fGeneratedSourceListField.addElement(iProjectSourceLocation);
            this.fGeneratedSourceListField.setChecked(iProjectSourceLocation, true);
            List list = CDebugUtils.getReferencedProjects((IProject)iProject);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                iProjectSourceLocation = SourceLookupFactory.createProjectSourceLocation((IProject)((IProject)iterator.next()), (boolean)true);
                this.fGeneratedSourceListField.addElement(iProjectSourceLocation);
                this.fGeneratedSourceListField.setChecked(iProjectSourceLocation, true);
            }
        }
        this.resetAdditionalLocations(CDebugCorePlugin.getDefault().getCommonSourceLocations());
        this.fSearchForDuplicateFiles.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES));
    }

    private void initializeFromLocator(ICSourceLocator iCSourceLocator) {
        ICSourceLocation[] iCSourceLocationArray = iCSourceLocator.getSourceLocations();
        this.initializeGeneratedLocations(iCSourceLocator.getProject(), iCSourceLocationArray);
        this.resetAdditionalLocations(iCSourceLocationArray);
        this.fSearchForDuplicateFiles.setSelection(iCSourceLocator.searchForDuplicateFiles());
    }

    private void initializeGeneratedLocations(IProject iProject, ICSourceLocation[] iCSourceLocationArray) {
        boolean bl;
        this.fGeneratedSourceListField.removeAllElements();
        if (iProject == null || !iProject.exists() || !iProject.isOpen()) {
            return;
        }
        List list = CDebugUtils.getReferencedProjects((IProject)iProject);
        IProject[] iProjectArray = list.toArray(new IProject[list.size()]);
        ICSourceLocation iCSourceLocation = this.getLocationForProject(iProject, iCSourceLocationArray);
        boolean bl2 = bl = iCSourceLocation != null && ((IProjectSourceLocation)iCSourceLocation).isGeneric();
        if (iCSourceLocation == null) {
            iCSourceLocation = SourceLookupFactory.createProjectSourceLocation((IProject)iProject, (boolean)true);
        }
        this.fGeneratedSourceListField.addElement(iCSourceLocation);
        this.fGeneratedSourceListField.setChecked(iCSourceLocation, bl);
        int n = 0;
        while (n < iProjectArray.length) {
            iCSourceLocation = this.getLocationForProject(iProjectArray[n], iCSourceLocationArray);
            boolean bl3 = bl = iCSourceLocation != null;
            if (iCSourceLocation == null) {
                iCSourceLocation = SourceLookupFactory.createProjectSourceLocation((IProject)iProjectArray[n], (boolean)true);
            }
            this.fGeneratedSourceListField.addElement(iCSourceLocation);
            this.fGeneratedSourceListField.setChecked(iCSourceLocation, bl);
            ++n;
        }
    }

    private void resetGeneratedLocations(ICSourceLocation[] iCSourceLocationArray) {
        this.fGeneratedSourceListField.checkAll(false);
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            if (iCSourceLocationArray[n] instanceof IProjectSourceLocation && ((IProjectSourceLocation)iCSourceLocationArray[n]).isGeneric()) {
                this.fGeneratedSourceListField.setChecked(iCSourceLocationArray[n], true);
            }
            ++n;
        }
    }

    private void resetAdditionalLocations(ICSourceLocation[] iCSourceLocationArray) {
        this.fAddedSourceListField.removeAllElements();
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            if (!(iCSourceLocationArray[n] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)iCSourceLocationArray[n]).isGeneric()) {
                this.fAddedSourceListField.addElement(iCSourceLocationArray[n]);
            }
            ++n;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IPersistableSourceLocator iPersistableSourceLocator = CDebugUIPlugin.createDefaultSourceLocator();
        try {
            iPersistableSourceLocator.initializeDefaults((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
            if (iPersistableSourceLocator instanceof IAdaptable) {
                ICSourceLocator iCSourceLocator;
                IAdaptable iAdaptable = (IAdaptable)iPersistableSourceLocator;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iCSourceLocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz)) != null && this.getProject() != null && this.getProject().equals((Object)this.getProjectFromLaunchConfiguration((ILaunchConfiguration)iLaunchConfigurationWorkingCopy))) {
                    iCSourceLocator.setSourceLocations(this.getSourceLocations());
                    iCSourceLocator.setSearchForDuplicateFiles(this.searchForDuplicateFiles());
                }
            }
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, iPersistableSourceLocator.getMemento());
        }
        catch (CoreException coreException) {}
    }

    protected void doCheckStateChanged() {
        this.fIsDirty = true;
        this.updateLaunchConfigurationDialog();
    }

    protected void doGeneratedSourceButtonPressed(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.fIsDirty = true;
            }
        }
        if (this.isDirty()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void doGeneratedSourceSelectionChanged() {
    }

    protected void doAddedSourceButtonPressed(int n) {
        switch (n) {
            case 0: {
                if (!this.addSourceLocation()) break;
                this.fIsDirty = true;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.fIsDirty = true;
            }
        }
        if (this.isDirty()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public ICSourceLocation[] getSourceLocations() {
        ArrayList<IProjectSourceLocation> arrayList = new ArrayList<IProjectSourceLocation>(this.getGeneratedSourceListField().getElements().size() + this.getAddedSourceListField().getElements().size());
        Iterator iterator = this.getGeneratedSourceListField().getElements().iterator();
        while (iterator.hasNext()) {
            IProjectSourceLocation iProjectSourceLocation = (IProjectSourceLocation)iterator.next();
            if (!this.getGeneratedSourceListField().isChecked(iProjectSourceLocation)) continue;
            arrayList.add(iProjectSourceLocation);
        }
        arrayList.addAll(this.getAddedSourceListField().getElements());
        return arrayList.toArray(new ICSourceLocation[arrayList.size()]);
    }

    private boolean addSourceLocation() {
        AddSourceLocationWizard addSourceLocationWizard = new AddSourceLocationWizard(this.getSourceLocations());
        WizardDialog wizardDialog = new WizardDialog(this.fControl.getShell(), (IWizard)addSourceLocationWizard);
        if (wizardDialog.open() == 0) {
            this.fAddedSourceListField.addElement(addSourceLocationWizard.getSourceLocation());
            return true;
        }
        return false;
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            this.getLaunchConfigurationDialog().updateMessage();
            this.getLaunchConfigurationDialog().updateButtons();
            this.fIsDirty = false;
        }
    }

    public ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fLaunchConfigurationDialog;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog iLaunchConfigurationDialog) {
        this.fLaunchConfigurationDialog = iLaunchConfigurationDialog;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    protected Object getSelection() {
        List list = this.fAddedSourceListField.getSelectedElements();
        return list.size() > 0 ? list.get(0) : null;
    }

    protected void restoreDefaults() {
        ICSourceLocation[] iCSourceLocationArray = new ICSourceLocation[]{};
        if (this.getProject() != null) {
            iCSourceLocationArray = CSourceLocator.getDefaultSourceLocations((IProject)this.getProject());
        }
        this.resetGeneratedLocations(iCSourceLocationArray);
        this.resetAdditionalLocations(iCSourceLocationArray);
        this.fSearchForDuplicateFiles.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SEARCH_DUPLICATE_FILES));
    }

    public IProject getProject() {
        return this.fProject;
    }

    private void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    public SourceListDialogField getAddedSourceListField() {
        return this.fAddedSourceListField;
    }

    public CheckedListDialogField getGeneratedSourceListField() {
        return this.fGeneratedSourceListField;
    }

    private ICSourceLocation getLocationForProject(IProject iProject, ICSourceLocation[] iCSourceLocationArray) {
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            if (iCSourceLocationArray[n] instanceof IProjectSourceLocation && iProject.equals((Object)((IProjectSourceLocation)iCSourceLocationArray[n]).getProject())) {
                return iCSourceLocationArray[n];
            }
            ++n;
        }
        return null;
    }

    public boolean searchForDuplicateFiles() {
        return this.fSearchForDuplicateFiles != null ? this.fSearchForDuplicateFiles.isSelected() : false;
    }

    private CheckedListDialogField createGeneratedSourceListField() {
        String[] stringArray = new String[]{CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceLookupBlock.Select_All"), CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceLookupBlock.Deselect_All")};
        IListAdapter iListAdapter = new IListAdapter(){

            public void customButtonPressed(DialogField dialogField, int n) {
                SourceLookupBlock.this.doGeneratedSourceButtonPressed(n);
            }

            public void selectionChanged(DialogField dialogField) {
                SourceLookupBlock.this.doGeneratedSourceSelectionChanged();
            }
        };
        CheckedListDialogField checkedListDialogField = new CheckedListDialogField(iListAdapter, stringArray, (ILabelProvider)new SourceLookupLabelProvider());
        checkedListDialogField.setLabelText(CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceLookupBlock.Generic_Source_Locations"));
        checkedListDialogField.setCheckAllButtonIndex(0);
        checkedListDialogField.setUncheckAllButtonIndex(1);
        checkedListDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                SourceLookupBlock.this.doCheckStateChanged();
            }
        });
        return checkedListDialogField;
    }

    private SourceListDialogField createAddedSourceListField() {
        SourceListDialogField sourceListDialogField = new SourceListDialogField(CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceLookupBlock.Additional_Source_Locations"), new IListAdapter(){

            public void customButtonPressed(DialogField dialogField, int n) {
                SourceLookupBlock.this.doAddedSourceButtonPressed(n);
            }

            public void selectionChanged(DialogField dialogField) {
            }
        });
        sourceListDialogField.addObserver(this);
        return sourceListDialogField;
    }

    private SelectionButtonDialogField createSearchForDuplicateFilesButton() {
        SelectionButtonDialogField selectionButtonDialogField = new SelectionButtonDialogField(32);
        selectionButtonDialogField.setLabelText(CDebugUIPlugin.getResourceString("ui.sourcelookup.SourceLookupBlock.Search_for_dup_src_files"));
        selectionButtonDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                SourceLookupBlock.this.doCheckStateChanged();
            }
        });
        return selectionButtonDialogField;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && (Integer)object == 0) {
            if (this.addSourceLocation()) {
                this.fIsDirty = true;
            }
        } else {
            this.fIsDirty = true;
        }
        if (this.fIsDirty) {
            this.updateLaunchConfigurationDialog();
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public void dispose() {
        if (this.getAddedSourceListField() != null) {
            this.getAddedSourceListField().deleteObserver(this);
            this.getAddedSourceListField().dispose();
        }
    }

    private IProject getProjectFromLaunchConfiguration(ILaunchConfiguration iLaunchConfiguration) {
        try {
            IProject iProject;
            String string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (!this.isEmpty(string) && (iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string)) != null && iProject.exists() && iProject.isOpen()) {
                return iProject;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

