/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.internal.core.model.CArrayPartitionValue;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class CArrayPartition
extends CVariable {
    protected static final int SLOT_SIZE = 100;
    private int fStart;
    private int fEnd;
    private ICDIVariableObject fCDIVariableObject;
    private ICDIVariable fCDIVariable;
    private ICType fType = null;
    private String fQualifiedName = null;
    private CArrayPartitionValue fArrayPartitionValue = null;

    public CArrayPartition(CDebugElement cDebugElement, ICDIVariable iCDIVariable, int n, int n2) {
        super(cDebugElement, null);
        this.fStart = n;
        this.fEnd = n2;
        this.fCDIVariable = iCDIVariable;
    }

    protected ICDIValue retrieveValue() throws DebugException, CDIException {
        return null;
    }

    public String getName() throws DebugException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(this.fStart);
        stringBuffer.append("..");
        stringBuffer.append(this.fEnd);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public void handleDebugEvent(ICDIEvent iCDIEvent) {
    }

    public IValue getValue() throws DebugException {
        if (this.fArrayPartitionValue == null) {
            this.fArrayPartitionValue = new CArrayPartitionValue(this, this.fCDIVariable, this.getStart(), this.getEnd());
        }
        return this.fArrayPartitionValue;
    }

    public static List splitArray(CDebugElement cDebugElement, ICDIVariable iCDIVariable, int n, int n2) throws DebugException {
        ArrayList<CVariable> arrayList;
        block8: {
            arrayList = new ArrayList<CVariable>();
            int n3 = n2 - n + 1;
            int n4 = 1;
            while (n3 > n4 * 100) {
                n4 *= 100;
            }
            if (n4 == 1) {
                try {
                    ICDIValue iCDIValue = iCDIVariable.getValue();
                    if (!(iCDIValue instanceof ICDIArrayValue)) break block8;
                    ICDIVariable[] iCDIVariableArray = ((ICDIArrayValue)iCDIValue).getVariables(n, n3);
                    int n5 = 0;
                    while (n5 < iCDIVariableArray.length) {
                        arrayList.add(new CModificationVariable(cDebugElement, iCDIVariableArray[n5]));
                        ++n5;
                    }
                }
                catch (CDIException cDIException) {
                    arrayList.add(new CModificationVariable(cDebugElement, new CVariable.ErrorVariable(null, cDIException)));
                }
            } else {
                int n6 = n;
                while (n6 <= n2) {
                    if (n6 + n4 > n2) {
                        n4 = n2 - n6 + 1;
                    }
                    arrayList.add(new CArrayPartition(cDebugElement, iCDIVariable, n6, n6 + n4 - 1));
                    n6 += n4;
                }
            }
        }
        return arrayList;
    }

    protected int getStart() {
        return this.fStart;
    }

    protected int getEnd() {
        return this.fEnd;
    }

    public boolean canEnableDisable() {
        return false;
    }

    public ICType getType() throws DebugException {
        if (this.fType == null) {
            try {
                ICDIVariableObject iCDIVariableObject = this.getVariableObject();
                if (iCDIVariableObject != null) {
                    this.fType = new CType(iCDIVariableObject.getType());
                }
            }
            catch (CDIException cDIException) {
                this.requestFailed("Type is not available.", cDIException);
            }
        }
        return this.fType;
    }

    public boolean hasChildren() {
        return true;
    }

    protected String getQualifiedName() throws DebugException {
        if (this.fQualifiedName == null) {
            try {
                if (this.getVariableObject() != null) {
                    this.fQualifiedName = this.getVariableObject().getQualifiedName();
                }
            }
            catch (CDIException cDIException) {
                this.requestFailed("Qualified name is not available.", cDIException);
            }
        }
        return this.fQualifiedName;
    }

    private ICDIVariableObject getVariableObject() throws CDIException {
        if (this.fCDIVariableObject == null) {
            this.fCDIVariableObject = this.getCDISession().getVariableManager().getVariableObjectAsArray(this.fCDIVariable, this.getStart(), this.getEnd() - this.getStart() + 1);
        }
        return this.fCDIVariableObject;
    }
}

