/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;

public class CExpression
extends CModificationVariable
implements IExpression {
    public CExpression(CDebugTarget cDebugTarget, ICDIExpression iCDIExpression) {
        super(cDebugTarget, iCDIExpression);
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT);
    }

    public CExpression(CDebugTarget cDebugTarget, ICDIVariableObject iCDIVariableObject) {
        super(cDebugTarget, iCDIVariableObject);
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT);
    }

    public String getExpressionText() {
        try {
            return this.getName();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public IValue getValue() {
        try {
            return super.getValue();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected ICDIExpression getCDIExpression() throws CDIException {
        return (ICDIExpression)this.getCDIVariable();
    }

    public void handleDebugEvent(ICDIEvent iCDIEvent) {
        if (iCDIEvent instanceof ICDIResumedEvent && iCDIEvent.getSource() instanceof ICDITarget && this.getCDITarget().equals(iCDIEvent.getSource())) {
            try {
                this.setChanged(false);
            }
            catch (DebugException debugException) {
                CDebugCorePlugin.log(debugException);
            }
        }
        super.handleDebugEvent(iCDIEvent);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean canEnableDisable() {
        return false;
    }
}

