/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.ISourceMode;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;

public class CSourceManager
implements ICSourceLocator,
IPersistableSourceLocator,
ISourceMode,
IAdaptable {
    private ISourceLocator fSourceLocator = null;
    private int fMode;
    private int fRealMode = this.fMode = 0;
    private ILaunch fLaunch = null;
    private CDebugTarget fDebugTarget = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public CSourceManager(ISourceLocator iSourceLocator) {
        this.setSourceLocator(iSourceLocator);
    }

    public int getLineNumber(IStackFrame iStackFrame) {
        if (this.getRealMode() == 0) {
            IStackFrameInfo iStackFrameInfo;
            if (this.getCSourceLocator() != null) {
                return this.getCSourceLocator().getLineNumber(iStackFrame);
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iStackFrameInfo = (IStackFrameInfo)iStackFrame.getAdapter((Class)clazz)) != null) {
                return iStackFrameInfo.getFrameLineNumber();
            }
        }
        if (this.getRealMode() == 1 && this.getDisassemblyManager(iStackFrame) != null) {
            return this.getDisassemblyManager(iStackFrame).getLineNumber(iStackFrame);
        }
        return 0;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().getSourceLocations() : new ICSourceLocation[]{};
    }

    public void setSourceLocations(ICSourceLocation[] iCSourceLocationArray) {
        if (this.getCSourceLocator() != null) {
            this.getCSourceLocator().setSourceLocations(iCSourceLocationArray);
        }
    }

    public boolean contains(IResource iResource) {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().contains(iResource) : false;
    }

    public int getMode() {
        return this.fMode;
    }

    public void setMode(int n) {
        this.fMode = n;
        this.setRealMode(n);
    }

    public int getRealMode() {
        return this.fRealMode;
    }

    protected void setRealMode(int n) {
        this.fRealMode = n;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ISourceMode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz4)) {
            return this;
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.debug.core.model.IPersistableSourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz5)) {
            return this;
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz6) && this.fSourceLocator instanceof IResourceChangeListener) {
            return this.fSourceLocator;
        }
        return null;
    }

    public Object getSourceElement(IStackFrame iStackFrame) {
        Object object = null;
        boolean bl = CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_AUTO_DISASSEMBLY);
        if (this.getMode() == 0 && this.getSourceLocator() != null) {
            object = this.getSourceLocator().getSourceElement(iStackFrame);
        }
        if (object == null && (bl || this.getMode() == 1) && this.getDisassemblyManager(iStackFrame) != null) {
            this.setRealMode(1);
            object = this.getDisassemblyManager(iStackFrame).getSourceElement(iStackFrame);
        } else {
            this.setRealMode(0);
        }
        return object;
    }

    protected ICSourceLocator getCSourceLocator() {
        if (this.getSourceLocator() instanceof ICSourceLocator) {
            return (ICSourceLocator)this.getSourceLocator();
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        if (this.fSourceLocator != null) {
            return this.fSourceLocator;
        }
        if (this.fLaunch != null) {
            return this.fLaunch.getSourceLocator();
        }
        return null;
    }

    protected void setSourceLocator(ISourceLocator iSourceLocator) {
        this.fSourceLocator = iSourceLocator;
    }

    protected DisassemblyManager getDisassemblyManager(IStackFrame iStackFrame) {
        if (iStackFrame != null) {
            IDebugTarget iDebugTarget = iStackFrame.getDebugTarget();
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (DisassemblyManager)iDebugTarget.getAdapter((Class)clazz);
        }
        return null;
    }

    public void addSourceLocation(ICSourceLocation iCSourceLocation) {
        ICSourceLocation[] iCSourceLocationArray = this.getSourceLocations();
        ArrayList<ICSourceLocation> arrayList = new ArrayList<ICSourceLocation>(Arrays.asList(iCSourceLocationArray));
        arrayList.add(iCSourceLocation);
        this.setSourceLocations(arrayList.toArray(new ICSourceLocation[arrayList.size()]));
    }

    public Object findSourceElement(String string) {
        if (this.getCSourceLocator() != null) {
            return this.getCSourceLocator().findSourceElement(string);
        }
        return null;
    }

    public String getMemento() throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            return this.getPersistableSourceLocator().getMemento();
        }
        return null;
    }

    public void initializeDefaults(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            this.getPersistableSourceLocator().initializeDefaults(iLaunchConfiguration);
        }
    }

    public void initializeFromMemento(String string) throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            this.getPersistableSourceLocator().initializeFromMemento(string);
        }
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        if (this.fSourceLocator instanceof IPersistableSourceLocator) {
            return (IPersistableSourceLocator)this.fSourceLocator;
        }
        return null;
    }

    public IProject getProject() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().getProject() : null;
    }

    public void setDebugTarget(CDebugTarget cDebugTarget) {
        this.fDebugTarget = cDebugTarget;
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void setSearchForDuplicateFiles(boolean bl) {
        if (this.getCSourceLocator() != null) {
            this.getCSourceLocator().setSearchForDuplicateFiles(bl);
        }
    }

    public boolean searchForDuplicateFiles() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().searchForDuplicateFiles() : false;
    }
}

