/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.drag;

import java.util.Arrays;
import org.eclipse.cdt.internal.ui.drag.TransferDragSourceListener;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;

public class DelegatingDragAdapter
implements DragSourceListener {
    private final ISelectionProvider provider;
    private final TransferDragSourceListener[] listeners;
    private final boolean[] actives;
    private TransferDragSourceListener selected;

    public DelegatingDragAdapter(ISelectionProvider iSelectionProvider, TransferDragSourceListener[] transferDragSourceListenerArray) {
        Assert.isNotNull((Object)iSelectionProvider);
        Assert.isNotNull((Object)transferDragSourceListenerArray);
        this.provider = iSelectionProvider;
        this.listeners = transferDragSourceListenerArray;
        this.actives = new boolean[transferDragSourceListenerArray.length];
        this.selected = null;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        this.selected = null;
        if (this.provider.getSelection().isEmpty()) {
            dragSourceEvent.doit = false;
            return;
        }
        DragSource dragSource = (DragSource)dragSourceEvent.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            dragSourceEvent.doit = false;
            return;
        }
        Object object = dragSourceEvent.data;
        boolean bl = dragSourceEvent.doit;
        int n = this.listeners.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            TransferDragSourceListener transferDragSourceListener = this.listeners[n3];
            dragSourceEvent.data = object;
            dragSourceEvent.doit = bl;
            transferDragSourceListener.dragStart(dragSourceEvent);
            this.actives[n3] = dragSourceEvent.doit;
            if (this.actives[n3]) {
                ++n2;
            }
            ++n3;
        }
        dragSourceEvent.data = object;
        dragSourceEvent.doit = n2 != 0;
        if (dragSourceEvent.doit) {
            Transfer[] transferArray = new Transfer[n2];
            int n4 = n;
            while (--n4 >= 0) {
                if (!this.actives[n4]) continue;
                transferArray[--n2] = this.listeners[n4].getTransfer();
            }
            dragSource.setTransfer(transferArray);
        }
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        this.selected = this.getListener(dragSourceEvent.dataType);
        if (this.selected != null) {
            this.selected.dragSetData(dragSourceEvent);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dragFinished(DragSourceEvent dragSourceEvent) {
        try {
            if (this.selected == null) {
                this.selected = this.getListener(dragSourceEvent.dataType);
            }
            if (this.selected != null) {
                this.selected.dragFinished(dragSourceEvent);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Arrays.fill(this.actives, false);
            this.selected = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        Arrays.fill(this.actives, false);
        this.selected = null;
    }

    private TransferDragSourceListener getListener(TransferData transferData) {
        if (transferData != null) {
            int n = 0;
            while (n < this.actives.length) {
                TransferDragSourceListener transferDragSourceListener;
                if (this.actives[n] && (transferDragSourceListener = this.listeners[n]).getTransfer().isSupportedType(transferData)) {
                    return transferDragSourceListener;
                }
                ++n;
            }
        }
        return null;
    }
}

