/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplateTranslator;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class EditTemplateDialog
extends StatusDialog {
    private final Template fTemplate;
    protected Text fNameText;
    private Text fDescriptionText;
    protected Combo fContextCombo;
    protected SourceViewer fPatternEditor;
    private Button fInsertVariableButton;
    protected TemplateTranslator fTranslator = new TemplateTranslator();
    protected boolean fSuppressError = true;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    private Vector fContextTypes = new Vector();
    protected final TemplateVariableProcessor fProcessor = new TemplateVariableProcessor();

    public EditTemplateDialog(Shell shell, Template template, boolean bl) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String string = bl ? TemplateMessages.getString("EditTemplateDialog.title.edit") : TemplateMessages.getString("EditTemplateDialog.title.new");
        this.setTitle(string);
        this.fTemplate = template;
        ContextTypeRegistry contextTypeRegistry = ContextTypeRegistry.getInstance();
        Iterator iterator = contextTypeRegistry.iterator();
        while (iterator.hasNext()) {
            this.fContextTypes.add(iterator.next());
        }
        if (this.fContextTypes.size() > 0) {
            this.fProcessor.setContextType(ContextTypeRegistry.getInstance().getContextType((String)this.fContextTypes.get(0)));
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        EditTemplateDialog.createLabel(composite2, TemplateMessages.getString("EditTemplateDialog.name"));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        this.fNameText = EditTemplateDialog.createText(composite3);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (EditTemplateDialog.this.fSuppressError && EditTemplateDialog.this.fNameText.getText().trim().length() != 0) {
                    EditTemplateDialog.this.fSuppressError = false;
                }
                EditTemplateDialog.this.updateButtons();
            }
        });
        EditTemplateDialog.createLabel(composite3, TemplateMessages.getString("EditTemplateDialog.context"));
        this.fContextCombo = new Combo(composite3, 8);
        Label label = ((AbstractList)this.fContextTypes).iterator();
        while (label.hasNext()) {
            this.fContextCombo.add((String)label.next());
        }
        this.fContextCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = EditTemplateDialog.this.fContextCombo.getText();
                EditTemplateDialog.this.fProcessor.setContextType(ContextTypeRegistry.getInstance().getContextType(string));
            }
        });
        EditTemplateDialog.createLabel(composite2, TemplateMessages.getString("EditTemplateDialog.description"));
        this.fDescriptionText = EditTemplateDialog.createText(composite2);
        composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(1040));
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        EditTemplateDialog.createLabel(composite3, TemplateMessages.getString("EditTemplateDialog.pattern"));
        this.fPatternEditor = this.createEditor(composite2);
        label = new Label(composite3, 0);
        label.setLayoutData((Object)new GridData(1040));
        this.fInsertVariableButton = new Button(composite3, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData(this.fInsertVariableButton));
        this.fInsertVariableButton.setText(TemplateMessages.getString("EditTemplateDialog.insert.variable"));
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fNameText.setText(this.fTemplate.getName());
        this.fDescriptionText.setText(this.fTemplate.getDescription());
        this.fContextCombo.select(this.getIndex(this.fTemplate.getContextTypeName()));
        this.initializeActions();
        return composite3;
    }

    private static GridData getButtonGridData(Button button) {
        GridData gridData = new GridData(768);
        gridData.heightHint = SWTUtil.getButtonHeigthHint(button);
        return gridData;
    }

    private static Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite composite) {
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private SourceViewer createEditor(Composite composite) {
        SourceViewer sourceViewer = new SourceViewer(composite, null, 2816);
        CTextTools cTextTools = CUIPlugin.getDefault().getTextTools();
        sourceViewer.configure((SourceViewerConfiguration)new SimpleCSourceViewerConfiguration(cTextTools, null, this.fProcessor));
        sourceViewer.setEditable(true);
        sourceViewer.setDocument((IDocument)new Document(this.fTemplate.getPattern()));
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        sourceViewer.getTextWidget().setFont(font);
        Control control = sourceViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData);
        sourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent textEvent) {
                try {
                    EditTemplateDialog.this.fTranslator.translate(textEvent.getDocumentEvent().getDocument().get());
                }
                catch (CoreException coreException) {
                    CUIPlugin.getDefault().log(coreException);
                }
                EditTemplateDialog.this.updateUndoAction();
                EditTemplateDialog.this.updateButtons();
            }
        });
        sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener(new VerifyKeyListener(){

                public void verifyKey(VerifyEvent verifyEvent) {
                    EditTemplateDialog.this.handleVerifyKeyPressed(verifyEvent);
                }
            });
        } else {
            sourceViewer.getTextWidget().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    EditTemplateDialog.this.handleKeyPressed(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            });
        }
        return sourceViewer;
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.stateMask != 262144) {
            return;
        }
        switch (keyEvent.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
            }
        }
    }

    protected void handleVerifyKeyPressed(VerifyEvent verifyEvent) {
        if (!verifyEvent.doit) {
            return;
        }
        if (verifyEvent.stateMask != 262144) {
            return;
        }
        switch (verifyEvent.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                verifyEvent.doit = false;
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
                verifyEvent.doit = false;
            }
        }
    }

    private void initializeActions() {
        TextViewerAction textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        textViewerAction.setText(TemplateMessages.getString("EditTemplateDialog.undo"));
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        textViewerAction.setText(TemplateMessages.getString("EditTemplateDialog.cut"));
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        textViewerAction.setText(TemplateMessages.getString("EditTemplateDialog.copy"));
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        textViewerAction.setText(TemplateMessages.getString("EditTemplateDialog.paste"));
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        textViewerAction.setText(TemplateMessages.getString("EditTemplateDialog.select.all"));
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 13);
        textViewerAction.setText(TemplateMessages.getString("EditTemplateDialog.content.assist"));
        this.fGlobalActions.put("ContentAssistProposal", textViewerAction);
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager menuManager = new MenuManager(null, null);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                EditTemplateDialog.this.fillContextMenu(iMenuManager);
            }
        });
        StyledText styledText = this.fPatternEditor.getTextWidget();
        Menu menu = menuManager.createContextMenu((Control)styledText);
        styledText.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new GroupMarker("group.undo"));
        iMenuManager.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        iMenuManager.add((IContributionItem)new Separator("group.edit"));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        iMenuManager.add((IContributionItem)new Separator("group.generate"));
        iMenuManager.appendToGroup("group.generate", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateUndoAction() {
        IAction iAction = (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    protected void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    private int getIndex(String string) {
        ContextTypeRegistry contextTypeRegistry = ContextTypeRegistry.getInstance();
        contextTypeRegistry.getContextType(string);
        if (string == null) {
            return -1;
        }
        return this.fContextTypes.indexOf(string);
    }

    protected void okPressed() {
        this.fTemplate.setName(this.fNameText.getText());
        this.fTemplate.setDescription(this.fDescriptionText.getText());
        this.fTemplate.setContext(this.fContextCombo.getText());
        this.fTemplate.setPattern(this.fPatternEditor.getTextWidget().getText());
        super.okPressed();
    }

    protected void updateButtons() {
        boolean bl = this.fNameText.getText().trim().length() != 0;
        StatusInfo statusInfo = new StatusInfo();
        if (!bl) {
            if (this.fSuppressError) {
                statusInfo.setError("");
            } else {
                statusInfo.setError(TemplateMessages.getString("EditTemplateDialog.error.noname"));
            }
        } else if (this.fTranslator.getErrorMessage() != null) {
            statusInfo.setError(this.fTranslator.getErrorMessage());
        }
        this.updateStatus(statusInfo);
    }

    private static class SimpleCSourceViewerConfiguration
    extends CSourceViewerConfiguration {
        private final IContentAssistProcessor fProcessor;

        SimpleCSourceViewerConfiguration(CTextTools cTextTools, CEditor cEditor, IContentAssistProcessor iContentAssistProcessor) {
            super(cTextTools, cEditor);
            this.fProcessor = iContentAssistProcessor;
        }

        public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
            IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
            ContentAssistant contentAssistant = new ContentAssistant();
            contentAssistant.setContentAssistProcessor(this.fProcessor, "__dftl_partition_content_type");
            boolean bl = iPreferenceStore.getBoolean("content_assist_autoactivation_trigger_dot") || iPreferenceStore.getBoolean("content_assist_autoactivation_trigger_arrow") || iPreferenceStore.getBoolean("content_assist_autoactivation_trigger_doublecolon");
            contentAssistant.enableAutoActivation(bl);
            contentAssistant.setAutoActivationDelay(iPreferenceStore.getInt("content_assist_autoactivation_delay"));
            contentAssistant.setProposalPopupOrientation(10);
            contentAssistant.setContextInformationPopupOrientation(20);
            Display display = iSourceViewer.getTextWidget().getDisplay();
            Color color = this.createColor(iPreferenceStore, "content_assist_proposals_background", display);
            contentAssistant.setContextInformationPopupBackground(color);
            contentAssistant.setContextSelectorBackground(color);
            contentAssistant.setProposalSelectorBackground(color);
            Color color2 = this.createColor(iPreferenceStore, "content_assist_proposals_foreground", display);
            contentAssistant.setContextInformationPopupForeground(color2);
            contentAssistant.setContextSelectorForeground(color2);
            contentAssistant.setProposalSelectorForeground(color2);
            return contentAssistant;
        }

        private Color createColor(IPreferenceStore iPreferenceStore, String string, Display display) {
            RGB rGB = null;
            if (iPreferenceStore.contains(string) && (rGB = iPreferenceStore.isDefault(string) ? PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string) : PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string)) != null) {
                return new Color((Device)display, rGB);
            }
            return null;
        }
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer iTextViewer, int n) {
            this.fOperationCode = n;
            this.fOperationTarget = iTextViewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean bl = this.isEnabled();
            boolean bl2 = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(bl2);
            if (bl != bl2) {
                this.firePropertyChange("enabled", bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

