/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplateSet;
import org.eclipse.cdt.internal.corext.template.Templates;
import org.eclipse.cdt.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.template.TemplateContentProvider;
import org.eclipse.cdt.internal.ui.text.template.TemplateLabelProvider;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_FORMAT_TEMPLATES = "org.eclipse.cdt.ui.template.format";
    private Templates fTemplates;
    private CheckboxTableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fImportButton;
    private Button fExportButton;
    private Button fExportAllButton;
    private Button fRemoveButton;
    private Button fEnableAllButton;
    private Button fDisableAllButton;
    private SourceViewer fPatternViewer;

    public TemplatePreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(TemplateMessages.getString("TemplatePreferencePage.message"));
        this.fTemplates = Templates.getInstance();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Table table = new Table(composite2, 67618);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(TemplateMessages.getString("TemplatePreferencePage.column.name"));
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText(TemplateMessages.getString("TemplatePreferencePage.column.context"));
        TableColumn tableColumn3 = new TableColumn(table, 0);
        tableColumn3.setText(TemplateMessages.getString("TemplatePreferencePage.column.description"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof Template && object2 instanceof Template) {
                    Template template = (Template)object;
                    Template template2 = (Template)object2;
                    int n = template.getName().compareToIgnoreCase(template2.getName());
                    if (n != 0) {
                        return n;
                    }
                    return template.getDescription().compareToIgnoreCase(template2.getDescription());
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                TemplatePreferencePage.this.edit();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TemplatePreferencePage.this.selectionChanged1();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Template template = (Template)checkStateChangedEvent.getElement();
                template.setEnabled(checkStateChangedEvent.getChecked());
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.fAddButton = new Button(composite3, 8);
        this.fAddButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fAddButton));
        this.fAddButton.setText(TemplateMessages.getString("TemplatePreferencePage.new"));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplatePreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(composite3, 8);
        this.fEditButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fEditButton));
        this.fEditButton.setText(TemplateMessages.getString("TemplatePreferencePage.edit"));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplatePreferencePage.this.edit();
            }
        });
        this.fRemoveButton = new Button(composite3, 8);
        this.fRemoveButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fRemoveButton));
        this.fRemoveButton.setText(TemplateMessages.getString("TemplatePreferencePage.remove"));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplatePreferencePage.this.remove();
            }
        });
        this.createSpacer(composite3);
        this.fImportButton = new Button(composite3, 8);
        this.fImportButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fImportButton));
        this.fImportButton.setText(TemplateMessages.getString("TemplatePreferencePage.import"));
        this.fImportButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplatePreferencePage.this.import_();
            }
        });
        this.fExportButton = new Button(composite3, 8);
        this.fExportButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fExportButton));
        this.fExportButton.setText(TemplateMessages.getString("TemplatePreferencePage.export"));
        this.fExportButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplatePreferencePage.this.export();
            }
        });
        this.fExportAllButton = new Button(composite3, 8);
        this.fExportAllButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fExportAllButton));
        this.fExportAllButton.setText(TemplateMessages.getString("TemplatePreferencePage.export.all"));
        this.fExportAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplatePreferencePage.this.exportAll();
            }
        });
        this.createSpacer(composite3);
        this.fEnableAllButton = new Button(composite3, 8);
        this.fEnableAllButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fEnableAllButton));
        this.fEnableAllButton.setText(TemplateMessages.getString("TemplatePreferencePage.enable.all"));
        this.fEnableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplatePreferencePage.this.enableAll(true);
            }
        });
        this.fDisableAllButton = new Button(composite3, 8);
        this.fDisableAllButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fDisableAllButton));
        this.fDisableAllButton.setText(TemplateMessages.getString("TemplatePreferencePage.disable.all"));
        this.fDisableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplatePreferencePage.this.enableAll(false);
            }
        });
        this.fPatternViewer = this.createViewer(composite2);
        this.createSpacer(composite2);
        this.fTableViewer.setInput((Object)this.fTemplates);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
        this.updateButtons();
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.new_c_templates_pref_page_context");
        return composite2;
    }

    private Template[] getEnabledTemplates() {
        Template[] templateArray = this.fTemplates.getTemplates();
        ArrayList<Template> arrayList = new ArrayList<Template>(templateArray.length);
        int n = 0;
        while (n != templateArray.length) {
            if (templateArray[n].isEnabled()) {
                arrayList.add(templateArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Template[arrayList.size()]);
    }

    private SourceViewer createViewer(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(PreferencesMessages.getString("TemplatePreferencePage.Viewer.preview"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        SourceViewer sourceViewer = new SourceViewer(composite, null, 2816);
        CTextTools cTextTools = CUIPlugin.getDefault().getTextTools();
        sourceViewer.configure((SourceViewerConfiguration)new CSourceViewerConfiguration(cTextTools, null));
        sourceViewer.setEditable(false);
        sourceViewer.setDocument((IDocument)new Document());
        sourceViewer.getTextWidget().setBackground(this.getShell().getDisplay().getSystemColor(22));
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        sourceViewer.getTextWidget().setFont(font);
        Control control = sourceViewer.getControl();
        gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData);
        return sourceViewer;
    }

    public void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.heightHint = 4;
        label.setLayoutData((Object)gridData);
    }

    private static GridData getButtonGridData(Button button) {
        GridData gridData = new GridData(768);
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        gridData.heightHint = SWTUtil.getButtonHeigthHint(button);
        return gridData;
    }

    protected void selectionChanged1() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (iStructuredSelection.size() == 1) {
            Template template = (Template)iStructuredSelection.getFirstElement();
            this.fPatternViewer.getTextWidget().setText(template.getPattern());
        } else {
            this.fPatternViewer.getTextWidget().setText("");
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int n = ((IStructuredSelection)this.fTableViewer.getSelection()).size();
        int n2 = this.fTableViewer.getTable().getItemCount();
        this.fEditButton.setEnabled(n == 1);
        this.fExportButton.setEnabled(n > 0);
        this.fRemoveButton.setEnabled(n > 0 && n <= n2);
        this.fEnableAllButton.setEnabled(n2 > 0);
        this.fDisableAllButton.setEnabled(n2 > 0);
    }

    protected void add() {
        Object object;
        String string;
        Template template = new Template();
        ContextTypeRegistry contextTypeRegistry = ContextTypeRegistry.getInstance();
        ContextType contextType = contextTypeRegistry.getContextType("C Global");
        if (contextType != null) {
            string = contextType.getName();
        } else {
            object = contextTypeRegistry.iterator();
            string = (String)object.next();
        }
        template.setContext(string);
        object = new EditTemplateDialog(this.getShell(), template, false);
        if (object.open() == 0) {
            this.fTemplates.add(template);
            this.fTableViewer.refresh();
            this.fTableViewer.setChecked((Object)template, template.isEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)template));
        }
    }

    protected void edit() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        if (objectArray == null || objectArray.length != 1) {
            return;
        }
        Template template = (Template)iStructuredSelection.getFirstElement();
        this.edit(template);
    }

    private void edit(Template template) {
        Template template2 = new Template(template);
        EditTemplateDialog editTemplateDialog = new EditTemplateDialog(this.getShell(), template2, true);
        if (editTemplateDialog.open() == 0) {
            if (!template2.getName().equals(template.getName()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)TemplateMessages.getString("TemplatePreferencePage.question.create.new.title"), (String)TemplateMessages.getString("TemplatePreferencePage.question.create.new.message"))) {
                template = template2;
                this.fTemplates.add(template);
                this.fTableViewer.refresh();
            } else {
                template.setName(template2.getName());
                template.setDescription(template2.getDescription());
                template.setContext(template2.getContextTypeName());
                template.setPattern(template2.getPattern());
                this.fTableViewer.refresh((Object)template);
            }
            this.fTableViewer.setChecked((Object)template, template.isEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)template));
        }
    }

    protected void import_() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(TemplateMessages.getString("TemplatePreferencePage.import.title"));
        fileDialog.setFilterExtensions(new String[]{TemplateMessages.getString("TemplatePreferencePage.import.extension")});
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        try {
            this.fTemplates.addFromFile(new File(string));
            this.fTableViewer.refresh();
            this.fTableViewer.setAllChecked(false);
            this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
        }
        catch (CoreException coreException) {
            this.openReadErrorDialog(coreException);
        }
    }

    protected void exportAll() {
        this.export(this.fTemplates);
    }

    protected void export() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        TemplateSet templateSet = new TemplateSet();
        int n = 0;
        while (n != objectArray.length) {
            templateSet.add((Template)objectArray[n]);
            ++n;
        }
        this.export(templateSet);
    }

    private void export(TemplateSet templateSet) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText(TemplateMessages.getFormattedString("TemplatePreferencePage.export.title", new Integer(templateSet.getTemplates().length)));
        fileDialog.setFilterExtensions(new String[]{TemplateMessages.getString("TemplatePreferencePage.export.extension")});
        fileDialog.setFileName(TemplateMessages.getString("TemplatePreferencePage.export.filename"));
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists() || this.confirmOverwrite(file)) {
            try {
                templateSet.saveToFile(file);
            }
            catch (CoreException coreException) {
                CUIPlugin.getDefault().log(coreException);
                this.openWriteErrorDialog(coreException);
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)TemplateMessages.getString("TemplatePreferencePage.export.exists.title"), (String)TemplateMessages.getFormattedString("TemplatePreferencePage.export.exists.message", file.getAbsolutePath()));
    }

    protected void remove() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Template template = (Template)iterator.next();
            this.fTemplates.remove(template);
        }
        this.fTableViewer.refresh();
    }

    protected void enableAll(boolean bl) {
        Template[] templateArray = this.fTemplates.getTemplates();
        int n = 0;
        while (n != templateArray.length) {
            templateArray[n].setEnabled(bl);
            ++n;
        }
        this.fTableViewer.setAllChecked(bl);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setTitle(TemplateMessages.getString("TemplatePreferencePage.title"));
        }
    }

    protected void performDefaults() {
        try {
            this.fTemplates.restoreDefaults();
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException);
            this.openReadErrorDialog(coreException);
        }
        this.fTableViewer.refresh();
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
    }

    public boolean performOk() {
        try {
            this.fTemplates.save();
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException);
            this.openWriteErrorDialog(coreException);
        }
        return super.performOk();
    }

    public boolean performCancel() {
        try {
            this.fTemplates.reset();
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException);
            this.openReadErrorDialog(coreException);
        }
        return super.performCancel();
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(PREF_FORMAT_TEMPLATES, true);
    }

    public static boolean useCodeFormatter() {
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(PREF_FORMAT_TEMPLATES);
    }

    private void openReadErrorDialog(CoreException coreException) {
        ErrorDialog.openError((Shell)this.getShell(), (String)TemplateMessages.getString("TemplatePreferencePage.error.read.title"), null, (IStatus)coreException.getStatus());
    }

    private void openWriteErrorDialog(CoreException coreException) {
        ErrorDialog.openError((Shell)this.getShell(), (String)TemplateMessages.getString("TemplatePreferencePage.error.write.title"), null, (IStatus)coreException.getStatus());
    }
}

