/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CCommentScanner
extends AbstractCScanner {
    private static final String TRANSLATION_TASK_TAGS = "org.eclipse.cdt.core.translation.taskTags";
    protected static final String TASK_TAG = "c_comment_task_tag";
    private TaskTagRule fTaskTagRule;
    private Preferences fCorePreferenceStore;
    private String fDefaultTokenProperty;
    private String[] fTokenProperties;

    public CCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, Preferences preferences, String string) {
        this(iColorManager, iPreferenceStore, preferences, string, new String[]{string, TASK_TAG});
    }

    public CCommentScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, Preferences preferences, String string, String[] stringArray) {
        super(iColorManager, iPreferenceStore);
        this.fCorePreferenceStore = preferences;
        this.fDefaultTokenProperty = string;
        this.fTokenProperties = stringArray;
        this.initialize();
    }

    protected List createRules() {
        ArrayList<TaskTagRule> arrayList = new ArrayList<TaskTagRule>();
        if (this.fCorePreferenceStore != null) {
            this.fTaskTagRule = new TaskTagRule((IToken)this.getToken(TASK_TAG));
            String string = this.fCorePreferenceStore.getString(TRANSLATION_TASK_TAGS);
            this.fTaskTagRule.addTaskTags(string);
            arrayList.add(this.fTaskTagRule);
        }
        this.setDefaultReturnToken((IToken)this.getToken(this.fDefaultTokenProperty));
        return arrayList;
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getProperty().equals(TRANSLATION_TASK_TAGS) || super.affectsBehavior(propertyChangeEvent);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fTaskTagRule != null && propertyChangeEvent.getProperty().equals(TRANSLATION_TASK_TAGS)) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof String) {
                this.fTaskTagRule.clearTaskTags();
                this.fTaskTagRule.addTaskTags((String)object);
            }
        } else if (super.affectsBehavior(propertyChangeEvent)) {
            super.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    protected String[] getTokenProperties() {
        return this.fTokenProperties;
    }

    private static class TaskTagDetector
    implements IWordDetector {
        TaskTagDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }

    private class TaskTagRule
    extends WordRule {
        private IToken fToken;

        public TaskTagRule(IToken iToken) {
            super((IWordDetector)new TaskTagDetector(), Token.UNDEFINED);
            this.fToken = iToken;
        }

        public void clearTaskTags() {
            this.fWords.clear();
        }

        public void addTaskTags(String string) {
            String[] stringArray = this.split(string, ",");
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].length() > 0) {
                    this.addWord(stringArray[n], this.fToken);
                }
                ++n;
            }
        }

        private String[] split(String string, String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
            return stringArray;
        }
    }
}

