/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;

public class ProblemItemMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap fPathToItem = new HashMap();
    private Stack fReuseLists = new Stack();

    public void problemsChanged(Collection collection, ILabelProvider iLabelProvider) {
        if (collection.size() <= this.fPathToItem.size()) {
            this.iterateChanges(collection, iLabelProvider);
        } else {
            this.iterateItems(collection, iLabelProvider);
        }
    }

    private void iterateChanges(Collection collection, ILabelProvider iLabelProvider) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IPath iPath = (IPath)iterator.next();
            Object v = this.fPathToItem.get(iPath);
            if (v == null) continue;
            if (v instanceof Item) {
                this.refreshIcon(iLabelProvider, (Item)v);
                continue;
            }
            List list = (List)v;
            int n = 0;
            while (n < list.size()) {
                this.refreshIcon(iLabelProvider, (Item)list.get(n));
                ++n;
            }
        }
    }

    private void iterateItems(Collection collection, ILabelProvider iLabelProvider) {
        Iterator iterator = this.fPathToItem.keySet().iterator();
        while (iterator.hasNext()) {
            IPath iPath = (IPath)iterator.next();
            if (!collection.contains(iPath)) continue;
            Object v = this.fPathToItem.get(iPath);
            if (v instanceof Item) {
                this.refreshIcon(iLabelProvider, (Item)v);
                continue;
            }
            List list = (List)v;
            int n = 0;
            while (n < list.size()) {
                this.refreshIcon(iLabelProvider, (Item)list.get(n));
                ++n;
            }
        }
    }

    private void refreshIcon(ILabelProvider iLabelProvider, Item item) {
        if (!item.isDisposed()) {
            Object object = item.getData();
            if (object instanceof ICElement) {
                ((ICElement)object).exists();
            }
            Image image = item.getImage();
            Image image2 = iLabelProvider.getImage(object);
            if (image2 != null && image2 != image) {
                item.setImage(image2);
            }
        }
    }

    public void addToMap(Object object, Item item) {
        IPath iPath = ProblemItemMapper.getCorrespondingPath(object);
        if (iPath != null) {
            Object v = this.fPathToItem.get(iPath);
            if (v == null) {
                this.fPathToItem.put(iPath, item);
            } else if (v instanceof Item) {
                if (v != item) {
                    List list = this.newList();
                    list.add(v);
                    list.add(item);
                    this.fPathToItem.put(iPath, list);
                }
            } else {
                List list = (List)v;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object object, Item item) {
        IPath iPath = ProblemItemMapper.getCorrespondingPath(object);
        if (iPath != null) {
            Object v = this.fPathToItem.get(iPath);
            if (v == null) {
                return;
            }
            if (v instanceof Item) {
                this.fPathToItem.remove(iPath);
            } else {
                List list = (List)v;
                list.remove(item);
                if (list.isEmpty()) {
                    this.fPathToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    private List newList() {
        if (!this.fReuseLists.isEmpty()) {
            return (List)this.fReuseLists.pop();
        }
        return new ArrayList(2);
    }

    private void releaseList(List list) {
        if (this.fReuseLists.size() < 10) {
            this.fReuseLists.push(list);
        }
    }

    public void clearMap() {
        this.fPathToItem.clear();
    }

    private static IPath getCorrespondingPath(Object object) {
        if (object instanceof ICElement) {
            ICElement iCElement = (ICElement)object;
            return iCElement.getPath();
        }
        if (object instanceof IResource) {
            return ((IResource)object).getFullPath();
        }
        return null;
    }
}

