/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.ui.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.CElementAdapterFactory;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.ResourceAdapterFactory;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.SharedTextColors;
import org.eclipse.cdt.internal.ui.editor.WorkingCopyManager;
import org.eclipse.cdt.internal.ui.editor.asm.AsmTextTools;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.internal.ui.preferences.CEditorPreferencePage;
import org.eclipse.cdt.internal.ui.preferences.CPluginPreferencePage;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.util.ProblemMarkerManager;
import org.eclipse.cdt.internal.ui.util.Util;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CUIPlugin
extends AbstractUIPlugin {
    private ISharedTextColors fSharedTextColors;
    public static final String PLUGIN_ID = "org.eclipse.cdt.ui";
    public static final String PLUGIN_CORE_ID = "org.eclipse.cdt.core";
    public static final String EDITOR_ID = "org.eclipse.cdt.ui.editor.CEditor";
    public static final String CONSOLE_ID = "org.eclipse.cdt.ui.BuildConsoleView";
    public static final String CVIEW_ID = "org.eclipse.cdt.ui.CView";
    public static final String C_PROBLEMMARKER = "org.eclipse.cdt.core.problem";
    public static final String C_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCWizard";
    public static final String CPP_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCCWizard";
    public static final String FILE_WIZARD_ID = "org.eclipse.ui.wizards.new.file";
    public static final String FOLDER_WIZARD_ID = "org.eclipse.ui.wizards.new.folder";
    public static final String CLASS_WIZARD_ID = "org.eclipse.cdt.ui.wizards.NewClassWizard";
    public static final String SEARCH_ACTION_SET_ID = "org.eclipse.cdt.ui.SearchActionSet";
    public static final String FOLDER_ACTION_SET_ID = "org.eclipse.cdt.ui.CFolderActionSet";
    public static final String BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    private static CUIPlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    static String SEPARATOR;
    private static final String CONTENTASSIST = "org.eclipse.cdt.ui/debug/contentassist";
    private CoreModel fCoreModel;
    private CDocumentProvider fDocumentProvider;
    private WorkingCopyManager fWorkingCopyManager;
    private CTextTools fTextTools;
    private AsmTextTools fAsmTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private BuildConsoleManager fBuildConsoleManager;
    private ResourceAdapterFactory fResourceAdapterFactory;
    private CElementAdapterFactory fCElementAdapterFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        SEPARATOR = System.getProperty("file.separator");
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.ui.CPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public static IBufferFactory getBufferFactory() {
        CDocumentProvider cDocumentProvider = CUIPlugin.getDefault().getDocumentProvider();
        if (cDocumentProvider != null) {
            return cDocumentProvider.getBufferFactory();
        }
        return null;
    }

    public static IWorkingCopy[] getSharedWorkingCopies() {
        return CCorePlugin.getSharedWorkingCopies((IBufferFactory)CUIPlugin.getBufferFactory());
    }

    public static String getResourceString(String string) {
        try {
            return fgResourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + string + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + string + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String string, String string2) {
        return MessageFormat.format(CUIPlugin.getResourceString(string), string2);
    }

    public static String getFormattedString(String string, String[] stringArray) {
        return MessageFormat.format(CUIPlugin.getResourceString(string), stringArray);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return CUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = CUIPlugin.getDefault().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public Shell getActiveWorkbenchShell() {
        return this.getActiveWorkbenchWindow().getShell();
    }

    public static CUIPlugin getDefault() {
        return fgCPlugin;
    }

    public void log(Throwable throwable) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", throwable));
    }

    public void log(IStatus iStatus) {
        this.getLog().log(iStatus);
    }

    public static void errorDialog(Shell shell, String string, String string2, IStatus iStatus) {
        CUIPlugin.getDefault().log(iStatus);
        if (iStatus != null && string2.equals(iStatus.getMessage())) {
            string2 = null;
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
    }

    public static void errorDialog(Shell shell, String string, String string2, Throwable throwable) {
        IStatus iStatus;
        CUIPlugin.getDefault().log(throwable);
        if (throwable instanceof CoreException) {
            iStatus = ((CoreException)throwable).getStatus();
            if (iStatus != null && string2.equals(iStatus.getMessage())) {
                string2 = null;
            }
        } else {
            iStatus = new Status(4, PLUGIN_ID, -1, "Internal Error: ", throwable);
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
    }

    public CUIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        fgCPlugin = this;
        this.fDocumentProvider = null;
        this.fTextTools = null;
    }

    public synchronized CDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new CDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            CDocumentProvider cDocumentProvider = this.getDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(cDocumentProvider);
        }
        return this.fWorkingCopyManager;
    }

    public CTextTools getTextTools() {
        if (this.fTextTools == null) {
            this.fTextTools = new CTextTools(this.getPreferenceStore(), CCorePlugin.getDefault().getPluginPreferences());
        }
        return this.fTextTools;
    }

    public AsmTextTools getAsmTextTools() {
        if (this.fAsmTextTools == null) {
            this.fAsmTextTools = new AsmTextTools(this.getPreferenceStore(), CCorePlugin.getDefault().getPluginPreferences());
        }
        return this.fAsmTextTools;
    }

    public IBuildConsoleManager getConsoleManager() {
        if (this.fBuildConsoleManager == null) {
            this.fBuildConsoleManager = new BuildConsoleManager();
            this.fBuildConsoleManager.startup();
        }
        return this.fBuildConsoleManager;
    }

    public void shutdown() throws CoreException {
        if (this.fTextTools != null) {
            this.fTextTools.dispose();
        }
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        if (this.fBuildConsoleManager != null) {
            this.fBuildConsoleManager.shutdown();
            this.fBuildConsoleManager = null;
        }
        this.unregisterAdapters();
        super.shutdown();
        if (this.fWorkingCopyManager != null) {
            this.fWorkingCopyManager.shutdown();
            this.fWorkingCopyManager = null;
        }
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.shutdown();
            this.fDocumentProvider = null;
        }
    }

    private void runUI(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void startup() throws CoreException {
        super.startup();
        CUIPlugin.getDefault().configurePluginDebugOptions();
        this.runUI(new Runnable(){

            public void run() {
                CUIPlugin.this.registerAdapters();
                CPluginImages.initialize();
            }
        });
    }

    protected void initializeDefaultPreferences(final IPreferenceStore iPreferenceStore) {
        super.initializeDefaultPreferences(iPreferenceStore);
        PreferenceConstants.initializeDefaultValues(iPreferenceStore);
        this.runUI(new Runnable(){

            public void run() {
                CPluginPreferencePage.initDefaults(iPreferenceStore);
                CEditorPreferencePage.initDefaults(iPreferenceStore);
                CView.initDefaults(iPreferenceStore);
                BuildConsolePreferencePage.initDefaults(iPreferenceStore);
            }
        });
    }

    public CoreModel getCoreModel() {
        return this.fCoreModel;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return CUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    protected void registerAdapters() {
        this.fResourceAdapterFactory = new ResourceAdapterFactory();
        this.fCElementAdapterFactory = new CElementAdapterFactory();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)this.fResourceAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)this.fCElementAdapterFactory, (Class)clazz2);
    }

    private void unregisterAdapters() {
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        iAdapterManager.unregisterAdapters((IAdapterFactory)this.fResourceAdapterFactory);
        iAdapterManager.unregisterAdapters((IAdapterFactory)this.fCElementAdapterFactory);
    }

    public ISharedTextColors getSharedTextColors() {
        if (this.fSharedTextColors == null) {
            this.fSharedTextColors = new SharedTextColors();
        }
        return this.fSharedTextColors;
    }

    public void configurePluginDebugOptions() {
        String string;
        if (CUIPlugin.getDefault().isDebugging() && (string = Platform.getDebugOption((String)CONTENTASSIST)) != null) {
            Util.VERBOSE_CONTENTASSIST = string.equalsIgnoreCase("true");
        }
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> hashSet = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = CUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n2].getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (!hashSet.contains(iEditorInput)) {
                        hashSet.add(iEditorInput);
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    public static IEditorPart[] getInstanciatedEditors() {
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = CUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorReference[] iEditorReferenceArray = iWorkbenchPageArray[n2].getEditorReferences();
                int n3 = 0;
                while (n3 < iEditorReferenceArray.length) {
                    IEditorPart iEditorPart = iEditorReferenceArray[n3].getEditor(false);
                    if (iEditorPart != null) {
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }
}

