/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.ui.controls;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RadioButtonsArea
extends Composite {
    private String[][] labelsAndValues;
    private int numColumns;
    protected String value = null;
    private SelectionListener listener;
    private ArrayList externalListeners = new ArrayList();
    private Composite area = null;
    protected Button[] radioButtons;

    public RadioButtonsArea(Composite composite, String string, int n, String[][] stringArray) {
        super(composite, 0);
        Assert.isTrue((boolean)this.checkArray(stringArray));
        this.labelsAndValues = stringArray;
        this.numColumns = n;
        this.createControl(composite, string);
    }

    public void setEnabled(boolean bl) {
        int n = 0;
        while (n < this.radioButtons.length) {
            this.radioButtons[n].setEnabled(bl);
            ++n;
        }
    }

    private boolean checkArray(String[][] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            if (stringArray2 == null || stringArray2.length != 2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void fireSelectionEvent(SelectionEvent selectionEvent) {
        Iterator iterator = ((AbstractList)this.externalListeners).iterator();
        while (iterator.hasNext()) {
            SelectionListener selectionListener = (SelectionListener)iterator.next();
            selectionListener.widgetSelected(selectionEvent);
        }
    }

    protected void createControl(Composite composite, String string) {
        GridLayout gridLayout = new GridLayout();
        this.setLayoutData(new GridData(768));
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.area = string != null ? ControlFactory.createGroup(this, string, this.numColumns) : this;
        this.radioButtons = new Button[this.labelsAndValues.length];
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioButtonsArea.this.value = (String)selectionEvent.widget.getData();
                RadioButtonsArea.this.fireSelectionEvent(selectionEvent);
            }
        };
        int n = 0;
        while (n < this.labelsAndValues.length) {
            this.radioButtons[n] = ControlFactory.createRadioButton(this.area, this.labelsAndValues[n][0], this.labelsAndValues[n][1], this.listener);
            ++n;
        }
        this.area.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                RadioButtonsArea.this.radioButtons = null;
            }
        });
    }

    public void setIndent(int n) {
        if (this.area == null) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = 0;
        while (n2 < this.radioButtons.length) {
            ((GridData)this.radioButtons[n2].getLayoutData()).horizontalIndent = n;
            ++n2;
        }
    }

    public void setSelectValue(String string) {
        this.value = string;
        if (this.radioButtons == null) {
            return;
        }
        if (this.value != null) {
            boolean bl = false;
            int n = 0;
            while (n < this.radioButtons.length) {
                Button button = this.radioButtons[n];
                boolean bl2 = false;
                if (((String)button.getData()).equals(this.value)) {
                    bl2 = true;
                    bl = true;
                }
                button.setSelection(bl2);
                ++n;
            }
            if (bl) {
                return;
            }
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (String)this.radioButtons[0].getData();
        }
    }

    public void setSelectedButton(int n) {
        Button button;
        if (n < 0 || n >= this.radioButtons.length) {
            return;
        }
        int n2 = 0;
        while (n2 < this.radioButtons.length) {
            button = this.radioButtons[n2];
            boolean bl = button.getSelection();
            if (n2 == n) {
                if (bl) {
                    return;
                }
            } else if (bl) {
                button.setSelection(false);
            }
            ++n2;
        }
        button = this.radioButtons[n];
        button.setSelection(true);
    }

    public String getSelectedValue() {
        return this.value;
    }

    public int getSeletedIndex() {
        if (this.radioButtons == null) {
            return -1;
        }
        if (this.value != null) {
            int n = 0;
            while (n < this.radioButtons.length) {
                if (((String)this.radioButtons[n].getData()).equals(this.value)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this.externalListeners.contains(selectionListener)) {
            return;
        }
        this.externalListeners.add(selectionListener);
    }
}

