/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICOwner;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class COwner
implements ICOwnerInfo {
    String ownerID;
    String fPlatform;
    IExtension extension;

    public COwner(String string) throws CoreException {
        this.ownerID = string;
        IExtensionPoint iExtensionPoint = CCorePlugin.getDefault().getDescriptor().getExtensionPoint("CProject");
        this.extension = iExtensionPoint.getExtension(this.ownerID);
        if (this.extension == null) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("COwner.exception.invalidOwnerID"), null);
            throw new CoreException((IStatus)status);
        }
    }

    public String getID() {
        return this.ownerID;
    }

    public String getName() {
        return this.extension == null ? null : this.extension.getLabel();
    }

    public String getPlatform() {
        if (this.fPlatform == null) {
            IConfigurationElement[] iConfigurationElementArray = this.extension.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n].getName().equalsIgnoreCase("cproject")) {
                    this.fPlatform = iConfigurationElementArray[n].getAttribute("platform");
                    break;
                }
                ++n;
            }
        }
        return this.fPlatform == null ? "*" : this.fPlatform;
    }

    void configure(IProject iProject, ICDescriptor iCDescriptor) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = this.extension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equalsIgnoreCase("cproject")) {
                ICOwner iCOwner = (ICOwner)iConfigurationElementArray[n].createExecutableExtension("class");
                iCOwner.configure(iCDescriptor);
                return;
            }
            ++n;
        }
        Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("COwner.exception.invalidOwnerExtension"), null);
        throw new CoreException((IStatus)status);
    }

    void update(IProject iProject, ICDescriptor iCDescriptor, String string) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = this.extension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equalsIgnoreCase("cproject")) {
                ICOwner iCOwner = (ICOwner)iConfigurationElementArray[n].createExecutableExtension("class");
                iCOwner.update(iCDescriptor, string);
                return;
            }
            ++n;
        }
        Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("COwner.exception.invalidOwnerExtension"), null);
        throw new CoreException((IStatus)status);
    }
}

